/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.Collection;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class Variable
implements TemplateEntry {
    private final String variableName;
    private final boolean special;

    public Variable(String variableName) {
        if (variableName.toLowerCase().startsWith("special:")) {
            this.variableName = variableName.substring("special:".length());
            this.special = !this.variableName.toLowerCase().startsWith("special:");
        } else {
            this.variableName = variableName;
            this.special = false;
        }
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        if (this.special && "everything".equals(this.variableName)) {
            Collection<String> keys = dataProvider.getTemplateKeys();
            boolean first = true;
            for (String key : keys) {
                if (!first) {
                    result.append(", ");
                } else {
                    first = false;
                }
                result.append(key).append("=").append(dataProvider.getTemplateValue(key, false));
            }
        } else {
            Object value = dataProvider.getTemplateValue(this.variableName, this.special);
            if (value != null) {
                result.append(value);
            }
        }
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        if (this.special && "everything".equals(this.variableName)) {
            return true;
        }
        return dataProvider.getTemplateValue(this.variableName, this.special) != null;
    }

    public String toString() {
        return "{" + this.variableName + "}";
    }

    public boolean isSpecial() {
        return this.special;
    }
}

