/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class ContextSwitchTemplate
implements TemplateEntry {
    private static final TemplateEngineDataProvider EMTPY_PROVIDER = new TemplateEngineDataProvider(){

        @Override
        public Object getTemplateValue(String name, boolean special) {
            return null;
        }

        @Override
        public Collection<String> getTemplateKeys() {
            return Collections.emptyList();
        }

        @Override
        public boolean evaluateCondition(SearchCompiler.Match condition) {
            return false;
        }
    };
    private final ContextProvider context;
    private final TemplateEntry template;

    private SearchCompiler.Match transform(SearchCompiler.Match m, int searchExpressionPosition) throws ParseError {
        if (m instanceof SearchCompiler.Parent) {
            SearchCompiler.Match child = this.transform(((SearchCompiler.Parent)m).getOperand(), searchExpressionPosition);
            return new ParentSet(child);
        }
        if (m instanceof SearchCompiler.Child) {
            SearchCompiler.Match parent = this.transform(((SearchCompiler.Child)m).getOperand(), searchExpressionPosition);
            return new ChildSet(parent);
        }
        if (m instanceof SearchCompiler.And) {
            SearchCompiler.Match lhs = this.transform(((SearchCompiler.And)m).getLhs(), searchExpressionPosition);
            SearchCompiler.Match rhs = this.transform(((SearchCompiler.And)m).getRhs(), searchExpressionPosition);
            if (lhs instanceof ContextProvider && rhs instanceof ContextProvider) {
                return new AndSet((ContextProvider)lhs, (ContextProvider)rhs);
            }
            if (lhs instanceof ContextProvider) {
                ContextProvider cp = (ContextProvider)lhs;
                cp.condition = cp.condition == null ? rhs : new SearchCompiler.And(cp.condition, rhs);
                return cp;
            }
            if (rhs instanceof ContextProvider) {
                ContextProvider cp = (ContextProvider)rhs;
                cp.condition = cp.condition == null ? lhs : new SearchCompiler.And(lhs, cp.condition);
                return cp;
            }
            return m;
        }
        if (m instanceof SearchCompiler.Or) {
            SearchCompiler.Match lhs = this.transform(((SearchCompiler.Or)m).getLhs(), searchExpressionPosition);
            SearchCompiler.Match rhs = this.transform(((SearchCompiler.Or)m).getRhs(), searchExpressionPosition);
            if (lhs instanceof ContextProvider && rhs instanceof ContextProvider) {
                return new OrSet((ContextProvider)lhs, (ContextProvider)rhs);
            }
            if (lhs instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - right side of or(|) expression must return set of primitives", searchExpressionPosition));
            }
            if (rhs instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - left side of or(|) expression must return set of primitives", searchExpressionPosition));
            }
            return m;
        }
        if (m instanceof SearchCompiler.Not) {
            SearchCompiler.Match match = this.transform(((SearchCompiler.Not)m).getMatch(), searchExpressionPosition);
            if (match instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - not(-) cannot be used in this context", searchExpressionPosition));
            }
            return m;
        }
        return m;
    }

    public ContextSwitchTemplate(SearchCompiler.Match match, TemplateEntry template, int searchExpressionPosition) throws ParseError {
        SearchCompiler.Match m = this.transform(match, searchExpressionPosition);
        if (!(m instanceof ContextProvider)) {
            throw new ParseError(I18n.tr("Error in search expression on position {0} - expression must return different then current primitive", searchExpressionPosition));
        }
        this.context = (ContextProvider)m;
        this.template = template;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        List<OsmPrimitive> primitives = this.context.getPrimitives((OsmPrimitive)dataProvider);
        if (primitives != null && !primitives.isEmpty()) {
            this.template.appendText(result, primitives.get(0));
        } else {
            this.template.appendText(result, EMTPY_PROVIDER);
        }
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        List<OsmPrimitive> primitives = this.context.getPrimitives((OsmPrimitive)dataProvider);
        if (primitives != null && !primitives.isEmpty()) {
            return this.template.isValid(primitives.get(0));
        }
        return false;
    }

    private class AndSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        AndSet(ContextProvider lhs, ContextProvider rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
            List<OsmPrimitive> lhsList = this.lhs.getPrimitives(root);
            for (OsmPrimitive o : this.rhs.getPrimitives(root)) {
                if (!lhsList.contains(o) || this.condition != null && !this.condition.match(o)) continue;
                result.add(o);
            }
            return result;
        }
    }

    private class OrSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        OrSet(ContextProvider lhs, ContextProvider rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive o : this.lhs.getPrimitives(root)) {
                if (this.condition != null && !this.condition.match(o)) continue;
                result.add(o);
            }
            for (OsmPrimitive o : this.rhs.getPrimitives(root)) {
                if (this.condition != null && (!this.condition.match(o) || result.contains(o))) continue;
                result.add(o);
            }
            return result;
        }
    }

    private class ChildSet
    extends ContextProvider {
        private final SearchCompiler.Match parentCondition;

        ChildSet(SearchCompiler.Match parentCondition) {
            this.parentCondition = parentCondition;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            List<OsmPrimitive> parents = this.parentCondition instanceof ContextProvider ? ((ContextProvider)this.parentCondition).getPrimitives(root) : (this.parentCondition.match(root) ? Collections.singletonList(root) : Collections.emptyList());
            ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive p : parents) {
                if (p instanceof Way) {
                    for (Node n : ((Way)p).getNodes()) {
                        if (this.condition != null && this.condition.match(n)) {
                            result.add(n);
                        }
                        result.add(n);
                    }
                    continue;
                }
                if (!(p instanceof Relation)) continue;
                for (RelationMember rm : ((Relation)p).getMembers()) {
                    if (this.condition == null || !this.condition.match(rm.getMember())) continue;
                    result.add(rm.getMember());
                }
            }
            return result;
        }
    }

    private class ParentSet
    extends ContextProvider {
        private final SearchCompiler.Match childCondition;

        ParentSet(SearchCompiler.Match child) {
            this.childCondition = child;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            List<OsmPrimitive> children = this.childCondition instanceof ContextProvider ? ((ContextProvider)this.childCondition).getPrimitives(root) : (this.childCondition.match(root) ? Collections.singletonList(root) : Collections.emptyList());
            ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive child : children) {
                for (OsmPrimitive parent : child.getReferrers(true)) {
                    if (this.condition != null && !this.condition.match(parent)) continue;
                    result.add(parent);
                }
            }
            return result;
        }
    }

    private abstract class ContextProvider
    extends SearchCompiler.Match {
        SearchCompiler.Match condition;

        private ContextProvider() {
        }

        abstract List<OsmPrimitive> getPrimitives(OsmPrimitive var1);
    }
}

