/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.tools.template_engine.SearchExpressionCondition;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class Condition
implements TemplateEntry {
    private final List<TemplateEntry> entries = new ArrayList<TemplateEntry>();

    public List<TemplateEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry entry : this.entries) {
            if (!entry.isValid(dataProvider)) continue;
            entry.appendText(result, dataProvider);
            return;
        }
        TemplateEntry entry = this.entries.get(this.entries.size() - 1);
        entry.appendText(result, dataProvider);
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry entry : this.entries) {
            if (!entry.isValid(dataProvider)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("?{");
        for (TemplateEntry entry : this.entries) {
            if (entry instanceof SearchExpressionCondition) {
                sb.append(entry.toString());
            } else {
                sb.append("'");
                sb.append(entry.toString());
                sb.append("'");
            }
            sb.append("|");
        }
        return sb.toString();
    }
}

