/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class DateUtils {
    public static final BooleanProperty PROP_ISO_DATES = new BooleanProperty("iso.dates", false);
    private static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private static final DatatypeFactory XML_DATE;

    public static synchronized Date fromString(String str) {
        if (DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            calendar.set(DateUtils.parsePart(str, 0, 4), DateUtils.parsePart(str, 5, 2) - 1, DateUtils.parsePart(str, 8, 2), DateUtils.parsePart(str, 11, 2), DateUtils.parsePart(str, 14, 2), DateUtils.parsePart(str, 17, 2));
            if (str.length() == 25) {
                int plusHr = DateUtils.parsePart(str, 20, 2);
                int mul = str.charAt(19) == '+' ? -3600000 : 3600000;
                calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)(plusHr * mul));
            }
            return calendar.getTime();
        }
        if (DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxxZ") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx+xx:00") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx-xx:00")) {
            calendar.set(DateUtils.parsePart(str, 0, 4), DateUtils.parsePart(str, 5, 2) - 1, DateUtils.parsePart(str, 8, 2), DateUtils.parsePart(str, 11, 2), DateUtils.parsePart(str, 14, 2), DateUtils.parsePart(str, 17, 2));
            long millis = DateUtils.parsePart(str, 20, 3);
            if (str.length() == 29) {
                millis += (long)(DateUtils.parsePart(str, 24, 2) * (str.charAt(23) == '+' ? -3600000 : 3600000));
            }
            calendar.setTimeInMillis(calendar.getTimeInMillis() + millis);
            return calendar.getTime();
        }
        SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date d = f.parse(str, new ParsePosition(0));
        if (d != null) {
            return d;
        }
        try {
            return XML_DATE.newXMLGregorianCalendar(str).toGregorianCalendar().getTime();
        }
        catch (Exception ex) {
            return new Date();
        }
    }

    public static synchronized String fromDate(Date date) {
        calendar.setTime(date);
        XMLGregorianCalendar xgc = XML_DATE.newXMLGregorianCalendar(calendar);
        if (calendar.get(14) == 0) {
            xgc.setFractionalSecond(null);
        }
        return xgc.toXMLFormat();
    }

    private static boolean checkLayout(String text, String pattern) {
        if (text.length() != pattern.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char pc = pattern.charAt(i);
            char tc = text.charAt(i);
            if (pc == 'x' && tc >= '0' && tc <= '9' || pc != 'x' && pc == tc) continue;
            return false;
        }
        return true;
    }

    private static int parsePart(String str, int off, int len) {
        return Integer.parseInt(str.substring(off, off + len));
    }

    public static final SimpleDateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static final SimpleDateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static final SimpleDateFormat newOsmApiDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
    }

    public static final DateFormat getDateFormat(int dateStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return DateUtils.newIsoDateFormat();
        }
        return DateFormat.getDateInstance(dateStyle, Locale.getDefault());
    }

    public static final String formatDate(Date date, int dateStyle) {
        CheckParameterUtil.ensureParameterNotNull(date, "date");
        return DateUtils.getDateFormat(dateStyle).format(date);
    }

    public static final DateFormat getTimeFormat(int timeStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        return DateFormat.getTimeInstance(timeStyle, Locale.getDefault());
    }

    public static final String formatTime(Date time, int timeStyle) {
        CheckParameterUtil.ensureParameterNotNull(time, "time");
        return DateUtils.getTimeFormat(timeStyle).format(time);
    }

    public static final DateFormat getDateTimeFormat(int dateStyle, int timeStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.getDefault());
    }

    public static final String formatDateTime(Date datetime, int dateStyle, int timeStyle) {
        CheckParameterUtil.ensureParameterNotNull(datetime, "datetime");
        return DateUtils.getDateTimeFormat(dateStyle, timeStyle).format(datetime);
    }

    static {
        calendar.setTimeInMillis(0L);
        DatatypeFactory fact = null;
        try {
            fact = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ce) {
            Main.error(ce);
        }
        XML_DATE = fact;
    }
}

