/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlParsingException
extends SAXException {
    private int columnNumber;
    private int lineNumber;

    public XmlParsingException(Exception e) {
        super(e);
    }

    public XmlParsingException(String message, Exception e) {
        super(message, e);
    }

    public XmlParsingException(String message) {
        super(message);
    }

    public XmlParsingException rememberLocation(Locator locator) {
        if (locator != null) {
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
        }
        return this;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (this.lineNumber == 0 && this.columnNumber == 0) {
            return msg;
        }
        if (msg == null) {
            msg = this.getClass().getName();
        }
        msg = msg + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
        return msg;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

