/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private Map<String, Entry> mapping = new HashMap<String, Entry>();
    private DefaultHandler parser;
    private List<Object> queue = new LinkedList<Object>();
    private Iterator<Object> queueIterator = null;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    public XmlObjectParser(DefaultHandler handler) {
        this.parser = handler;
    }

    private Iterable<Object> start(Reader in, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser saxParser = parserFactory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            reader.setContentHandler(contentHandler);
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException e) {
                Main.error("Cannot disable 'load-external-dtd' feature: " + e.getMessage());
            }
            reader.parse(new InputSource(in));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<Object> start(Reader in) throws SAXException {
        try {
            return this.start(in, this.parser);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<Object> startWithValidation(Reader in, String namespace, String schemaSource) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream mis = new CachedFile(schemaSource).getInputStream();){
            Schema schema = factory.newSchema(new StreamSource(mis));
            ValidatorHandler validator = schema.newValidatorHandler();
            validator.setContentHandler(this.parser);
            validator.setErrorHandler(this.parser);
            AddNamespaceFilter filter = new AddNamespaceFilter(namespace);
            filter.setContentHandler(validator);
            Iterable<Object> iterable = this.start(in, filter);
            return iterable;
        }
        catch (IOException e) {
            throw new SAXException(I18n.tr("Failed to load XML schema.", new Object[0]), e);
        }
    }

    public void map(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, false));
    }

    public void mapOnStart(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, true, false));
    }

    public void mapBoth(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    private static class Entry {
        Class<?> klass;
        boolean onStart;
        boolean both;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, Method> methods = new HashMap<String, Method>();

        public Entry(Class<?> klass, boolean onStart, boolean both) {
            this.klass = klass;
            this.onStart = onStart;
            this.both = both;
        }

        Field getField(String s) {
            if (this.fields.containsKey(s)) {
                return this.fields.get(s);
            }
            try {
                Field f = this.klass.getField(s);
                this.fields.put(s, f);
                return f;
            }
            catch (NoSuchFieldException ex) {
                this.fields.put(s, null);
                return null;
            }
        }

        Method getMethod(String s) {
            if (this.methods.containsKey(s)) {
                return this.methods.get(s);
            }
            for (Method m : this.klass.getMethods()) {
                if (!m.getName().equals(s) || m.getParameterTypes().length != 1) continue;
                this.methods.put(s, m);
                return m;
            }
            this.methods.put(s, null);
            return null;
        }
    }

    private class Parser
    extends DefaultHandler {
        Stack<Object> current = new Stack();
        StringBuilder characters = new StringBuilder(64);
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception e) throws XmlParsingException {
            throw new XmlParsingException(e).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String ns, String lname, String qname, Attributes a) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(qname)) {
                Class<?> klass = ((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).klass;
                try {
                    this.current.push(klass.newInstance());
                }
                catch (Exception e) {
                    this.throwException(e);
                }
                for (int i = 0; i < a.getLength(); ++i) {
                    this.setValue((Entry)XmlObjectParser.this.mapping.get(qname), a.getQName(i), a.getValue(i));
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).onStart) {
                    this.report();
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String ns, String lname, String qname) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(qname) && !((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).onStart) {
                this.report();
            } else if (XmlObjectParser.this.mapping.containsKey(qname) && this.characters != null && !this.current.isEmpty()) {
                this.setValue((Entry)XmlObjectParser.this.mapping.get(qname), qname, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(ch, start, length);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private Object getValueForClass(Class<?> klass, String value) {
            if (klass == Boolean.TYPE) {
                return this.parseBoolean(value);
            }
            if (klass == Integer.TYPE || klass == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (klass == Float.TYPE || klass == Double.TYPE) {
                return Double.parseDouble(value);
            }
            return value;
        }

        private void setValue(Entry entry, String fieldName, String value) throws SAXException {
            CheckParameterUtil.ensureParameterNotNull(entry, "entry");
            if ("class".equals(fieldName) || "default".equals(fieldName) || "throw".equals(fieldName) || "new".equals(fieldName) || "null".equals(fieldName)) {
                fieldName = fieldName + "_";
            }
            try {
                Object c = this.current.peek();
                Field f = entry.getField(fieldName);
                if (f == null && fieldName.startsWith(lang)) {
                    f = entry.getField("locale_" + fieldName.substring(lang.length()));
                }
                if (f != null && Modifier.isPublic(f.getModifiers()) && (String.class.equals(f.getType()) || Boolean.TYPE.equals(f.getType()))) {
                    f.set(c, this.getValueForClass(f.getType(), value));
                } else {
                    if (fieldName.startsWith(lang)) {
                        int l = lang.length();
                        fieldName = "set" + fieldName.substring(l, l + 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(l + 1);
                    } else {
                        fieldName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
                    }
                    Method m = entry.getMethod(fieldName);
                    if (m != null) {
                        m.invoke(c, this.getValueForClass(m.getParameterTypes()[0], value));
                    }
                }
            }
            catch (Exception e) {
                Main.error(e);
                this.throwException(e);
            }
        }

        private boolean parseBoolean(String s) {
            return s != null && !"0".equals(s) && !s.startsWith("off") && !s.startsWith("false") && !s.startsWith("no");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        public AddNamespaceFilter(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("".equals(uri)) {
                super.startElement(this.namespace, localName, qName, atts);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        }
    }
}

