/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class WindowGeometry {
    private Point topLeft;
    private Dimension extent;

    public static WindowGeometry centerOnScreen(Dimension extent) {
        return WindowGeometry.centerOnScreen(extent, "gui.geometry");
    }

    public static WindowGeometry centerOnScreen(Dimension extent, String preferenceKey) {
        Rectangle size = preferenceKey != null ? WindowGeometry.getScreenInfo(preferenceKey) : WindowGeometry.getFullScreenInfo();
        Point topLeft = new Point(size.x + Math.max(0, (size.width - extent.width) / 2), size.y + Math.max(0, (size.height - extent.height) / 2));
        return new WindowGeometry(topLeft, extent);
    }

    public static WindowGeometry centerInWindow(Component reference, Dimension extent) {
        Window parentWindow = null;
        while (reference != null && !(reference instanceof Window)) {
            reference = reference.getParent();
        }
        if (reference == null) {
            return new WindowGeometry(new Point(0, 0), extent);
        }
        parentWindow = (Window)reference;
        Point topLeft = new Point(Math.max(0, (parentWindow.getSize().width - extent.width) / 2), Math.max(0, (parentWindow.getSize().height - extent.height) / 2));
        topLeft.x += parentWindow.getLocation().x;
        topLeft.y += parentWindow.getLocation().y;
        return new WindowGeometry(topLeft, extent);
    }

    public WindowGeometry(Point topLeft, Dimension extent) {
        this.topLeft = topLeft;
        this.extent = extent;
    }

    public WindowGeometry(Rectangle rect) {
        this.topLeft = rect.getLocation();
        this.extent = rect.getSize();
    }

    public WindowGeometry(Window window) {
        this(window.getLocationOnScreen(), window.getSize());
    }

    public void fixScreen(Window window) {
        Rectangle oldScreen = WindowGeometry.getScreenInfo(this.getRectangle());
        Rectangle newScreen = WindowGeometry.getScreenInfo(new Rectangle(window.getLocationOnScreen(), window.getSize()));
        if (oldScreen.x != newScreen.x) {
            this.topLeft.x += newScreen.x - oldScreen.x;
        }
        if (oldScreen.y != newScreen.y) {
            this.topLeft.y += newScreen.y - oldScreen.y;
        }
    }

    protected int parseField(String preferenceKey, String preferenceValue, String field) throws WindowGeometryException {
        String v = "";
        try {
            Pattern p = Pattern.compile(field + "=(-?\\d+)", 2);
            Matcher m = p.matcher(preferenceValue);
            if (!m.find()) {
                throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not include ''{1}''. Cannot restore window geometry from preferences.", preferenceKey, field));
            }
            v = m.group(1);
            return Integer.parseInt(v);
        }
        catch (WindowGeometryException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not provide an int value for ''{1}''. Got {2}. Cannot restore window geometry from preferences.", preferenceKey, field, v));
        }
        catch (Exception e) {
            throw new WindowGeometryException(I18n.tr("Failed to parse field ''{1}'' in preference with key ''{0}''. Exception was: {2}. Cannot restore window geometry from preferences.", preferenceKey, field, e.toString()), e);
        }
    }

    protected final void initFromPreferences(String preferenceKey) throws WindowGeometryException {
        String value = Main.pref.get(preferenceKey);
        if (value == null || value.isEmpty()) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not exist. Cannot restore window geometry from preferences.", preferenceKey));
        }
        this.topLeft = new Point();
        this.extent = new Dimension();
        this.topLeft.x = this.parseField(preferenceKey, value, "x");
        this.topLeft.y = this.parseField(preferenceKey, value, "y");
        this.extent.width = this.parseField(preferenceKey, value, "width");
        this.extent.height = this.parseField(preferenceKey, value, "height");
    }

    protected final void initFromWindowGeometry(WindowGeometry other) {
        this.topLeft = other.topLeft;
        this.extent = other.extent;
    }

    public static WindowGeometry mainWindow(String preferenceKey, String arg, boolean maximize) {
        WindowGeometry def;
        Rectangle screenDimension = WindowGeometry.getScreenInfo("gui.geometry");
        if (arg != null) {
            Matcher m = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(arg);
            if (m.matches()) {
                int w = Integer.valueOf(m.group(1));
                int h = Integer.valueOf(m.group(2));
                int x = screenDimension.x;
                int y = screenDimension.y;
                if (m.group(3) != null) {
                    x = Integer.valueOf(m.group(5));
                    y = Integer.valueOf(m.group(7));
                    if ("-".equals(m.group(4))) {
                        x = screenDimension.x + screenDimension.width - x - w;
                    }
                    if ("-".equals(m.group(6))) {
                        y = screenDimension.y + screenDimension.height - y - h;
                    }
                }
                return new WindowGeometry(new Point(x, y), new Dimension(w, h));
            }
            Main.warn(I18n.tr("Ignoring malformed geometry: {0}", arg));
        }
        if (maximize) {
            def = new WindowGeometry(screenDimension);
        } else {
            Point p = screenDimension.getLocation();
            p.x += (screenDimension.width - 1000) / 2;
            p.y += (screenDimension.height - 740) / 2;
            def = new WindowGeometry(p, new Dimension(1000, 740));
        }
        return new WindowGeometry(preferenceKey, def);
    }

    public WindowGeometry(String preferenceKey) throws WindowGeometryException {
        this.initFromPreferences(preferenceKey);
    }

    public WindowGeometry(String preferenceKey, WindowGeometry defaultGeometry) {
        try {
            this.initFromPreferences(preferenceKey);
        }
        catch (WindowGeometryException e) {
            this.initFromWindowGeometry(defaultGeometry);
        }
    }

    public void remember(String preferenceKey) {
        StringBuilder value = new StringBuilder();
        value.append("x=").append(this.topLeft.x).append(",").append("y=").append(this.topLeft.y).append(",").append("width=").append(this.extent.width).append(",").append("height=").append(this.extent.height);
        Main.pref.put(preferenceKey, value.toString());
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Dimension getSize() {
        return this.extent;
    }

    private Rectangle getRectangle() {
        return new Rectangle(this.topLeft, this.extent);
    }

    public void applySafe(Window window) {
        Rectangle maxbounds;
        int deltay;
        Point p = new Point(this.topLeft);
        Dimension size = new Dimension(this.extent);
        Rectangle virtualBounds = WindowGeometry.getVirtualScreenBounds();
        if (p.x < virtualBounds.x) {
            p.x = virtualBounds.x;
        } else if (p.x > virtualBounds.x + virtualBounds.width - size.width) {
            p.x = virtualBounds.x + virtualBounds.width - size.width;
        }
        if (p.y < virtualBounds.y) {
            p.y = virtualBounds.y;
        } else if (p.y > virtualBounds.y + virtualBounds.height - size.height) {
            p.y = virtualBounds.y + virtualBounds.height - size.height;
        }
        int deltax = p.x + size.width - (virtualBounds.x + virtualBounds.width);
        if (deltax > 0) {
            size.width -= deltax;
        }
        if ((deltay = p.y + size.height - (virtualBounds.y + virtualBounds.height)) > 0) {
            size.height -= deltay;
        }
        if (!WindowGeometry.isBugInMaximumWindowBounds(maxbounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds())) {
            deltax = size.width - maxbounds.width;
            if (deltax > 0) {
                size.width -= deltax;
            }
            if ((deltay = size.height - maxbounds.height) > 0) {
                size.height -= deltay;
            }
        }
        window.setLocation(p);
        window.setSize(size);
    }

    protected static boolean isBugInMaximumWindowBounds(Rectangle maxbounds) {
        return maxbounds.width <= 0 || maxbounds.height <= 0;
    }

    public static Rectangle getVirtualScreenBounds() {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            if (gd.getType() != 0) continue;
            virtualBounds = virtualBounds.union(gd.getDefaultConfiguration().getBounds());
        }
        return virtualBounds;
    }

    public static Dimension getMaxDimensionOnScreen(JComponent component) {
        CheckParameterUtil.ensureParameterNotNull(component, "component");
        Dimension result = new Dimension();
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        if (gc == null && Main.parent != null) {
            gc = Main.parent.getGraphicsConfiguration();
        }
        if (gc != null) {
            Rectangle bounds = gc.getBounds();
            Insets insets = component.getToolkit().getScreenInsets(gc);
            result.width = bounds.width - insets.left - insets.right;
            result.height = bounds.height - insets.top - insets.bottom;
        }
        return result;
    }

    public static Rectangle getScreenInfo(String preferenceKey) {
        Rectangle g = new WindowGeometry(preferenceKey, new WindowGeometry(new Point(0, 0), new Dimension(10, 10))).getRectangle();
        return WindowGeometry.getScreenInfo(g);
    }

    private static Rectangle getScreenInfo(Rectangle g) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int intersect = 0;
        Rectangle bounds = null;
        for (GraphicsDevice gd : gs) {
            int s;
            Rectangle is;
            if (gd.getType() != 0) continue;
            Rectangle b = gd.getDefaultConfiguration().getBounds();
            if (b.height > 0 && b.width / b.height >= 3) {
                b.width /= 2;
                is = b.intersection(g);
                s = is.width * is.height;
                if (bounds == null || intersect < s) {
                    intersect = s;
                    bounds = b;
                }
                b = new Rectangle(b);
                b.x += b.width;
                is = b.intersection(g);
                s = is.width * is.height;
                if (bounds != null && intersect >= s) continue;
                intersect = s;
                bounds = b;
                continue;
            }
            is = b.intersection(g);
            s = is.width * is.height;
            if (bounds != null && intersect >= s) continue;
            intersect = s;
            bounds = b;
        }
        return bounds;
    }

    public static Rectangle getFullScreenInfo() {
        return new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
    }

    public String toString() {
        return "WindowGeometry{topLeft=" + this.topLeft + ",extent=" + this.extent + "}";
    }

    public static class WindowGeometryException
    extends Exception {
        public WindowGeometryException(String message, Throwable cause) {
            super(message, cause);
        }

        public WindowGeometryException(String message) {
            super(message);
        }
    }
}

