/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String baseurl) {
        this.baseurl = baseurl;
    }

    public WikiReader() {
        this(Main.pref.get("help.baseurl", Main.getJOSMWebsite()));
    }

    public final String getBaseUrlWiki() {
        return this.baseurl + "/wiki/";
    }

    public String read(String url) throws IOException {
        URL u = new URL(url);
        try (BufferedReader in = Utils.openURLReader(u);){
            boolean txt = url.endsWith("?format=txt");
            if (url.startsWith(this.getBaseUrlWiki()) && !txt) {
                String string = this.readFromTrac(in, u);
                return string;
            }
            String string = this.readNormal(in, !txt);
            return string;
        }
    }

    public String readLang(String text) throws IOException {
        String res = "";
        String languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.DEFAULTNOTENGLISH);
        if (languageCode != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty() && (languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.BASELANGUAGE)) != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty() && (languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.ENGLISH)) != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty()) {
            throw new IOException(text + " does not exist");
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLang(URL url) throws IOException {
        try (BufferedReader in = Utils.openURLReader(url);){
            String string = this.readFromTrac(in, url);
            return string;
        }
        catch (IOException e) {
            Main.addNetworkError(url, Utils.getRootCause(e));
            throw e;
        }
    }

    private String readNormal(BufferedReader in, boolean html) throws IOException {
        StringBuilder b = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            if (!line.contains("[[TranslatedPages]]")) {
                b.append(line.replaceAll(" />", ">")).append("\n");
            }
            line = in.readLine();
        }
        return html ? "<html>" + b + "</html>" : b.toString();
    }

    protected String readFromTrac(BufferedReader in, URL url) throws IOException {
        boolean inside = false;
        boolean transl = false;
        boolean skip = false;
        String b = "";
        String full = "";
        String line = in.readLine();
        while (line != null) {
            full = full + line;
            if (line.contains("<div id=\"searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"wiki-toc trac-nav\"")) {
                transl = true;
            } else if (line.contains("<div class=\"wikipage searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"buttons\">")) {
                inside = false;
            } else if (line.contains("<h3>Attachments</h3>")) {
                inside = false;
            } else if (line.contains("<div id=\"attachments\">")) {
                inside = false;
            } else if (line.contains("<div class=\"trac-modifiedby\">")) {
                skip = true;
            }
            if (inside && !transl && !skip) {
                b = b + line.replaceAll("<img ", "<img border=\"0\" ").replaceAll("<span class=\"icon\">.</span>", "").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (transl && line.contains("</div>")) {
                transl = false;
            }
            if (line.contains("</div>")) {
                skip = false;
            }
            line = in.readLine();
        }
        if (b.indexOf("      Describe ") >= 0 || b.indexOf(" does not exist. You can create it here.</p>") >= 0) {
            return "";
        }
        if (b.isEmpty()) {
            b = full;
        }
        return "<html><base href=\"" + url.toExternalForm() + "\"> " + b + "</html>";
    }
}

