/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class Utils {
    public static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+");
    public static final String URL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=%";
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern HTTP_PREFFIX_PATTERN = Pattern.compile("https?");

    private Utils() {
    }

    public static <T> boolean exists(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        for (T item : collection) {
            if (!predicate.evaluate(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean forAll(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        return !Utils.exists(collection, Predicates.not(predicate));
    }

    public static <T> boolean exists(Iterable<T> collection, Class<? extends T> klass) {
        for (T item : collection) {
            if (!klass.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        for (T item : collection) {
            if (!predicate.evaluate(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T find(Iterable<? super T> collection, Class<? extends T> klass) {
        for (T item : collection) {
            if (!klass.isInstance(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> Collection<T> filter(Collection<? extends T> collection, Predicate<? super T> predicate) {
        return new FilteredCollection<T>(collection, predicate);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... items) {
        for (T i : items) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public static <S, T extends S> SubclassFilteredCollection<S, T> filteredCollection(Collection<S> collection, final Class<T> klass) {
        return new SubclassFilteredCollection(collection, new Predicate<S>(){

            @Override
            public boolean evaluate(S o) {
                return klass.isInstance(o);
            }
        });
    }

    public static <T> int indexOf(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        int i = 0;
        for (T item : collection) {
            if (predicate.evaluate(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int min(int a, int b, int c) {
        if (b < c) {
            if (a < b) {
                return a;
            }
            return b;
        }
        if (a < c) {
            return a;
        }
        return c;
    }

    public static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static void ensure(boolean condition, String message, Object ... data) {
        if (!condition) {
            throw new AssertionError((Object)MessageFormat.format(message, data));
        }
    }

    public static int mod(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be <= 0 but is " + n);
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    public static String join(String sep, Collection<?> values) {
        CheckParameterUtil.ensureParameterNotNull(sep, "sep");
        if (values == null) {
            return null;
        }
        StringBuilder s = null;
        for (Object a : values) {
            if (a == null) {
                a = "";
            }
            if (s != null) {
                s.append(sep).append(a.toString());
                continue;
            }
            s = new StringBuilder(a.toString());
        }
        return s != null ? s.toString() : "";
    }

    public static String joinAsHtmlUnorderedList(Iterable<?> values) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<ul>");
        for (Object i : values) {
            sb.append("<li>").append(i).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static String toString(Color c) {
        if (c == null) {
            return "null";
        }
        if (c.getAlpha() == 255) {
            return String.format("#%06x", c.getRGB() & 0xFFFFFF);
        }
        return String.format("#%06x(alpha=%d)", c.getRGB() & 0xFFFFFF, c.getAlpha());
    }

    public static Integer color_float2int(Float val) {
        if (val == null) {
            return null;
        }
        if (val.floatValue() < 0.0f || val.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * val.floatValue() + 0.5f);
    }

    public static Float color_int2float(Integer val) {
        if (val == null) {
            return null;
        }
        if (val < 0 || val > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)val.intValue() / 255.0f);
    }

    public static Color complement(Color clr) {
        return new Color(255 - clr.getRed(), 255 - clr.getGreen(), 255 - clr.getBlue(), clr.getAlpha());
    }

    public static <T> T[] copyArray(T[] array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return null;
    }

    public static char[] copyArray(char[] array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return null;
    }

    public static int[] copyArray(int[] array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return null;
    }

    public static Path copyFile(File in, File out) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        return Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File in, File out) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        if (!out.exists() && !out.mkdirs()) {
            Main.warn("Unable to create directory " + out.getPath());
        }
        for (File f : in.listFiles()) {
            File target = new File(out, f.getName());
            if (f.isDirectory()) {
                Utils.copyDirectory(f, target);
                continue;
            }
            Utils.copyFile(f, target);
        }
    }

    public static int copyStream(InputStream source, OutputStream destination) throws IOException {
        int read;
        int count = 0;
        byte[] b = new byte[512];
        while ((read = source.read(b)) != -1) {
            count += read;
            destination.write(b, 0, read);
        }
        return count;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    Utils.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                Main.warn("Unable to delete file: " + file.getPath());
            }
        }
        return path.delete();
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            Main.warn(e);
        }
    }

    public static void close(ZipFile zip) {
        if (zip == null) {
            return;
        }
        try {
            zip.close();
        }
        catch (IOException e) {
            Main.warn(e);
        }
    }

    public static URL fileToURL(File f) {
        if (f != null) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                Main.error("Unable to convert filename " + f.getAbsolutePath() + " to URL");
            }
        }
        return null;
    }

    public static boolean equalsEpsilon(double a, double b) {
        return Math.abs(a - b) <= 1.0E-11;
    }

    public static boolean copyToClipboard(String s) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clpbrd, Transferable t) {
                }
            });
            return true;
        }
        catch (IllegalStateException ex) {
            Main.error(ex);
            return false;
        }
    }

    public static String getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = null;
        for (int tries = 0; t == null && tries < 10; ++tries) {
            try {
                t = clipboard.getContents(null);
                continue;
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Main.warn("InterruptedException in " + Utils.class.getSimpleName() + " while getting clipboard content");
                }
            }
        }
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Main.error(ex);
            return null;
        }
        return null;
    }

    public static String md5Hex(String data) {
        byte[] byteData = data.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] byteDigest = md.digest(byteData);
        return Utils.toHexString(byteDigest);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len == 0) {
            return "";
        }
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            byte v = bytes[i];
            hexChars[j++] = HEX_ARRAY[(v & 0xF0) >> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static <T> List<T> topologicalSort(MultiMap<T, T> dependencies) {
        MultiMap<Object, T> deps = new MultiMap<Object, T>();
        for (T key : dependencies.keySet()) {
            deps.putVoid(key);
            for (T val : dependencies.get(key)) {
                deps.putVoid(val);
                deps.put(key, val);
            }
        }
        int size = deps.size();
        ArrayList sorted = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object parentless = null;
            for (Object key : deps.keySet()) {
                if (!deps.get(key).isEmpty()) continue;
                parentless = key;
                break;
            }
            if (parentless == null) {
                throw new RuntimeException();
            }
            sorted.add(parentless);
            deps.remove(parentless);
            for (Object key : deps.keySet()) {
                deps.remove(key, parentless);
            }
        }
        if (sorted.size() != size) {
            throw new RuntimeException();
        }
        return sorted;
    }

    public static <A, B> Collection<B> transform(final Collection<? extends A> c, final Function<A, B> f) {
        return new AbstractCollection<B>(){

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private Iterator<? extends A> it;
                    {
                        this.it = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public B next() {
                        return f.apply(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <A, B> List<B> transform(final List<? extends A> l, final Function<A, B> f) {
        return new AbstractList<B>(){

            @Override
            public int size() {
                return l.size();
            }

            @Override
            public B get(int index) {
                return f.apply(l.get(index));
            }
        };
    }

    public static HttpURLConnection openHttpConnection(URL httpURL) throws IOException {
        if (httpURL == null || !HTTP_PREFFIX_PATTERN.matcher(httpURL.getProtocol()).matches()) {
            throw new IllegalArgumentException("Invalid HTTP url");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("Opening HTTP connection to " + httpURL.toExternalForm());
        }
        HttpURLConnection connection = (HttpURLConnection)httpURL.openConnection();
        connection.setRequestProperty("User-Agent", Version.getInstance().getFullAgentString());
        connection.setUseCaches(false);
        return connection;
    }

    public static InputStream openURL(URL url) throws IOException {
        return Utils.openURLAndDecompress(url, false);
    }

    public static InputStream openURLAndDecompress(URL url, boolean decompress) throws IOException {
        URLConnection connection = Utils.setupURLConnection(url.openConnection());
        InputStream in = connection.getInputStream();
        if (decompress) {
            switch (connection.getHeaderField("Content-Type")) {
                case "application/zip": {
                    return Utils.getZipInputStream(in);
                }
                case "application/x-gzip": {
                    return Utils.getGZipInputStream(in);
                }
                case "application/x-bzip2": {
                    return Utils.getBZip2InputStream(in);
                }
            }
        }
        return in;
    }

    public static BZip2CompressorInputStream getBZip2InputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new BZip2CompressorInputStream(in, true);
    }

    public static GZIPInputStream getGZipInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new GZIPInputStream(in);
    }

    public static ZipInputStream getZipInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(in, StandardCharsets.UTF_8);
        ZipEntry ze = zis.getNextEntry();
        if (ze != null && Main.isDebugEnabled()) {
            Main.debug("Zip entry: " + ze.getName());
        }
        return zis;
    }

    public static URLConnection setupURLConnection(URLConnection connection) {
        if (connection != null) {
            connection.setRequestProperty("User-Agent", Version.getInstance().getFullAgentString());
            connection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
            connection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
        }
        return connection;
    }

    public static BufferedReader openURLReader(URL url) throws IOException {
        return Utils.openURLReaderAndDecompress(url, false);
    }

    public static BufferedReader openURLReaderAndDecompress(URL url, boolean decompress) throws IOException {
        return new BufferedReader(new InputStreamReader(Utils.openURLAndDecompress(url, decompress), StandardCharsets.UTF_8));
    }

    public static HttpURLConnection openHttpConnection(URL httpURL, boolean keepAlive) throws IOException {
        HttpURLConnection connection = Utils.openHttpConnection(httpURL);
        if (!keepAlive) {
            connection.setRequestProperty("Connection", "close");
        }
        if (Main.isDebugEnabled()) {
            try {
                Main.debug("REQUEST: " + connection.getRequestProperties());
            }
            catch (IllegalStateException e) {
                Main.warn(e);
            }
        }
        return connection;
    }

    public static String strip(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int start = 0;
        int end = str.length();
        boolean leadingWhite = true;
        while (leadingWhite && start < end) {
            char c = str.charAt(start);
            leadingWhite = Character.isWhitespace(c) || Character.isSpaceChar(c) || c == '\u200b' || c == '\ufeff';
            if (!leadingWhite) continue;
            ++start;
        }
        boolean trailingWhite = true;
        while (trailingWhite && end > start + 1) {
            char c = str.charAt(end - 1);
            trailingWhite = Character.isWhitespace(c) || Character.isSpaceChar(c) || c == '\u200b' || c == '\ufeff';
            if (!trailingWhite) continue;
            --end;
        }
        return str.substring(start, end);
    }

    public static String execOutput(List<String> command) throws IOException {
        if (Main.isDebugEnabled()) {
            Main.debug(Utils.join(" ", command));
        }
        Process p = new ProcessBuilder(command).start();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder all = null;
            while ((line = input.readLine()) != null) {
                if (all == null) {
                    all = new StringBuilder(line);
                    continue;
                }
                all.append("\n");
                all.append(line);
            }
            String string = all != null ? all.toString() : null;
            return string;
        }
    }

    public static File getJosmTempDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            return null;
        }
        File josmTmpDir = new File(tmpDir, "JOSM");
        if (!josmTmpDir.exists() && !josmTmpDir.mkdirs()) {
            Main.warn("Unable to create temp directory " + josmTmpDir);
        }
        return josmTmpDir;
    }

    public static String getDurationString(long elapsedTime) {
        if (elapsedTime < 0L) {
            throw new IllegalArgumentException("elapsedTime must be >= 0");
        }
        if (elapsedTime < 1000L) {
            return String.format("%d %s", elapsedTime, I18n.tr("ms", new Object[0]));
        }
        if (elapsedTime < 60000L) {
            return String.format("%.1f %s", Float.valueOf((float)elapsedTime / 1000.0f), I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < 3600000L) {
            long min = elapsedTime / 60000L;
            return String.format("%d %s %d %s", min, I18n.tr("min", new Object[0]), (elapsedTime - min * 60000L) / 1000L, I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < 86400000L) {
            long hour = elapsedTime / 3600000L;
            return String.format("%d %s %d %s", hour, I18n.tr("h", new Object[0]), (elapsedTime - hour * 3600000L) / 60000L, I18n.tr("min", new Object[0]));
        }
        long days = elapsedTime / 86400000L;
        return String.format("%d %s %d %s", days, I18n.trn("day", "days", days, new Object[0]), (elapsedTime - days * 86400000L) / 3600000L, I18n.tr("h", new Object[0]));
    }

    public static String getPositionListString(List<Integer> positionList) {
        Collections.sort(positionList);
        StringBuilder sb = new StringBuilder(32);
        sb.append(positionList.get(0));
        int cnt = 0;
        int last = positionList.get(0);
        for (int i = 1; i < positionList.size(); ++i) {
            int cur = positionList.get(i);
            if (cur == last + 1) {
                ++cnt;
            } else if (cnt == 0) {
                sb.append(",").append(cur);
            } else {
                sb.append("-").append(last);
                sb.append(",").append(cur);
                cnt = 0;
            }
            last = cur;
        }
        if (cnt >= 1) {
            sb.append("-").append(last);
        }
        return sb.toString();
    }

    public static List<String> getMatches(Matcher m) {
        if (m.matches()) {
            ArrayList<String> result = new ArrayList<String>(m.groupCount() + 1);
            for (int i = 0; i <= m.groupCount(); ++i) {
                result.add(m.group(i));
            }
            return result;
        }
        return null;
    }

    public static <T> T cast(Object o, Class<T> klass) {
        if (klass.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        if (result != null) {
            Throwable cause = result.getCause();
            while (cause != null && !cause.equals(result)) {
                result = cause;
                cause = result.getCause();
            }
        }
        return result;
    }

    public static <T> T[] addInArrayCopy(T[] array, T item) {
        T[] biggerCopy = Arrays.copyOf(array, array.length + 1);
        biggerCopy[array.length] = item;
        return biggerCopy;
    }

    public static String shortenString(String s, int maxLength) {
        if (s != null && s.length() > maxLength) {
            return s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static String fixURLQuery(String url) {
        if (url.indexOf(63) == -1) {
            return url;
        }
        String query = url.substring(url.indexOf(63) + 1);
        StringBuilder sb = new StringBuilder(url.substring(0, url.indexOf(63) + 1));
        for (int i = 0; i < query.length(); ++i) {
            String c = query.substring(i, i + 1);
            if (URL_CHARS.contains(c)) {
                sb.append(c);
                continue;
            }
            try {
                sb.append(URLEncoder.encode(c, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return sb.toString();
    }

    public static boolean isLocalUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://") && !url.startsWith("resource://");
    }

    public static Pair<Integer, ExecutorService> newThreadPool(String pref2) {
        int noThreads = Main.pref.getInteger(pref2, Runtime.getRuntime().availableProcessors());
        ExecutorService pool = noThreads <= 1 ? null : Executors.newFixedThreadPool(noThreads);
        return new Pair<Integer, ExecutorService>(noThreads, pool);
    }

    public static String updateSystemProperty(String key, String value) {
        if (value != null) {
            String old = System.setProperty(key, value);
            if (!key.toLowerCase().contains("password")) {
                Main.debug("System property '" + key + "' set to '" + value + "'. Old value was '" + old + "'");
            } else {
                Main.debug("System property '" + key + "' changed.");
            }
            return old;
        }
        return null;
    }

    public static interface Function<A, B> {
        public B apply(A var1);
    }
}

