/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public final class TextTagParser {
    protected static final int MAX_KEY_LENGTH = Main.pref.getInteger("tags.paste.max-key-length", 50);
    protected static final int MAX_KEY_COUNT = Main.pref.getInteger("tags.paste.max-key-count", 30);
    protected static final String KEY_PATTERN = Main.pref.get("tags.paste.tag-pattern", "[0-9a-zA-Z:_]*");
    protected static final int MAX_VALUE_LENGTH = 255;

    protected static String unescape(String k) {
        if (!k.startsWith("\"") || !k.endsWith("\"")) {
            if (k.contains("=")) {
                return null;
            }
            return k;
        }
        String text = k.substring(1, k.length() - 1);
        return new TextAnalyzer(text).parseString("\r\t\n");
    }

    public static Map<String, String> readTagsByRegexp(String text, String splitRegex, String tagRegex, boolean unescapeTextInQuotes) {
        String[] lines = text.split(splitRegex);
        Pattern p = Pattern.compile(tagRegex);
        HashMap<String, String> tags = new HashMap<String, String>();
        String k = null;
        String v = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                k = m.group(1).trim();
                v = m.group(2).trim();
                if (unescapeTextInQuotes) {
                    k = TextTagParser.unescape(k);
                    v = TextTagParser.unescape(v);
                    if (k == null || v == null) {
                        return null;
                    }
                }
                tags.put(k, v);
                continue;
            }
            return null;
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return null;
    }

    public static Map<String, String> getValidatedTagsFromText(String buf) {
        Map<String, String> tags = TextTagParser.readTagsFromText(buf);
        return TextTagParser.validateTags(tags) ? tags : null;
    }

    public static Map<String, String> readTagsFromText(String buf) {
        Map<String, String> tags = TextTagParser.readTagsByRegexp(buf, "[\\r\\n]+", ".*([a-zA-Z0-9:_]+).*\\t(.*?)", false);
        if (tags != null) {
            return tags;
        }
        tags = TextTagParser.readTagsByRegexp(buf, "[\\n\\t\\r]+", "(.*?)=(.*?)", true);
        if (tags != null) {
            return tags;
        }
        String bufJson = buf.trim();
        if (bufJson.startsWith("{") && bufJson.endsWith("}")) {
            bufJson = bufJson.substring(1, bufJson.length() - 1);
        }
        if ((tags = TextTagParser.readTagsByRegexp(bufJson, "[\\s]*,[\\s]*", "[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*:[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*", true)) != null) {
            return tags;
        }
        TextAnalyzer parser = new TextAnalyzer(buf);
        tags = parser.getFreeParsedTags();
        return tags;
    }

    public static boolean validateTags(Map<String, String> tags) {
        int r;
        int s = tags.size();
        if (s > MAX_KEY_COUNT) {
            r = TextTagParser.warning(I18n.trn("There was {0} tag found in the buffer, it is suspicious!", "There were {0} tags found in the buffer, it is suspicious!", s, s), "", "tags.paste.toomanytags");
            if (r == 2 || r == 3) {
                return false;
            }
            if (r == 4) {
                return true;
            }
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.length() > MAX_KEY_LENGTH) {
                r = TextTagParser.warning(I18n.tr("Key is too long (max {0} characters):", MAX_KEY_LENGTH), key + "=" + value, "tags.paste.keytoolong");
                if (r == 2 || r == 3) {
                    return false;
                }
                if (r == 4) {
                    return true;
                }
            }
            if (!key.matches(KEY_PATTERN)) {
                r = TextTagParser.warning(I18n.tr("Suspicious characters in key:", new Object[0]), key, "tags.paste.keydoesnotmatch");
                if (r == 2 || r == 3) {
                    return false;
                }
                if (r == 4) {
                    return true;
                }
            }
            if (value.length() <= 255) continue;
            r = TextTagParser.warning(I18n.tr("Value is too long (max {0} characters):", 255), value, "tags.paste.valuetoolong");
            if (r == 2 || r == 3) {
                return false;
            }
            if (r != 4) continue;
            return true;
        }
        return true;
    }

    private static int warning(String text, String data, String code) {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Do you want to paste these tags?", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Clear buffer", new Object[0]), I18n.tr("Ignore warnings", new Object[0])});
        ed.setButtonIcons(new String[]{"ok", "cancel", "dialogs/delete", "pastetags"});
        ed.setContent("<html><b>" + text + "</b><br/><br/><div width=\"300px\">" + XmlWriter.encode(data, true) + "</html>");
        ed.setDefaultButton(2);
        ed.setCancelButton(2);
        ed.setIcon(2);
        ed.toggleEnable(code);
        ed.showDialog();
        int r = ed.getValue();
        if (r == 0) {
            r = 2;
        }
        if (r == 3) {
            Utils.copyToClipboard("");
        }
        return r;
    }

    public static void showBadBufferMessage(String helpTopic) {
        String msg = I18n.tr("<html><p> Sorry, it is impossible to paste tags from buffer. It does not contain any JOSM object or suitable text. </p></html>", new Object[0]);
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(msg), GBC.eop());
        String helpUrl = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(helpTopic, LanguageInfo.LocaleType.DEFAULT));
        if (helpUrl != null) {
            p.add((Component)new UrlLabel(helpUrl), GBC.eop());
        }
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Clear buffer", new Object[0])});
        ed.setButtonIcons(new String[]{"ok", "dialogs/delete"});
        ed.setContent(p);
        ed.setDefaultButton(1);
        ed.setCancelButton(1);
        ed.setIcon(2);
        ed.toggleEnable("tags.paste.cleanbadbuffer");
        ed.showDialog();
        int r = ed.getValue();
        if (r == 2) {
            Utils.copyToClipboard("");
        }
    }

    public static class TextAnalyzer {
        boolean quotesStarted = false;
        boolean esc = false;
        StringBuilder s = new StringBuilder(200);
        int pos = 0;
        String data;
        int n;

        public TextAnalyzer(String text) {
            this.data = text;
            this.n = this.data.length();
        }

        Map<String, String> getFreeParsedTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            while (true) {
                this.skipEmpty();
                if (this.pos == this.n) break;
                String k = this.parseString("\n\r\t= ");
                if (this.pos == this.n) {
                    tags.clear();
                    break;
                }
                this.skipSign();
                if (this.pos == this.n) {
                    tags.clear();
                    break;
                }
                String v = this.parseString("\n\r\t ");
                tags.put(k, v);
            }
            return tags;
        }

        private String parseString(String stopChars) {
            char[] stop = stopChars.toCharArray();
            Arrays.sort(stop);
            while (this.pos < this.n) {
                char c = this.data.charAt(this.pos);
                if (this.esc) {
                    this.esc = false;
                    this.s.append(c);
                } else if (c == '\\') {
                    this.esc = true;
                } else if (c == '\"' && !this.quotesStarted) {
                    if (this.s.toString().trim().length() > 0) {
                        this.s.append(c);
                    } else {
                        this.s.delete(0, this.s.length());
                        this.quotesStarted = true;
                    }
                } else {
                    if (c == '\"' && this.quotesStarted) {
                        this.quotesStarted = false;
                        ++this.pos;
                        break;
                    }
                    if (!this.quotesStarted && Arrays.binarySearch(stop, c) >= 0) {
                        ++this.pos;
                        break;
                    }
                    if (c >= ' ') {
                        this.s.append(c);
                    }
                }
                ++this.pos;
            }
            String res = this.s.toString();
            this.s.delete(0, this.s.length());
            return res.trim();
        }

        private void skipSign() {
            boolean signFound = false;
            while (this.pos < this.n) {
                char c = this.data.charAt(this.pos);
                if (c == '\t' || c == '\n' || c == ' ') {
                    ++this.pos;
                    continue;
                }
                if (c != '=' || signFound) break;
                signFound = true;
                ++this.pos;
            }
        }

        private void skipEmpty() {
            char c;
            while (this.pos < this.n && ((c = this.data.charAt(this.pos)) == '\t' || c == '\n' || c == '\r' || c == ' ')) {
                ++this.pos;
            }
        }
    }
}

