/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;

public final class Shortcut {
    private String shortText;
    private String longText;
    private final int requestedKey;
    private final int requestedGroup;
    private int assignedKey;
    private int assignedModifier;
    private boolean assignedDefault;
    private boolean assignedUser;
    private boolean automatic;
    private boolean reset;
    private static Map<String, Shortcut> shortcuts = new LinkedHashMap<String, Shortcut>();
    private static Map<Integer, Integer> groups = new HashMap<Integer, Integer>();
    public static final int NONE = 5000;
    public static final int MNEMONIC = 5001;
    public static final int RESERVED = 5002;
    public static final int DIRECT = 5003;
    public static final int ALT = 5004;
    public static final int SHIFT = 5005;
    public static final int CTRL = 5006;
    public static final int ALT_SHIFT = 5007;
    public static final int ALT_CTRL = 5008;
    public static final int CTRL_SHIFT = 5009;
    public static final int ALT_CTRL_SHIFT = 5010;
    private static int[] mods = new int[]{5008, 5007, 5009, 5010};
    private static int[] keys = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123};
    private static boolean initdone = false;

    private Shortcut(String shortText, String longText, int requestedKey, int requestedGroup, int assignedKey, int assignedModifier, boolean assignedDefault, boolean assignedUser) {
        this.shortText = shortText;
        this.longText = longText;
        this.requestedKey = requestedKey;
        this.requestedGroup = requestedGroup;
        this.assignedKey = assignedKey;
        this.assignedModifier = assignedModifier;
        this.assignedDefault = assignedDefault;
        this.assignedUser = assignedUser;
        this.automatic = false;
        this.reset = false;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    private void setLongText(String longText) {
        this.longText = longText;
    }

    public int getAssignedKey() {
        return this.assignedKey;
    }

    public int getAssignedModifier() {
        return this.assignedModifier;
    }

    public boolean getAssignedDefault() {
        return this.assignedDefault;
    }

    public boolean getAssignedUser() {
        return this.assignedUser;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public boolean isChangeable() {
        return !this.automatic && !"core:none".equals(this.shortText);
    }

    private boolean getReset() {
        return this.reset;
    }

    public void setAutomatic() {
        this.automatic = true;
    }

    public void setAssignedModifier(int assignedModifier) {
        this.assignedModifier = assignedModifier;
    }

    public void setAssignedKey(int assignedKey) {
        this.assignedKey = assignedKey;
    }

    public void setAssignedUser(boolean assignedUser) {
        boolean bl = this.reset = (this.assignedUser || this.reset) && !assignedUser;
        if (assignedUser) {
            this.assignedDefault = false;
        } else if (this.reset) {
            this.assignedKey = this.requestedKey;
            this.assignedModifier = Shortcut.findModifier(this.requestedGroup, null);
        }
        this.assignedUser = assignedUser;
    }

    public KeyStroke getKeyStroke() {
        if (this.assignedModifier != -1) {
            return KeyStroke.getKeyStroke(this.assignedKey, this.assignedModifier);
        }
        return null;
    }

    private Shortcut(String prefString) {
        ArrayList<String> s = new ArrayList<String>(Main.pref.getCollection(prefString));
        this.shortText = prefString.substring(15);
        this.longText = (String)s.get(0);
        this.requestedKey = Integer.parseInt((String)s.get(1));
        this.requestedGroup = Integer.parseInt((String)s.get(2));
        this.assignedKey = Integer.parseInt((String)s.get(3));
        this.assignedModifier = Integer.parseInt((String)s.get(4));
        this.assignedDefault = Boolean.parseBoolean((String)s.get(5));
        this.assignedUser = Boolean.parseBoolean((String)s.get(6));
    }

    private void saveDefault() {
        Main.pref.getCollection("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.requestedKey), String.valueOf(Shortcut.getGroupModifier(this.requestedGroup)), String.valueOf(true), String.valueOf(false)));
    }

    private boolean save() {
        if (this.getAutomatic() || this.getReset() || !this.getAssignedUser()) {
            return Main.pref.putCollection("shortcut.entry." + this.shortText, null);
        }
        return Main.pref.putCollection("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.assignedKey), String.valueOf(this.assignedModifier), String.valueOf(this.assignedDefault), String.valueOf(this.assignedUser)));
    }

    private boolean isSame(int isKey, int isModifier) {
        return isKey == this.assignedKey && isModifier == this.assignedModifier && this.assignedModifier != Shortcut.getGroupModifier(5000);
    }

    public boolean isEvent(KeyEvent e) {
        return this.getKeyStroke() != null && this.getKeyStroke().equals(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()));
    }

    public void setMnemonic(JMenu menu) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            menu.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setMnemonic(AbstractButton button) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            button.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setAccelerator(AbstractAction action) {
        if (this.getKeyStroke() != null) {
            action.putValue("AcceleratorKey", this.getKeyStroke());
        }
    }

    public String getKeyText() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke == null) {
            return "";
        }
        String modifText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return modifText + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public String toString() {
        return this.getKeyText();
    }

    public static Shortcut findShortcut(int requestedKey, int modifier) {
        if (modifier == Shortcut.getGroupModifier(5000)) {
            return null;
        }
        for (Shortcut sc : shortcuts.values()) {
            if (!sc.isSame(requestedKey, modifier)) continue;
            return sc;
        }
        return null;
    }

    public static List<Shortcut> listAll() {
        ArrayList<Shortcut> l = new ArrayList<Shortcut>();
        for (Shortcut c : shortcuts.values()) {
            if ("core:none".equals(c.shortText)) continue;
            l.add(c);
        }
        return l;
    }

    private static void doInit() {
        if (initdone) {
            return;
        }
        initdone = true;
        int commandDownMask = GuiHelper.getMenuShortcutKeyMaskEx();
        groups.put(5000, -1);
        groups.put(5001, 512);
        groups.put(5003, 0);
        groups.put(5004, 512);
        groups.put(5005, 64);
        groups.put(5006, commandDownMask);
        groups.put(5007, 576);
        groups.put(5008, 0x200 | commandDownMask);
        groups.put(5009, commandDownMask | 0x40);
        groups.put(5010, 0x200 | commandDownMask | 0x40);
        Main.platform.initSystemShortcuts();
        LinkedList<Shortcut> newshortcuts = new LinkedList<Shortcut>();
        for (String s : Main.pref.getAllPrefixCollectionKeys("shortcut.entry.")) {
            newshortcuts.add(new Shortcut(s));
        }
        for (Shortcut sc : newshortcuts) {
            if (!sc.getAssignedUser() || Shortcut.findShortcut(sc.getAssignedKey(), sc.getAssignedModifier()) != null) continue;
            shortcuts.put(sc.getShortText(), sc);
        }
        for (Shortcut sc : newshortcuts) {
            if (sc.getAssignedUser() || !sc.getAssignedDefault() || Shortcut.findShortcut(sc.getAssignedKey(), sc.getAssignedModifier()) != null) continue;
            shortcuts.put(sc.getShortText(), sc);
        }
        for (Shortcut sc : newshortcuts) {
            if (sc.getAssignedUser() || sc.getAssignedDefault() || Shortcut.findShortcut(sc.getAssignedKey(), sc.getAssignedModifier()) != null) continue;
            shortcuts.put(sc.getShortText(), sc);
        }
    }

    private static int getGroupModifier(int group) {
        Integer m = groups.get(group);
        if (m == null) {
            m = -1;
        }
        return m;
    }

    private static int findModifier(int group, Integer modifier) {
        if (modifier == null && (modifier = Integer.valueOf(Shortcut.getGroupModifier(group))) == null) {
            modifier = Shortcut.getGroupModifier(5000);
        }
        return modifier;
    }

    public static boolean savePrefs() {
        boolean changed = false;
        for (Shortcut sc : shortcuts.values()) {
            changed |= sc.save();
        }
        return changed;
    }

    public static Shortcut registerSystemShortcut(String shortText, String longText, int key, int modifier) {
        if (shortcuts.containsKey(shortText)) {
            return shortcuts.get(shortText);
        }
        Shortcut potentialShortcut = Shortcut.findShortcut(key, modifier);
        if (potentialShortcut != null) {
            Main.error("CONFLICT WITH SYSTEM KEY " + shortText);
            return null;
        }
        potentialShortcut = new Shortcut(shortText, longText, key, 5002, key, modifier, true, false);
        shortcuts.put(shortText, potentialShortcut);
        return potentialShortcut;
    }

    public static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup) {
        return Shortcut.registerShortcut(shortText, longText, requestedKey, requestedGroup, null);
    }

    private static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup, Integer modifier) {
        Shortcut.doInit();
        Integer defaultModifier = Shortcut.findModifier(requestedGroup, modifier);
        if (shortcuts.containsKey(shortText)) {
            Shortcut sc = shortcuts.get(shortText);
            sc.setLongText(longText);
            sc.saveDefault();
            return sc;
        }
        Shortcut conflict = Shortcut.findShortcut(requestedKey, defaultModifier);
        if (conflict != null) {
            int newmodifier;
            if (Main.isPlatformOsx() && Shortcut.findShortcut(requestedKey, newmodifier = Shortcut.findNewOsxModifier(requestedGroup)) == null) {
                return Shortcut.reassignShortcut(shortText, longText, requestedKey, conflict, requestedGroup, requestedKey, newmodifier);
            }
            for (int m : mods) {
                for (int k : keys) {
                    int newmodifier2 = Shortcut.getGroupModifier(m);
                    if (Shortcut.findShortcut(k, newmodifier2) != null) continue;
                    return Shortcut.reassignShortcut(shortText, longText, requestedKey, conflict, m, k, newmodifier2);
                }
            }
        } else {
            Shortcut newsc = new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, defaultModifier, true, false);
            newsc.saveDefault();
            shortcuts.put(shortText, newsc);
            return newsc;
        }
        return null;
    }

    private static int findNewOsxModifier(int requestedGroup) {
        switch (requestedGroup) {
            case 5006: {
                return 128;
            }
            case 5008: {
                return 640;
            }
            case 5009: {
                return 192;
            }
            case 5010: {
                return 704;
            }
        }
        return 0;
    }

    private static Shortcut reassignShortcut(String shortText, String longText, int requestedKey, Shortcut conflict, int m, int k, int newmodifier) {
        Shortcut newsc = new Shortcut(shortText, longText, requestedKey, m, k, newmodifier, false, false);
        Main.info(I18n.tr("Silent shortcut conflict: ''{0}'' moved by ''{1}'' to ''{2}''.", shortText, conflict.getShortText(), newsc.getKeyText()));
        newsc.saveDefault();
        shortcuts.put(shortText, newsc);
        return newsc;
    }

    public static KeyStroke getCopyKeyStroke() {
        Shortcut sc = shortcuts.get("system:copy");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }

    public static KeyStroke getPasteKeyStroke() {
        Shortcut sc = shortcuts.get("system:paste");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }

    public static KeyStroke getCutKeyStroke() {
        Shortcut sc = shortcuts.get("system:cut");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }
}

