/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.geom.Area;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.Geometry;

public class RightAndLefthandTraffic {
    private static volatile Collection<Area> leftHandTrafficPolygons;
    private static volatile GeoPropertyIndex<Boolean> rlCache;

    public static synchronized boolean isRightHandTraffic(LatLon ll) {
        if (leftHandTrafficPolygons == null) {
            RightAndLefthandTraffic.initialize();
        }
        return rlCache.get(ll) == false;
    }

    private static void initialize() {
        leftHandTrafficPolygons = new ArrayList<Area>();
        try (InputStream is = new CachedFile("resource://data/left-right-hand-traffic.osm").getInputStream();){
            DataSet data = OsmReader.parseDataSet(is, null);
            for (Way w : data.getWays()) {
                leftHandTrafficPolygons.add(Geometry.getAreaLatLon(w.getNodes()));
            }
        }
        catch (IOException | IllegalDataException ex) {
            throw new RuntimeException(ex);
        }
        rlCache = new GeoPropertyIndex<Boolean>(new RLTrafficGeoProperty(), 24);
    }

    private static class RLTrafficGeoProperty
    implements GeoPropertyIndex.GeoProperty<Boolean> {
        private RLTrafficGeoProperty() {
        }

        @Override
        public Boolean get(LatLon ll) {
            for (Area a : leftHandTrafficPolygons) {
                if (!a.contains(ll.lon(), ll.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean get(BBox box) {
            Area abox = new Area(box.toRectangle());
            for (Area a : leftHandTrafficPolygons) {
                Geometry.PolygonIntersection is = Geometry.polygonIntersection(abox, a, 1.0E-10);
                if (is == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                    return true;
                }
                if (is == Geometry.PolygonIntersection.OUTSIDE) continue;
                return null;
            }
            return false;
        }
    }
}

