/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Predicate;

public final class Predicates {
    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T obj) {
                return !predicate.evaluate(obj);
            }
        };
    }

    public static <T> Predicate<T> equalTo(final T ref) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T obj) {
                return Objects.equals(obj, ref);
            }
        };
    }

    public static Predicate<String> stringMatchesPattern(final Pattern pattern) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return pattern.matcher(string).matches();
            }
        };
    }

    public static Predicate<String> stringContainsPattern(final Pattern pattern) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return pattern.matcher(string).find();
            }
        };
    }

    public static Predicate<String> stringContains(final String pattern) {
        return new Predicate<String>(){

            @Override
            public boolean evaluate(String string) {
                return string.contains(pattern);
            }
        };
    }

    public static Predicate<OsmPrimitive> hasTag(final String key, final String ... values) {
        return new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive p) {
                return p.hasTag(key, values);
            }
        };
    }

    public static Predicate<OsmPrimitive> hasKey(final String key) {
        return new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive p) {
                return p.hasKey(key);
            }
        };
    }

    public static <T> Predicate<T> inCollection(final Collection<? extends T> target) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T object) {
                return target.contains(object);
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T object) {
                return object == null;
            }
        };
    }
}

