/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookUnixoid
implements PlatformHook {
    private String osDescription;

    @Override
    public void preStartupHook() {
    }

    @Override
    public void afterPrefStartupHook() {
    }

    @Override
    public void startupHook() {
    }

    @Override
    public void openUrl(String url) throws IOException {
        for (String program : Main.pref.getCollection("browser.unix", Arrays.asList("xdg-open", "#DESKTOP#", "$BROWSER", "gnome-open", "kfmclient openURL", "firefox"))) {
            try {
                if ("#DESKTOP#".equals(program)) {
                    Desktop.getDesktop().browse(new URI(url));
                } else if (program.startsWith("$")) {
                    program = System.getenv().get(program.substring(1));
                    Runtime.getRuntime().exec(new String[]{program, url});
                } else {
                    Runtime.getRuntime().exec(new String[]{program, url});
                }
                return;
            }
            catch (IOException | URISyntaxException e) {
                Main.warn(e);
            }
        }
    }

    @Override
    public void initSystemShortcuts() {
        for (int i = 112; i <= 123; ++i) {
            Shortcut.registerSystemShortcut("screen:toogle" + i, I18n.tr("reserved", new Object[0]), i, 640).setAutomatic();
        }
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("system:resetX", I18n.tr("reserved", new Object[0]), 8, 640).setAutomatic();
    }

    @Override
    public String makeTooltip(String name, Shortcut sc) {
        String result = "";
        result = result + "<html>";
        result = result + name;
        if (sc != null && sc.getKeyText().length() != 0) {
            result = result + " ";
            result = result + "<font size='-2'>";
            result = result + "(" + sc.getKeyText() + ")";
            result = result + "</font>";
        }
        result = result + "&nbsp;</html>";
        return result;
    }

    @Override
    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    @Override
    public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    @Override
    public boolean rename(File from, File to) {
        return from.renameTo(to);
    }

    public static boolean isOpenJDK() {
        String javaHome = System.getProperty("java.home");
        return javaHome != null && javaHome.contains("openjdk");
    }

    public static String getPackageDetails(String ... packageNames) {
        try {
            boolean dpkg = Files.exists(Paths.get("/usr/bin/dpkg-query", new String[0]), new LinkOption[0]);
            boolean eque = Files.exists(Paths.get("/usr/bin/equery", new String[0]), new LinkOption[0]);
            boolean rpm = Files.exists(Paths.get("/bin/rpm", new String[0]), new LinkOption[0]);
            if (dpkg || rpm || eque) {
                for (String packageName : packageNames) {
                    String[] args = null;
                    args = dpkg ? new String[]{"dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", packageName} : (eque ? new String[]{"equery", "-q", "list", "-e", "--format=$fullversion", packageName} : new String[]{"rpm", "-q", "--qf", "%{arch}-%{version}", packageName});
                    String version = Utils.execOutput(Arrays.asList(args));
                    if (version == null || version.contains("not installed")) continue;
                    return packageName + ":" + version;
                }
            }
        }
        catch (IOException e) {
            Main.warn(e);
        }
        return null;
    }

    public String getJavaPackageDetails() {
        String home = System.getProperty("java.home");
        if (home.contains("java-7-openjdk") || home.contains("java-1.7.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-7-jre", "java-1_7_0-openjdk", "java-1.7.0-openjdk");
        }
        if (home.contains("icedtea")) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-bin");
        }
        if (home.contains("oracle")) {
            return PlatformHookUnixoid.getPackageDetails("oracle-jdk-bin", "oracle-jre-bin");
        }
        return null;
    }

    public String getWebStartPackageDetails() {
        if (PlatformHookUnixoid.isOpenJDK()) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-netx", "icedtea-web");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String buildOSDescription() {
        String osName = System.getProperty("os.name");
        if (!"Linux".equalsIgnoreCase(osName)) return osName;
        try {
            Process p = Runtime.getRuntime().exec("lsb_release -ds");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line = Utils.strip(input.readLine());
                if (line == null) return osName;
                if (line.isEmpty()) return osName;
                line = line.replaceAll("\"+", "");
                if ((line = line.replaceAll("NAME=", "")).startsWith("Linux ")) {
                    String string = line;
                    return string;
                }
                if (line.isEmpty()) return osName;
                String string = "Linux " + line;
                return string;
            }
        }
        catch (IOException e) {
            LinuxReleaseInfo[] arr$ = new LinuxReleaseInfo[]{new LinuxReleaseInfo("/etc/lsb-release", "DISTRIB_DESCRIPTION", "DISTRIB_ID", "DISTRIB_RELEASE"), new LinuxReleaseInfo("/etc/os-release", "PRETTY_NAME", "NAME", "VERSION"), new LinuxReleaseInfo("/etc/arch-release"), new LinuxReleaseInfo("/etc/debian_version", "Debian GNU/Linux "), new LinuxReleaseInfo("/etc/fedora-release"), new LinuxReleaseInfo("/etc/gentoo-release"), new LinuxReleaseInfo("/etc/redhat-release"), new LinuxReleaseInfo("/etc/SuSE-release")};
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                LinuxReleaseInfo info = arr$[i$];
                String description = info.extractDescription();
                if (description != null && !description.isEmpty()) {
                    return "Linux " + description;
                }
                ++i$;
            }
            return osName;
        }
    }

    @Override
    public String getOSDescription() {
        if (this.osDescription == null) {
            this.osDescription = this.buildOSDescription();
        }
        return this.osDescription;
    }

    protected void askUpdateJava(String version) {
        this.askUpdateJava(version, "https://www.java.com/download");
    }

    protected void askUpdateJava(final String version, final String url) {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Outdated Java version", new Object[0]), new String[]{I18n.tr("Update Java", new Object[0]), I18n.tr("Cancel", new Object[0])});
                if (!ed.toggleEnable("askUpdateJava8").toggleCheckState()) {
                    ed.setButtonIcons(new String[]{"java", "cancel"}).setCancelButton(2);
                    ed.setMinimumSize(new Dimension(480, 300));
                    ed.setIcon(2);
                    String content = I18n.tr("You are running version {0} of Java.", "<b>" + version + "</b>") + "<br><br>";
                    if ("Sun Microsystems Inc.".equals(System.getProperty("java.vendor")) && !PlatformHookUnixoid.isOpenJDK()) {
                        content = content + "<b>" + I18n.tr("This version is no longer supported by {0} since {1} and is not recommended for use.", "Oracle", I18n.tr("April 2015", new Object[0])) + "</b><br><br>";
                    }
                    content = content + "<b>" + I18n.tr("JOSM will soon stop working with this version; we highly recommend you to update to Java {0}.", "8") + "</b><br><br>" + I18n.tr("Would you like to update now ?", new Object[0]);
                    ed.setContent(content);
                    if (ed.showDialog().getValue() == 1) {
                        try {
                            PlatformHookUnixoid.this.openUrl(url);
                        }
                        catch (IOException e) {
                            Main.warn(e);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean setupHttpsCertificate(String entryAlias, KeyStore.TrustedCertificateEntry trustedCert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return false;
    }

    @Override
    public File getDefaultCacheDirectory() {
        return new File(Main.pref.getUserDataDirectory(), "cache");
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(System.getProperty("user.home"), ".josm");
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return Main.pref.getPreferencesDirectory();
    }

    protected void extendFontconfig(String templateFileName) {
        String customFontconfigFile = Main.pref.get("fontconfig.properties", null);
        if (customFontconfigFile != null) {
            Utils.updateSystemProperty("sun.awt.fontconfig", customFontconfigFile);
            return;
        }
        if (!Main.pref.getBoolean("font.extended-unicode", true)) {
            return;
        }
        String javaLibPath = System.getProperty("java.home") + File.separator + "lib";
        Path templateFile = FileSystems.getDefault().getPath(javaLibPath, templateFileName);
        if (!Files.isReadable(templateFile)) {
            Main.warn("extended font config - unable to find font config template file " + templateFile.toString());
            return;
        }
        try (FileInputStream fis = new FileInputStream(templateFile.toFile());){
            Properties props = new Properties();
            props.load(fis);
            byte[] content = Files.readAllBytes(templateFile);
            File cachePath = Main.pref.getCacheDirectory();
            Path fontconfigFile = cachePath.toPath().resolve("fontconfig.properties");
            OutputStream os = Files.newOutputStream(fontconfigFile, new OpenOption[0]);
            os.write(content);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
                String prevValue;
                String value;
                String key;
                List<FontEntry> extrasPref = Main.pref.getListOfStructs("font.extended-unicode.extra-items", this.getAdditionalFonts(), FontEntry.class);
                ArrayList<FontEntry> extras = new ArrayList<FontEntry>();
                w.append("\n\n# Added by JOSM to extend unicode coverage of Java font support:\n\n");
                ArrayList<String> allCharSubsets = new ArrayList<String>();
                for (FontEntry entry : extrasPref) {
                    Collection<String> fontsAvail = this.getInstalledFonts();
                    if (fontsAvail != null && fontsAvail.contains(entry.file.toUpperCase())) {
                        if (!allCharSubsets.contains(entry.charset)) {
                            allCharSubsets.add(entry.charset);
                            extras.add(entry);
                            continue;
                        }
                        Main.trace("extended font config - already registered font for charset ''{0}'' - skipping ''{1}''", entry.charset, entry.name);
                        continue;
                    }
                    Main.trace("extended font config - Font ''{0}'' not found on system - skipping", entry.name);
                }
                for (FontEntry entry : extras) {
                    allCharSubsets.add(entry.charset);
                    if ("".equals(entry.name)) continue;
                    key = "allfonts." + entry.charset;
                    value = entry.name;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Main.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + "=" + value + "\n");
                }
                w.append("\n");
                for (FontEntry entry : extras) {
                    if ("".equals(entry.name) || "".equals(entry.file)) continue;
                    key = "filename." + entry.name.replace(" ", "_");
                    value = entry.file;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Main.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + "=" + value + "\n");
                }
                w.append("\n");
                String fallback = props.getProperty("sequence.fallback");
                if (fallback != null) {
                    w.append("sequence.fallback=" + fallback + "," + Utils.join(",", allCharSubsets) + "\n");
                } else {
                    w.append("sequence.fallback=" + Utils.join(",", allCharSubsets) + "\n");
                }
            }
            Utils.updateSystemProperty("sun.awt.fontconfig", fontconfigFile.toString());
        }
        catch (IOException ex) {
            Main.error(ex);
        }
    }

    public Collection<String> getInstalledFonts() {
        throw new UnsupportedOperationException();
    }

    public Collection<FontEntry> getAdditionalFonts() {
        throw new UnsupportedOperationException();
    }

    protected static class LinuxReleaseInfo {
        private final String path;
        private final String descriptionField;
        private final String idField;
        private final String releaseField;
        private final boolean plainText;
        private final String prefix;

        public LinuxReleaseInfo(String path, String descriptionField, String idField, String releaseField) {
            this(path, descriptionField, idField, releaseField, false, null);
        }

        public LinuxReleaseInfo(String path) {
            this(path, null, null, null, true, null);
        }

        public LinuxReleaseInfo(String path, String prefix) {
            this(path, null, null, null, true, prefix);
        }

        private LinuxReleaseInfo(String path, String descriptionField, String idField, String releaseField, boolean plainText, String prefix) {
            this.path = path;
            this.descriptionField = descriptionField;
            this.idField = idField;
            this.releaseField = releaseField;
            this.plainText = plainText;
            this.prefix = prefix;
        }

        public String toString() {
            return "ReleaseInfo [path=" + this.path + ", descriptionField=" + this.descriptionField + ", idField=" + this.idField + ", releaseField=" + this.releaseField + "]";
        }

        public String extractDescription() {
            Path p;
            String result = null;
            if (this.path != null && Files.exists(p = Paths.get(this.path, new String[0]), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                    String line;
                    String id = null;
                    String release = null;
                    while (result == null && (line = reader.readLine()) != null) {
                        if (line.contains("=")) {
                            String[] tokens = line.split("=");
                            if (tokens.length < 2) continue;
                            if (this.descriptionField != null && this.descriptionField.equalsIgnoreCase(tokens[0])) {
                                result = Utils.strip(tokens[1]);
                                continue;
                            }
                            if (this.idField != null && this.idField.equalsIgnoreCase(tokens[0])) {
                                id = Utils.strip(tokens[1]);
                                continue;
                            }
                            if (this.releaseField == null || !this.releaseField.equalsIgnoreCase(tokens[0])) continue;
                            release = Utils.strip(tokens[1]);
                            continue;
                        }
                        if (!this.plainText || line.isEmpty()) continue;
                        result = Utils.strip(line);
                    }
                    if (result == null && id != null && release != null) {
                        result = id + " " + release;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (result != null && !result.isEmpty() && this.prefix != null && !this.prefix.isEmpty()) {
                result = this.prefix + result;
            }
            if (result != null) {
                result = result.replaceAll("\"+", "");
            }
            return result;
        }
    }

    public static class FontEntry {
        @Preferences.pref
        public String charset;
        @Preferences.pref
        @Preferences.writeExplicitly
        public String name = "";
        @Preferences.pref
        @Preferences.writeExplicitly
        public String file = "";

        public FontEntry() {
        }

        public FontEntry(String charset, String name, String file) {
            this.charset = charset;
            this.name = name;
            this.file = file;
        }
    }
}

