/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;

public final class Pair<A, B> {
    public A a;
    public B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Pair) {
            Pair o = (Pair)other;
            return this.a.equals(o.a) && this.b.equals(o.b);
        }
        return false;
    }

    public static <T> ArrayList<T> toArrayList(Pair<T, T> p) {
        ArrayList<Object> l = new ArrayList<Object>(2);
        l.add(p.a);
        l.add(p.b);
        return l;
    }

    public static <T> Pair<T, T> sort(Pair<T, T> p) {
        if (p.b.hashCode() < p.a.hashCode()) {
            Object tmp = p.a;
            p.a = p.b;
            p.b = tmp;
        }
        return p;
    }

    public String toString() {
        return "<" + this.a + "," + this.b + ">";
    }

    public static <U, V> Pair<U, V> create(U u, V v) {
        return new Pair<U, V>(u, v);
    }
}

