/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public final class OsmUrlToBounds {
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};
    public static final double R = 6378137.0;

    public static Bounds parse(String url) throws IllegalArgumentException {
        try {
            if (url.contains("%")) {
                url = URLDecoder.decode(url, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException | IllegalArgumentException x) {
            Main.error(x);
        }
        Bounds b = OsmUrlToBounds.parseShortLink(url);
        if (b != null) {
            return b;
        }
        int i = url.indexOf("#map");
        if (i >= 0) {
            return OsmUrlToBounds.parseHashURLs(url);
        }
        i = url.indexOf(63);
        if (i == -1) {
            return null;
        }
        String[] args = url.substring(i + 1).split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            int eq = arg.indexOf(61);
            if (eq == -1) continue;
            map.put(arg.substring(0, eq), arg.substring(eq + 1));
        }
        try {
            if (map.containsKey("bbox")) {
                String[] bbox = ((String)map.get("bbox")).split(",");
                b = new Bounds(Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0]), Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2]));
            } else if (map.containsKey("minlat")) {
                double minlat = Double.parseDouble((String)map.get("minlat"));
                double minlon = Double.parseDouble(map.get("minlon"));
                double maxlat = Double.parseDouble(map.get("maxlat"));
                double maxlon = Double.parseDouble(map.get("maxlon"));
                b = new Bounds(minlat, minlon, maxlat, maxlon);
            } else {
                String z = (String)map.get("zoom");
                b = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(map, "lat"), OsmUrlToBounds.parseDouble(map, "lon"), z == null ? 18 : Integer.parseInt(z));
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException x) {
            Main.error(x);
        }
        return b;
    }

    private static Bounds parseHashURLs(String url) throws IllegalArgumentException {
        double lon;
        double lat;
        int zoom;
        String coordPart;
        String[] parts;
        int startIndex = url.indexOf("#map=");
        if (startIndex == -1) {
            return null;
        }
        int endIndex = url.indexOf(38, startIndex);
        if (endIndex == -1) {
            endIndex = url.length();
        }
        if ((parts = (coordPart = url.substring(startIndex + 5, endIndex)).split("/")).length < 3) {
            Main.warn(I18n.tr("URL does not contain {0}/{1}/{2}", I18n.tr("zoom", new Object[0]), I18n.tr("latitude", new Object[0]), I18n.tr("longitude", new Object[0])));
            return null;
        }
        try {
            zoom = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), e);
            return null;
        }
        try {
            lat = Double.parseDouble(parts[1]);
        }
        catch (NumberFormatException e) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), e);
            return null;
        }
        try {
            lon = Double.parseDouble(parts[2]);
        }
        catch (NumberFormatException e) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), e);
            return null;
        }
        return OsmUrlToBounds.positionToBounds(lat, lon, zoom);
    }

    private static double parseDouble(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return Double.parseDouble(map.get(key));
        }
        return Double.parseDouble(map.get("m" + key));
    }

    private static Bounds parseShortLink(String url) {
        if (!url.startsWith("http://osm.org/go/")) {
            return null;
        }
        String shortLink = url.substring("http://osm.org/go/".length());
        HashMap<Character, Integer> array = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            array.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long x = 0L;
        long y = 0L;
        int zoom = 0;
        int zoomOffset = 0;
        for (char ch : shortLink.toCharArray()) {
            if (array.containsKey(Character.valueOf(ch))) {
                int val = (Integer)array.get(Character.valueOf(ch));
                for (int i = 0; i < 3; ++i) {
                    x <<= 1;
                    if ((val & 0x20) != 0) {
                        x |= 1L;
                    }
                    y <<= 1;
                    if (((val <<= 1) & 0x20) != 0) {
                        y |= 1L;
                    }
                    val <<= 1;
                }
                zoom += 3;
                continue;
            }
            --zoomOffset;
        }
        return OsmUrlToBounds.positionToBounds((double)(y <<= 32 - zoom) * 180.0 / 4.294967296E9 - 90.0, (double)(x <<= 32 - zoom) * 360.0 / 4.294967296E9 - 180.0, zoom - 8 - zoomOffset % 3 - 2);
    }

    public static Bounds positionToBounds(double lat, double lon, int zoom) {
        int width;
        int height;
        int tileSizeInPixels = 256;
        try {
            height = Toolkit.getDefaultToolkit().getScreenSize().height;
            width = Toolkit.getDefaultToolkit().getScreenSize().width;
            if (Main.isDisplayingMapView()) {
                height = Main.map.mapView.getHeight();
                width = Main.map.mapView.getWidth();
            }
        }
        catch (HeadlessException he) {
            height = 480;
            width = 640;
        }
        double scale = (double)((1 << zoom) * tileSizeInPixels) / 4.007501668557849E7;
        double deltaX = (double)width / 2.0 / scale;
        double deltaY = (double)height / 2.0 / scale;
        double x = Math.toRadians(lon) * 6378137.0;
        double y = OsmUrlToBounds.mercatorY(lat);
        return new Bounds(OsmUrlToBounds.invMercatorY(y - deltaY), Math.toDegrees(x - deltaX) / 6378137.0, OsmUrlToBounds.invMercatorY(y + deltaY), Math.toDegrees(x + deltaX) / 6378137.0);
    }

    public static double mercatorY(double lat) {
        return Math.log(Math.tan(0.7853981633974483 + Math.toRadians(lat) / 2.0)) * 6378137.0;
    }

    public static double invMercatorY(double north) {
        return Math.toDegrees(Math.atan(Math.sinh(north / 6378137.0)));
    }

    public static Pair<Double, Double> getTileOfLatLon(double lat, double lon, double zoom) {
        double x = Math.floor((lon + 180.0) / 360.0 * Math.pow(2.0, zoom));
        double y = Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * Math.pow(2.0, zoom));
        return new Pair<Double, Double>(x, y);
    }

    public static LatLon getLatLonOfTile(double x, double y, double zoom) {
        double lon = x / Math.pow(2.0, zoom) * 360.0 - 180.0;
        double lat = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * y / Math.pow(2.0, zoom))));
        return new LatLon(lat, lon);
    }

    public static int getZoom(Bounds b) {
        int zoom;
        double latMin = Math.log(Math.tan(0.7853981633974483 + b.getMinLat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double latMax = Math.log(Math.tan(0.7853981633974483 + b.getMaxLat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double size = Math.max(Math.abs(latMax - latMin), Math.abs(b.getMaxLon() - b.getMinLon()));
        for (zoom = 0; zoom <= 20 && !(size >= 180.0); size *= 2.0, ++zoom) {
        }
        return zoom;
    }

    public static String getURL(Bounds b) {
        return OsmUrlToBounds.getURL(b.getCenter(), OsmUrlToBounds.getZoom(b));
    }

    public static String getURL(LatLon pos, int zoom) {
        return OsmUrlToBounds.getURL(pos.lat(), pos.lon(), zoom);
    }

    public static String getURL(double dlat, double dlon, int zoom) {
        int decimals = (int)Math.pow(10.0, zoom / 3);
        double lat = Math.round(dlat * (double)decimals);
        double lon = Math.round(dlon * (double)decimals);
        return Main.getOSMWebsite() + "/#map=" + zoom + "/" + (lat /= (double)decimals) + "/" + (lon /= (double)decimals);
    }
}

