/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;

public final class OpenBrowser {
    private static void displayUrlFallback(URI uri) throws IOException {
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first.", new Object[0]));
        }
        Main.platform.openUrl(uri.toString());
    }

    public static String displayUrl(URI uri) {
        CheckParameterUtil.ensureParameterNotNull(uri, "uri");
        Main.info(I18n.tr("Opening URL: {0}", uri));
        if (Desktop.isDesktopSupported()) {
            try {
                if (Main.isPlatformWindows()) {
                    Desktop.getDesktop().browse(uri);
                }
                if (Main.platform instanceof PlatformHookUnixoid) {
                    Main.platform.openUrl(uri.toString());
                }
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException e) {
                    Main.warn("Desktop class failed. Platform dependent fall back for open url in browser.");
                    OpenBrowser.displayUrlFallback(uri);
                }
            }
            catch (Exception e) {
                Main.warn(e);
                return e.getMessage();
            }
        } else {
            try {
                Main.warn("Desktop class is not supported. Platform dependent fall back for open url in browser.");
                OpenBrowser.displayUrlFallback(uri);
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static String displayUrl(String url) {
        try {
            return OpenBrowser.displayUrl(new URI(url));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

