/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public final class MultikeyActionsHandler {
    private Map<MultikeyShortcutAction, MyAction> myActions = new HashMap<MultikeyShortcutAction, MyAction>();
    private long lastTimestamp;
    private MyAction lastAction;
    private Timer timer;
    private static MultikeyActionsHandler instance;

    private MultikeyActionsHandler() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new MyKeyEventDispatcher());
        this.timer = new Timer();
    }

    public static synchronized MultikeyActionsHandler getInstance() {
        if (instance == null) {
            instance = new MultikeyActionsHandler();
        }
        return instance;
    }

    private String formatMenuText(KeyStroke keyStroke, String index, String description) {
        String shortcutText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode()) + "," + index;
        return "<html><i>" + shortcutText + "</i>&nbsp;&nbsp;&nbsp;&nbsp;" + description;
    }

    private void showLayersPopup(final MyAction action) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultikeyShortcutAction.MultikeyInfo lastLayer;
                JPopupMenu layers = new JPopupMenu();
                JMenuItem lbTitle = new JMenuItem((String)action.action.getValue("ShortDescription"));
                lbTitle.setEnabled(false);
                JPanel pnTitle = new JPanel();
                pnTitle.add(lbTitle);
                layers.add(pnTitle);
                char repeatKey = (char)action.shortcut.getKeyStroke().getKeyCode();
                boolean repeatKeyUsed = false;
                for (final MultikeyShortcutAction.MultikeyInfo info : action.action.getMultikeyCombinations()) {
                    if (info.getShortcut() == repeatKey) {
                        repeatKeyUsed = true;
                    }
                    JMenuItem item = new JMenuItem(MultikeyActionsHandler.this.formatMenuText(action.shortcut.getKeyStroke(), String.valueOf(info.getShortcut()), info.getDescription()));
                    item.setMnemonic(info.getShortcut());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            action.action.executeMultikeyAction(info.getIndex(), false);
                        }
                    });
                    layers.add(item);
                }
                if (!repeatKeyUsed && (lastLayer = action.action.getLastMultikeyAction()) != null) {
                    JMenuItem repeateItem = new JMenuItem(MultikeyActionsHandler.this.formatMenuText(action.shortcut.getKeyStroke(), KeyEvent.getKeyText(action.shortcut.getKeyStroke().getKeyCode()), "Repeat " + lastLayer.getDescription()));
                    repeateItem.setMnemonic(action.shortcut.getKeyStroke().getKeyCode());
                    repeateItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            action.action.executeMultikeyAction(-1, true);
                        }
                    });
                    layers.add(repeateItem);
                }
                layers.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        Main.map.statusLine.resetHelpText("multikeyShortcut");
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                layers.show(Main.parent, Integer.MAX_VALUE, Integer.MAX_VALUE);
                layers.setLocation(Main.parent.getX() + Main.parent.getWidth() - layers.getWidth(), Main.parent.getY() + Main.parent.getHeight() - layers.getHeight());
            }
        });
    }

    public void addAction(MultikeyShortcutAction action) {
        if (action.getMultikeyShortcut() != null) {
            MyAction myAction = new MyAction(action);
            this.myActions.put(action, myAction);
            Main.registerActionShortcut(myAction, myAction.shortcut);
        }
    }

    public void removeAction(MultikeyShortcutAction action) {
        MyAction a = this.myActions.get(action);
        if (a != null) {
            Main.unregisterActionShortcut(a, a.shortcut);
            this.myActions.remove(action);
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private final long lastTimestamp;
        private final MyAction lastAction;

        MyTimerTask(long lastTimestamp, MyAction lastAction) {
            this.lastTimestamp = lastTimestamp;
            this.lastAction = lastAction;
        }

        @Override
        public void run() {
            if (this.lastTimestamp == MultikeyActionsHandler.this.lastTimestamp && this.lastAction == MultikeyActionsHandler.this.lastAction) {
                MultikeyActionsHandler.this.showLayersPopup(this.lastAction);
                MultikeyActionsHandler.this.lastAction = null;
            }
        }
    }

    private class MyAction
    extends AbstractAction {
        final MultikeyShortcutAction action;
        final Shortcut shortcut;

        MyAction(MultikeyShortcutAction action) {
            this.action = action;
            this.shortcut = action.getMultikeyShortcut();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultikeyActionsHandler.this.lastTimestamp = e.getWhen();
            MultikeyActionsHandler.this.lastAction = this;
            MultikeyActionsHandler.this.timer.schedule((TimerTask)new MyTimerTask(MultikeyActionsHandler.this.lastTimestamp, MultikeyActionsHandler.this.lastAction), 1000L);
            Main.map.statusLine.setHelpText("multikeyShortcut", I18n.tr("{0}... [please type its number]", (String)this.action.getValue("ShortDescription")));
        }

        public String toString() {
            return "MultikeyAction" + this.action.toString();
        }
    }

    private class MyKeyEventDispatcher
    implements KeyEventDispatcher {
        private MyKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getWhen() == MultikeyActionsHandler.this.lastTimestamp) {
                return false;
            }
            if (MultikeyActionsHandler.this.lastAction != null && e.getID() == 401) {
                int index = this.getIndex(e.getKeyCode());
                if (index >= 0) {
                    ((MultikeyActionsHandler)MultikeyActionsHandler.this).lastAction.action.executeMultikeyAction(index, e.getKeyCode() == ((MultikeyActionsHandler)MultikeyActionsHandler.this).lastAction.shortcut.getKeyStroke().getKeyCode());
                }
                MultikeyActionsHandler.this.lastAction = null;
                Main.map.statusLine.resetHelpText("multikeyShortcut");
                return true;
            }
            return false;
        }

        private int getIndex(int lastKey) {
            if (lastKey >= 49 && lastKey <= 57) {
                return lastKey - 49;
            }
            if (lastKey == 48) {
                return 9;
            }
            if (lastKey >= 65 && lastKey <= 90) {
                return lastKey - 65 + 10;
            }
            return -1;
        }
    }
}

