/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.tools.Utils;

public class MultiMap<A, B> {
    private final Map<A, Set<B>> map;

    public MultiMap() {
        this.map = new HashMap<A, Set<B>>();
    }

    public MultiMap(int capacity) {
        this.map = new HashMap<A, Set<B>>(capacity);
    }

    public void put(A key, B value) {
        Set<B> vals = this.map.get(key);
        if (vals == null) {
            vals = new LinkedHashSet<B>();
            this.map.put(key, vals);
        }
        vals.add(value);
    }

    public void putVoid(A key) {
        if (this.map.containsKey(key)) {
            return;
        }
        this.map.put(key, new LinkedHashSet());
    }

    public void putAll(A key, Collection<B> values) {
        Set<B> vals = this.map.get(key);
        if (vals == null) {
            vals = new LinkedHashSet<B>(values);
            this.map.put(key, vals);
        }
        vals.addAll(values);
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public Set<B> get(A key) {
        return this.map.get(key);
    }

    public Set<B> getValues(A key) {
        if (!this.map.containsKey(key)) {
            return new LinkedHashSet();
        }
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(A key) {
        return this.map.containsKey(key);
    }

    public boolean contains(A key, B value) {
        Set<B> values = this.get(key);
        return values == null ? false : values.contains(value);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<A, Set<B>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Set<B>> values() {
        return this.map.values();
    }

    public boolean remove(A key, B value) {
        Set<B> values = this.get(key);
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public Set<B> remove(A key) {
        return this.map.remove(key);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMap)) {
            return false;
        }
        return this.map.equals(((MultiMap)obj).map);
    }

    public String toString() {
        ArrayList<String> entries = new ArrayList<String>(this.map.size());
        for (A key : this.map.keySet()) {
            entries.add(key + "->{" + Utils.join(",", (Collection)this.map.get(key)) + "}");
        }
        return "(" + Utils.join(",", entries) + ")";
    }
}

