/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public final class LanguageInfo {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWikiLanguagePrefix(LocaleType type) {
        if (type == LocaleType.ENGLISH) {
            return "";
        }
        String code = LanguageInfo.getJOSMLocaleCode();
        if (type == LocaleType.BASELANGUAGE) {
            if (!code.matches("[^_]+_[^_]+")) return null;
            if (!"en".equals(code = code.substring(0, 2))) return code.substring(0, 1).toUpperCase() + code.substring(1) + ":";
            return null;
        }
        if (type != LocaleType.DEFAULTNOTENGLISH || !"en".equals(code)) return code.substring(0, 1).toUpperCase() + code.substring(1) + ":";
        return null;
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(LocaleType.DEFAULT);
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        String full = locale.toString();
        if ("iw_IL".equals(full)) {
            return "he";
        }
        if ("in".equals(full)) {
            return "id";
        }
        if (I18n.hasCode(full)) {
            return full;
        }
        return locale.getLanguage();
    }

    public static Locale getLocale(String localeName) {
        if ("he".equals(localeName)) {
            localeName = "iw_IL";
        } else if ("id".equals(localeName)) {
            localeName = "in";
        }
        int i = localeName.indexOf(95);
        Locale l = i > 0 ? new Locale(localeName.substring(0, i), localeName.substring(i + 1)) : new Locale(localeName);
        return l;
    }

    public static boolean isBetterLanguage(String oldLanguage, String newLanguage) {
        if (oldLanguage == null) {
            return true;
        }
        String want = LanguageInfo.getJOSMLocaleCode();
        return want.equals(newLanguage) || !want.equals(oldLanguage) && newLanguage.startsWith("en");
    }

    public static String getLanguageCodeXML() {
        return LanguageInfo.getJOSMLocaleCode() + ".";
    }

    public static String getLanguageCodeManifest() {
        return LanguageInfo.getJOSMLocaleCode() + "_";
    }

    public static enum LocaleType {
        DEFAULT,
        DEFAULTNOTENGLISH,
        BASELANGUAGE,
        ENGLISH;

    }
}

