/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageResource {
    private Map<Dimension, Image> imgCache = new HashMap<Dimension, Image>();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);
    protected List<ImageOverlay> overlayInfo = null;
    private Image baseImage = null;

    public ImageResource(Image img) {
        CheckParameterUtil.ensureParameterNotNull(img);
        this.baseImage = img;
        this.imgCache.put(DEFAULT_DIMENSION, img);
    }

    public ImageResource(SVGDiagram svg) {
        CheckParameterUtil.ensureParameterNotNull(svg);
        this.svg = svg;
    }

    public ImageResource(ImageResource res, List<ImageOverlay> overlayInfo) {
        this.svg = res.svg;
        this.baseImage = res.baseImage;
        this.overlayInfo = overlayInfo;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public void getImageIcon(AbstractAction a) {
        ImageIcon icon = this.getImageIconBounded(ImageProvider.getImageSizes(ImageProvider.ImageSizes.SMALLICON));
        a.putValue("SmallIcon", icon);
        icon = this.getImageIconBounded(ImageProvider.getImageSizes(ImageProvider.ImageSizes.LARGEICON));
        a.putValue("SwingLargeIconKey", icon);
    }

    public ImageIcon getImageIcon(Dimension dim) {
        if (dim.width < -1 || dim.width == 0 || dim.height < -1 || dim.height == 0) {
            throw new IllegalArgumentException(dim + " is invalid");
        }
        Image img = this.imgCache.get(dim);
        if (img != null) {
            return new ImageIcon(img);
        }
        if (this.svg != null) {
            BufferedImage bimg = ImageProvider.createImageFromSvg(this.svg, dim);
            if (bimg == null) {
                return null;
            }
            if (this.overlayInfo != null) {
                for (ImageOverlay o : this.overlayInfo) {
                    o.apply(bimg);
                }
            }
            this.imgCache.put(dim, bimg);
            return new ImageIcon(bimg);
        }
        if (this.baseImage == null) {
            throw new AssertionError();
        }
        int width = dim.width;
        int height = dim.height;
        ImageIcon icon = new ImageIcon(this.baseImage);
        if (width == -1 && height == -1) {
            width = icon.getIconWidth();
            height = icon.getIconHeight();
        } else if (width == -1) {
            width = Math.max(1, icon.getIconWidth() * height / icon.getIconHeight());
        } else if (height == -1) {
            height = Math.max(1, icon.getIconHeight() * width / icon.getIconWidth());
        }
        Image i = icon.getImage().getScaledInstance(width, height, 4);
        BufferedImage bimg = new BufferedImage(width, height, 2);
        bimg.getGraphics().drawImage(i, 0, 0, null);
        if (this.overlayInfo != null) {
            for (ImageOverlay o : this.overlayInfo) {
                o.apply(bimg);
            }
        }
        this.imgCache.put(dim, bimg);
        return new ImageIcon(bimg);
    }

    public ImageIcon getImageIconBounded(Dimension maxSize) {
        float realHeight;
        float realWidth;
        if (maxSize.width < -1 || maxSize.width == 0 || maxSize.height < -1 || maxSize.height == 0) {
            throw new IllegalArgumentException(maxSize + " is invalid");
        }
        if (this.svg != null) {
            realWidth = this.svg.getWidth();
            realHeight = this.svg.getHeight();
        } else {
            if (this.baseImage == null) {
                throw new AssertionError();
            }
            ImageIcon icon = new ImageIcon(this.baseImage);
            realWidth = icon.getIconWidth();
            realHeight = icon.getIconHeight();
        }
        int maxWidth = maxSize.width;
        int maxHeight = maxSize.height;
        if (realWidth <= (float)maxWidth) {
            maxWidth = -1;
        }
        if (realHeight <= (float)maxHeight) {
            maxHeight = -1;
        }
        if (maxWidth == -1 && maxHeight == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION);
        }
        if (maxWidth == -1) {
            return this.getImageIcon(new Dimension(-1, maxHeight));
        }
        if (maxHeight == -1) {
            return this.getImageIcon(new Dimension(maxWidth, -1));
        }
        if (realWidth / (float)maxWidth > realHeight / (float)maxHeight) {
            return this.getImageIcon(new Dimension(maxWidth, -1));
        }
        return this.getImageIcon(new Dimension(-1, maxHeight));
    }
}

