/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.bind.DatatypeConverter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImageProvider {
    public static String PROP_TRANSPARENCY_FORCED = "josm.transparency.forced";
    public static String PROP_TRANSPARENCY_COLOR = "josm.transparency.color";
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected String name;
    protected File archive;
    protected String inArchiveDir;
    protected int width = -1;
    protected int height = -1;
    protected int maxWidth = -1;
    protected int maxHeight = -1;
    protected boolean optional;
    protected boolean suppressWarnings;
    protected Collection<ClassLoader> additionalClassLoaders;
    protected List<ImageOverlay> overlayInfo = null;
    private static SVGUniverse svgUniverse;
    private static final Map<String, ImageResource> cache;
    private static final Map<Image, Map<Long, ImageResource>> ROTATE_CACHE;
    private static final ExecutorService IMAGE_FETCHER;
    private static final Pattern dataUrlPattern;

    public ImageProvider(String subdir, String name) {
        this.subdir = subdir;
        this.name = name;
    }

    public ImageProvider(String name) {
        this.name = name;
    }

    public ImageProvider(ImageProvider image) {
        this.dirs = image.dirs;
        this.id = image.id;
        this.subdir = image.subdir;
        this.name = image.name;
        this.archive = image.archive;
        this.inArchiveDir = image.inArchiveDir;
        this.width = image.width;
        this.height = image.height;
        this.maxWidth = image.maxWidth;
        this.maxHeight = image.maxHeight;
        this.optional = image.optional;
        this.suppressWarnings = image.suppressWarnings;
        this.additionalClassLoaders = image.additionalClassLoaders;
        this.overlayInfo = image.overlayInfo;
    }

    public ImageProvider setDirs(Collection<String> dirs) {
        this.dirs = dirs;
        return this;
    }

    public ImageProvider setId(String id) {
        this.id = id;
        return this;
    }

    public ImageProvider setArchive(File archive) {
        this.archive = archive;
        return this;
    }

    public ImageProvider setInArchiveDir(String inArchiveDir) {
        this.inArchiveDir = inArchiveDir;
        return this;
    }

    public ImageProvider addOverlay(ImageOverlay overlay) {
        if (this.overlayInfo == null) {
            this.overlayInfo = new LinkedList<ImageOverlay>();
        }
        this.overlayInfo.add(overlay);
        return this;
    }

    public static Dimension getImageSizes(ImageSizes size) {
        int sizeval;
        switch (size) {
            case MAPMAX: {
                sizeval = Main.pref.getInteger("iconsize.mapmax", 48);
                break;
            }
            case MAP: {
                sizeval = Main.pref.getInteger("iconsize.mapmax", 16);
                break;
            }
            case LARGEICON: {
                sizeval = Main.pref.getInteger("iconsize.largeicon", 24);
                break;
            }
            case MENU: 
            case SMALLICON: {
                sizeval = Main.pref.getInteger("iconsize.smallicon", 16);
                break;
            }
            case CURSOROVERLAY: 
            case CURSOR: {
                sizeval = Main.pref.getInteger("iconsize.cursor", 32);
                break;
            }
            default: {
                sizeval = Main.pref.getInteger("iconsize.default", 24);
            }
        }
        return new Dimension(sizeval, sizeval);
    }

    public ImageProvider setSize(Dimension size) {
        this.width = size.width;
        this.height = size.height;
        return this;
    }

    public ImageProvider setSize(ImageSizes size) {
        return this.setSize(ImageProvider.getImageSizes(size));
    }

    public ImageProvider setWidth(int width) {
        this.width = width;
        return this;
    }

    public ImageProvider setHeight(int height) {
        this.height = height;
        return this;
    }

    public ImageProvider setMaxSize(Dimension maxSize) {
        this.maxWidth = maxSize.width;
        this.maxHeight = maxSize.height;
        return this;
    }

    public ImageProvider resetMaxSize(Dimension maxSize) {
        if (this.maxWidth == -1 || maxSize.width < this.maxWidth) {
            this.maxWidth = maxSize.width;
        }
        if (this.maxHeight == -1 || maxSize.height < this.maxHeight) {
            this.maxHeight = maxSize.height;
        }
        return this;
    }

    public ImageProvider setMaxSize(ImageSizes size) {
        return this.setMaxSize(ImageProvider.getImageSizes(size));
    }

    public ImageProvider setMaxSize(int maxSize) {
        return this.setMaxSize(new Dimension(maxSize, maxSize));
    }

    public ImageProvider setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public ImageProvider setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public ImageProvider setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public ImageProvider setSuppressWarnings(boolean suppressWarnings) {
        this.suppressWarnings = suppressWarnings;
        return this;
    }

    public ImageProvider setAdditionalClassLoaders(Collection<ClassLoader> additionalClassLoaders) {
        this.additionalClassLoaders = additionalClassLoaders;
        return this;
    }

    public ImageIcon get() {
        ImageResource ir = this.getResource();
        if (ir == null) {
            return null;
        }
        if (this.maxWidth != -1 || this.maxHeight != -1) {
            return ir.getImageIconBounded(new Dimension(this.maxWidth, this.maxHeight));
        }
        return ir.getImageIcon(new Dimension(this.width, this.height));
    }

    public ImageResource getResource() {
        ImageResource ir = this.getIfAvailableImpl(this.additionalClassLoaders);
        if (ir == null) {
            if (!this.optional) {
                String ext = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new RuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + ext));
            }
            if (!this.suppressWarnings) {
                Main.error(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.overlayInfo != null) {
            ir = new ImageResource(ir, this.overlayInfo);
        }
        return ir;
    }

    public void getInBackground(final ImageCallback callback) {
        if (this.name.startsWith("http://") || this.name.startsWith("wiki://")) {
            Runnable fetch = new Runnable(){

                @Override
                public void run() {
                    ImageIcon result = ImageProvider.this.get();
                    callback.finished(result);
                }
            };
            IMAGE_FETCHER.submit(fetch);
        } else {
            ImageIcon result = this.get();
            callback.finished(result);
        }
    }

    public void getInBackground(final ImageResourceCallback callback) {
        if (this.name.startsWith("http://") || this.name.startsWith("wiki://")) {
            Runnable fetch = new Runnable(){

                @Override
                public void run() {
                    callback.finished(ImageProvider.this.getResource());
                }
            };
            IMAGE_FETCHER.submit(fetch);
        } else {
            callback.finished(this.getResource());
        }
    }

    public static ImageIcon get(String subdir, String name) {
        return new ImageProvider(subdir, name).get();
    }

    public static ImageIcon get(String name) {
        return new ImageProvider(name).get();
    }

    public static ImageIcon getIfAvailable(String subdir, String name) {
        return new ImageProvider(subdir, name).setOptional(true).get();
    }

    public static ImageIcon getIfAvailable(String name) {
        return new ImageProvider(name).setOptional(true).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResource getIfAvailableImpl(Collection<ClassLoader> additionalClassLoaders) {
        Map<String, ImageResource> map = cache;
        synchronized (map) {
            ImageType type;
            if (this.name == null) {
                return null;
            }
            if (this.name.startsWith("data:")) {
                String url = this.name;
                ImageResource ir = cache.get(url);
                if (ir != null) {
                    return ir;
                }
                ir = ImageProvider.getIfAvailableDataUrl(url);
                if (ir != null) {
                    cache.put(url, ir);
                }
                return ir;
            }
            ImageType imageType = type = this.name.toLowerCase().endsWith(".svg") ? ImageType.SVG : ImageType.OTHER;
            if (this.name.startsWith("http://") || this.name.startsWith("https://")) {
                String url = this.name;
                ImageResource ir = cache.get(url);
                if (ir != null) {
                    return ir;
                }
                ir = ImageProvider.getIfAvailableHttp(url, type);
                if (ir != null) {
                    cache.put(url, ir);
                }
                return ir;
            }
            if (this.name.startsWith("wiki://")) {
                ImageResource ir = cache.get(this.name);
                if (ir != null) {
                    return ir;
                }
                ir = ImageProvider.getIfAvailableWiki(this.name, type);
                if (ir != null) {
                    cache.put(this.name, ir);
                }
                return ir;
            }
            if (this.subdir == null) {
                this.subdir = "";
            } else if (!this.subdir.isEmpty() && !this.subdir.endsWith("/")) {
                this.subdir = this.subdir + "/";
            }
            String[] extensions = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
            boolean ARCHIVE = false;
            boolean LOCAL = true;
            Integer[] arr$ = new Integer[]{0, 1};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int place = arr$[i$];
                block8: for (String ext : extensions) {
                    ImageResource ir;
                    String fullName;
                    if (".svg".equals(ext)) {
                        type = ImageType.SVG;
                    } else if (".png".equals(ext)) {
                        type = ImageType.OTHER;
                    }
                    String cacheName = fullName = this.subdir + this.name + ext;
                    if (this.dirs != null && !this.dirs.isEmpty()) {
                        cacheName = "id:" + this.id + ":" + fullName;
                        if (this.archive != null) {
                            cacheName = cacheName + ":" + this.archive.getName();
                        }
                    }
                    if ((ir = cache.get(cacheName)) != null) {
                        return ir;
                    }
                    switch (place) {
                        case 0: {
                            if (this.archive == null || (ir = ImageProvider.getIfAvailableZip(fullName, this.archive, this.inArchiveDir, type)) == null) continue block8;
                            cache.put(cacheName, ir);
                            return ir;
                        }
                        case 1: {
                            URL path = ImageProvider.getImageUrl(fullName, this.dirs, additionalClassLoaders);
                            if (path == null || (ir = ImageProvider.getIfAvailableLocalURL(path, type)) == null) continue block8;
                            cache.put(cacheName, ir);
                            return ir;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableHttp(String url, ImageType type) {
        CachedFile cf = new CachedFile(url).setDestDir(new File(Main.pref.getCacheDirectory(), "images").getPath());
        try (InputStream is = cf.getInputStream();){
            switch (type) {
                case SVG: {
                    SVGDiagram svg = null;
                    Object object = ImageProvider.getSvgUniverse();
                    synchronized (object) {
                        URI uri = ImageProvider.getSvgUniverse().loadSVG(is, Utils.fileToURL(cf.getFile()).toString());
                        svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                    }
                    object = svg == null ? null : new ImageResource(svg);
                    return object;
                }
                case OTHER: {
                    BufferedImage img = null;
                    try {
                        img = ImageProvider.read(Utils.fileToURL(cf.getFile()), false, false);
                    }
                    catch (IOException e) {
                        Main.warn("IOException while reading HTTP image: " + e.getMessage());
                    }
                    ImageResource imageResource = img == null ? null : new ImageResource(img);
                    return imageResource;
                }
            }
            throw new AssertionError();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableDataUrl(String url) {
        try {
            Matcher m = dataUrlPattern.matcher(url);
            if (m.matches()) {
                byte[] bytes;
                String mediatype = m.group(1);
                String base64 = m.group(2);
                String data = m.group(3);
                if (";base64".equals(base64)) {
                    bytes = DatatypeConverter.parseBase64Binary((String)data);
                } else {
                    try {
                        bytes = URLDecoder.decode(data, "UTF-8").getBytes(StandardCharsets.UTF_8);
                    }
                    catch (IllegalArgumentException ex) {
                        Main.warn("Unable to decode URL data part: " + ex.getMessage() + " (" + data + ")");
                        return null;
                    }
                }
                if ("image/svg+xml".equals(mediatype)) {
                    String s = new String(bytes, StandardCharsets.UTF_8);
                    SVGDiagram svg = null;
                    SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                    synchronized (sVGUniverse) {
                        URI uri = ImageProvider.getSvgUniverse().loadSVG(new StringReader(s), URLEncoder.encode(s, "UTF-8"));
                        svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                    }
                    if (svg == null) {
                        Main.warn("Unable to process svg: " + s);
                        return null;
                    }
                    return new ImageResource(svg);
                }
                try {
                    BufferedImage img = ImageProvider.read(new ByteArrayInputStream(bytes), false, true);
                    return img == null ? null : new ImageResource(img);
                }
                catch (IOException e) {
                    Main.warn("IOException while reading image: " + e.getMessage());
                }
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static ImageResource getIfAvailableWiki(String name, ImageType type) {
        List<String> defaultBaseUrls = Arrays.asList("http://wiki.openstreetmap.org/w/images/", "http://upload.wikimedia.org/wikipedia/commons/", "http://wiki.openstreetmap.org/wiki/File:");
        Collection<String> baseUrls = Main.pref.getCollection("image-provider.wiki.urls", defaultBaseUrls);
        String fn = name.substring(name.lastIndexOf(47) + 1);
        ImageResource result = null;
        for (String b : baseUrls) {
            String url;
            if (b.endsWith(":")) {
                url = ImageProvider.getImgUrlFromWikiInfoPage(b, fn);
                if (url == null) {
                    continue;
                }
            } else {
                String fn_md5 = Utils.md5Hex(fn);
                url = b + fn_md5.substring(0, 1) + "/" + fn_md5.substring(0, 2) + "/" + fn;
            }
            if ((result = ImageProvider.getIfAvailableHttp(url, type)) == null) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String fullName, File archive, String inArchiveDir, ImageType type) {
        try (ZipFile zipFile = new ZipFile(archive, StandardCharsets.UTF_8);){
            int size;
            if (inArchiveDir == null || ".".equals(inArchiveDir)) {
                inArchiveDir = "";
            } else if (!inArchiveDir.isEmpty()) {
                inArchiveDir = inArchiveDir + "/";
            }
            String entryName = inArchiveDir + fullName;
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) return null;
            int offs = 0;
            byte[] buf = new byte[size];
            try (InputStream is = zipFile.getInputStream(entry);){
                switch (type) {
                    case SVG: {
                        SVGDiagram svg = null;
                        Object object = ImageProvider.getSvgUniverse();
                        synchronized (object) {
                            URI uri = ImageProvider.getSvgUniverse().loadSVG(is, entryName);
                            svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                        }
                        object = svg == null ? null : new ImageResource(svg);
                        return object;
                    }
                    case OTHER: {
                        int l;
                        for (size = (int)entry.getSize(); size > 0; offs += l, size -= l) {
                            l = is.read(buf, offs, size);
                        }
                        BufferedImage img = null;
                        try {
                            img = ImageProvider.read(new ByteArrayInputStream(buf), false, false);
                        }
                        catch (IOException e) {
                            Main.warn(e);
                        }
                        ImageResource imageResource = img == null ? null : new ImageResource(img);
                        return imageResource;
                    }
                }
                throw new AssertionError((Object)("Unknown ImageType: " + (Object)((Object)type)));
            }
        }
        catch (Exception e) {
            Main.warn(I18n.tr("Failed to handle zip file ''{0}''. Exception was: {1}", archive.getName(), e.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableLocalURL(URL path, ImageType type) {
        switch (type) {
            case SVG: {
                SVGDiagram svg = null;
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uri = ImageProvider.getSvgUniverse().loadSVG(path);
                    svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                }
                return svg == null ? null : new ImageResource(svg);
            }
            case OTHER: {
                BufferedImage img = null;
                try {
                    img = ImageProvider.read(path, false, true);
                    if (Main.isDebugEnabled() && ImageProvider.isTransparencyForced(img)) {
                        Main.debug("Transparency has been forced for image " + path.toExternalForm());
                    }
                }
                catch (IOException e) {
                    Main.warn(e);
                }
                return img == null ? null : new ImageResource(img);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String path, String name, Collection<ClassLoader> additionalClassLoaders) {
        if (path != null && path.startsWith("resource://")) {
            String p = path.substring("resource://".length());
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(PluginHandler.getResourceClassLoaders());
            if (additionalClassLoaders != null) {
                classLoaders.addAll(additionalClassLoaders);
            }
            for (ClassLoader source : classLoaders) {
                URL res = source.getResource(p + name);
                if (res == null) continue;
                return res;
            }
        } else {
            File f = new File(path, name);
            if ((path != null || f.isAbsolute()) && f.exists()) {
                return Utils.fileToURL(f);
            }
        }
        return null;
    }

    private static URL getImageUrl(String imageName, Collection<String> dirs, Collection<ClassLoader> additionalClassLoaders) {
        URL u = null;
        if (dirs != null) {
            for (String name : dirs) {
                try {
                    u = ImageProvider.getImageUrl(name, imageName, additionalClassLoaders);
                    if (u == null) continue;
                    return u;
                }
                catch (SecurityException e) {
                    Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", name, e.toString()));
                }
            }
        }
        String dir = new File(Main.pref.getUserDataDirectory(), "images").getAbsolutePath();
        try {
            u = ImageProvider.getImageUrl(dir, imageName, additionalClassLoaders);
            if (u != null) {
                return u;
            }
        }
        catch (SecurityException e) {
            Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", dir, e.toString()));
        }
        u = ImageProvider.getImageUrl(null, imageName, additionalClassLoaders);
        if (u != null) {
            return u;
        }
        u = ImageProvider.getImageUrl("resource://images/", imageName, additionalClassLoaders);
        if (u != null) {
            return u;
        }
        for (String location : Main.pref.getAllPossiblePreferenceDirs()) {
            u = ImageProvider.getImageUrl(location + "images", imageName, additionalClassLoaders);
            if (u != null) {
                return u;
            }
            u = ImageProvider.getImageUrl(location, imageName, additionalClassLoaders);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String base, final String fn) {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    String val;
                    if ("img".equalsIgnoreCase(localName) && (val = atts.getValue("src")).endsWith(fn)) {
                        throw new SAXReturnException(val);
                    }
                }
            });
            parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            CachedFile cf = new CachedFile(base + fn).setDestDir(new File(Main.pref.getUserDataDirectory(), "images").getPath());
            try (InputStream is = cf.getInputStream();){
                parser.parse(new InputSource(is));
            }
        }
        catch (SAXReturnException r) {
            return r.getResult();
        }
        catch (Exception e) {
            Main.warn("Parsing " + base + fn + " failed:\n" + e);
            return null;
        }
        Main.warn("Parsing " + base + fn + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String name, String overlay) {
        ImageIcon img = ImageProvider.get("cursor", name);
        if (overlay != null) {
            img = new ImageProvider("cursor", name).setMaxSize(ImageSizes.CURSOR).addOverlay(new ImageOverlay(new ImageProvider("cursor/modifier/" + overlay).setMaxSize(ImageSizes.CURSOROVERLAY))).get();
        }
        if (GraphicsEnvironment.isHeadless()) {
            Main.warn("Cursors are not available in headless mode. Returning null for '" + name + "'");
            return null;
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(img.getImage(), "crosshair".equals(name) ? new Point(10, 10) : new Point(3, 2), "Cursor");
    }

    @Deprecated
    public static ImageIcon overlay(Icon ground, Icon overlay, OverlayPosition pos) {
        int w = ground.getIconWidth();
        int h = ground.getIconHeight();
        int wo = overlay.getIconWidth();
        int ho = overlay.getIconHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        ground.paintIcon(null, g, 0, 0);
        int x = 0;
        int y = 0;
        switch (pos) {
            case NORTHWEST: {
                x = 0;
                y = 0;
                break;
            }
            case NORTHEAST: {
                x = w - wo;
                y = 0;
                break;
            }
            case SOUTHWEST: {
                x = 0;
                y = h - ho;
                break;
            }
            case SOUTHEAST: {
                x = w - wo;
                y = h - ho;
            }
        }
        overlay.paintIcon(null, g, x, y);
        return new ImageIcon(img);
    }

    public static Image createRotatedImage(Image img, double rotatedAngle) {
        return ImageProvider.createRotatedImage(img, rotatedAngle, ImageResource.DEFAULT_DIMENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createRotatedImage(Image img, double rotatedAngle, Dimension dimension) {
        CheckParameterUtil.ensureParameterNotNull(img, "img");
        Long originalAngle = Math.round(rotatedAngle % 360.0);
        if (rotatedAngle != 0.0 && originalAngle == 0L) {
            originalAngle = 360L;
        }
        ImageResource imageResource = null;
        Map<Image, Map<Long, ImageResource>> map = ROTATE_CACHE;
        synchronized (map) {
            Map<Long, ImageResource> cacheByAngle = ROTATE_CACHE.get(img);
            if (cacheByAngle == null) {
                cacheByAngle = new HashMap<Long, ImageResource>();
                ROTATE_CACHE.put(img, cacheByAngle);
            }
            if ((imageResource = cacheByAngle.get(originalAngle)) == null) {
                int h;
                int w;
                double angle = originalAngle % 90L;
                if ((double)originalAngle.longValue() != 0.0 && angle == 0.0) {
                    angle = 90.0;
                }
                double radian = Math.toRadians(angle);
                new ImageIcon(img);
                int iw = img.getWidth(null);
                int ih = img.getHeight(null);
                if (originalAngle >= 0L && originalAngle <= 90L || originalAngle > 180L && originalAngle <= 270L) {
                    w = (int)((double)iw * Math.sin(1.5707963267948966 - radian) + (double)ih * Math.sin(radian));
                    h = (int)((double)iw * Math.sin(radian) + (double)ih * Math.sin(1.5707963267948966 - radian));
                } else {
                    w = (int)((double)ih * Math.sin(1.5707963267948966 - radian) + (double)iw * Math.sin(radian));
                    h = (int)((double)ih * Math.sin(radian) + (double)iw * Math.sin(1.5707963267948966 - radian));
                }
                BufferedImage image = new BufferedImage(w, h, 2);
                imageResource = new ImageResource(image);
                cacheByAngle.put(originalAngle, imageResource);
                Graphics g = ((Image)image).getGraphics();
                Graphics2D g2d = (Graphics2D)g.create();
                int cx = iw / 2;
                int cy = ih / 2;
                g2d.translate(w / 2, h / 2);
                g2d.rotate(Math.toRadians(originalAngle.longValue()));
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.drawImage(img, -cx, -cy, null);
                g2d.dispose();
                new ImageIcon(image);
            }
            return imageResource.getImageIcon(dimension).getImage();
        }
    }

    public static Image createBoundedImage(Image img, int maxSize) {
        return new ImageResource(img).getImageIconBounded(new Dimension(maxSize, maxSize)).getImage();
    }

    public static ImageIcon get(OsmPrimitiveType type) {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        return ImageProvider.get("data", type.getAPIName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createImageFromSvg(SVGDiagram svg, Dimension dim) {
        float realWidth = svg.getWidth();
        float realHeight = svg.getHeight();
        int width = Math.round(realWidth);
        int height = Math.round(realHeight);
        Double scaleX = null;
        Double scaleY = null;
        if (dim.width != -1) {
            width = dim.width;
            scaleX = (double)width / (double)realWidth;
            if (dim.height == -1) {
                scaleY = scaleX;
                height = (int)Math.round((double)realHeight * scaleY);
            } else {
                height = dim.height;
                scaleY = (double)height / (double)realHeight;
            }
        } else if (dim.height != -1) {
            height = dim.height;
            scaleX = scaleY = Double.valueOf((double)height / (double)realHeight);
            width = (int)Math.round((double)realWidth * scaleX);
        }
        if (width == 0 || height == 0) {
            return null;
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.setClip(0, 0, width, height);
        if (scaleX != null && scaleY != null) {
            g.scale(scaleX, scaleY);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
            synchronized (sVGUniverse) {
                svg.render(g);
            }
        }
        catch (Exception ex) {
            Main.error("Unable to load svg: {0}", ex.getMessage());
            return null;
        }
        return img;
    }

    private static synchronized SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    public static BufferedImage read(File input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        if (stream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bi = ImageProvider.read(stream, readMetadata, enforceTransparency);
        if (bi == null) {
            stream.close();
        }
        return bi;
    }

    public static BufferedImage read(InputStream input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        BufferedImage bi = ImageProvider.read(stream, readMetadata, enforceTransparency);
        if (bi == null) {
            stream.close();
        }
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        BufferedImage bi;
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        InputStream istream = null;
        try {
            istream = input.openStream();
        }
        catch (IOException e) {
            throw new IIOException("Can't get input stream from URL!", e);
        }
        ImageInputStream stream = ImageIO.createImageInputStream(istream);
        try {
            bi = ImageProvider.read(stream, readMetadata, enforceTransparency);
            if (bi == null) {
                stream.close();
            }
        }
        finally {
            istream.close();
        }
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ImageInputStream stream, boolean readMetadata, boolean enforceTransparency) throws IOException {
        BufferedImage bi;
        CheckParameterUtil.ensureParameterNotNull(stream, "stream");
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, !readMetadata && !enforceTransparency);
        try {
            Color color;
            bi = reader.read(0, param);
            if (bi.getTransparency() != 3 && (readMetadata || enforceTransparency) && (color = ImageProvider.getTransparentColor(bi.getColorModel(), reader)) != null) {
                Hashtable<String, Color> properties = new Hashtable<String, Color>(1);
                properties.put(PROP_TRANSPARENCY_COLOR, color);
                bi = new BufferedImage(bi.getColorModel(), bi.getRaster(), bi.isAlphaPremultiplied(), properties);
                if (enforceTransparency) {
                    if (Main.isTraceEnabled()) {
                        Main.trace("Enforcing image transparency of " + stream + " for " + color);
                    }
                    bi = ImageProvider.makeImageTransparent(bi, color);
                }
            }
        }
        finally {
            reader.dispose();
            stream.close();
        }
        return bi;
    }

    public static Color getTransparentColor(ColorModel model, ImageReader reader) throws IOException {
        block6: {
            try {
                String[] formats;
                IIOMetadata metadata = reader.getImageMetadata(0);
                if (metadata == null || (formats = metadata.getMetadataFormatNames()) == null) break block6;
                for (String f : formats) {
                    String value;
                    Node item;
                    NodeList list;
                    if (!"javax_imageio_1.0".equals(f)) continue;
                    Node root = metadata.getAsTree(f);
                    if (root instanceof Element && (list = ((Element)root).getElementsByTagName("TransparentColor")).getLength() > 0 && (item = list.item(0)) instanceof Element && !(value = ((Element)item).getAttribute("value")).isEmpty()) {
                        String[] s = value.split(" ");
                        if (s.length == 3) {
                            return ImageProvider.parseRGB(s);
                        }
                        if (s.length == 1) {
                            int pixel = Integer.parseInt(s[0]);
                            int r = model.getRed(pixel);
                            int g = model.getGreen(pixel);
                            int b = model.getBlue(pixel);
                            return new Color(r, g, b);
                        }
                        Main.warn("Unable to translate TransparentColor '" + value + "' with color model " + model);
                    }
                    break;
                }
            }
            catch (NumberFormatException | IIOException e) {
                Main.warn(e);
            }
        }
        return null;
    }

    private static Color parseRGB(String[] s) {
        int[] rgb = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                rgb[i] = Integer.parseInt(s[i]);
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        catch (IllegalArgumentException e) {
            Main.error(e);
            return null;
        }
    }

    public static BufferedImage makeImageTransparent(BufferedImage bi, Color color) {
        final int markerRGB = color.getRGB() | 0xFF000000;
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(bi.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(img.getWidth(null), img.getHeight(null));
        String[] names = bi.getPropertyNames();
        Hashtable<String, Object> properties = new Hashtable<String, Object>(1 + (names != null ? names.length : 0));
        if (names != null) {
            for (String name : names) {
                properties.put(name, bi.getProperty(name));
            }
        }
        properties.put(PROP_TRANSPARENCY_FORCED, Boolean.TRUE);
        BufferedImage result = new BufferedImage(colorModel, raster, false, properties);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return result;
    }

    public static boolean isTransparencyForced(BufferedImage bi) {
        return bi != null && !bi.getProperty(PROP_TRANSPARENCY_FORCED).equals(Image.UndefinedProperty);
    }

    public static boolean hasTransparentColor(BufferedImage bi) {
        return bi != null && !bi.getProperty(PROP_TRANSPARENCY_COLOR).equals(Image.UndefinedProperty);
    }

    static {
        cache = new HashMap<String, ImageResource>();
        ROTATE_CACHE = new HashMap<Image, Map<Long, ImageResource>>();
        IMAGE_FETCHER = Executors.newSingleThreadExecutor();
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
    }

    private static class SAXReturnException
    extends SAXException {
        private final String result;

        public SAXReturnException(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }
    }

    public static interface ImageResourceCallback {
        public void finished(ImageResource var1);
    }

    public static interface ImageCallback {
        public void finished(ImageIcon var1);
    }

    public static enum ImageSizes {
        SMALLICON,
        LARGEICON,
        MAP,
        MAPMAX,
        CURSOR,
        CURSOROVERLAY,
        MENU;

    }

    public static enum ImageType {
        SVG,
        OTHER;

    }

    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

