/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageOverlay {
    public ImageProvider image;
    private double offsetLeft;
    private double offsetRight;
    private double offsetTop;
    private double offsetBottom;

    public ImageOverlay(ImageProvider image, double offsetLeft, double offsetTop, double offsetRight, double offsetBottom) {
        this.image = image;
        this.offsetLeft = offsetLeft;
        this.offsetTop = offsetTop;
        this.offsetRight = offsetRight;
        this.offsetBottom = offsetBottom;
    }

    public ImageOverlay(ImageProvider image) {
        this.image = image;
        this.offsetLeft = -1.0;
        this.offsetTop = -1.0;
        this.offsetRight = 1.0;
        this.offsetBottom = 1.0;
    }

    public BufferedImage apply(BufferedImage ground) {
        int w = ground.getWidth();
        int h = ground.getHeight();
        int width = -1;
        int height = -1;
        if (this.offsetRight > 0.0 && this.offsetLeft > 0.0) {
            width = new Double((double)w * (this.offsetRight - this.offsetLeft)).intValue();
        }
        if (this.offsetTop > 0.0 && this.offsetBottom > 0.0) {
            width = new Double((double)h * (this.offsetBottom - this.offsetTop)).intValue();
        }
        if (width != -1 || height != -1) {
            this.image = new ImageProvider(this.image).resetMaxSize(new Dimension(width, height));
        }
        ImageIcon overlay = this.image.get();
        int x = width == -1 && this.offsetLeft < 0.0 ? new Double((double)w * this.offsetRight).intValue() - overlay.getIconWidth() : new Double((double)w * this.offsetLeft).intValue();
        int y = height == -1 && this.offsetTop < 0.0 ? new Double((double)h * this.offsetBottom).intValue() - overlay.getIconHeight() : new Double((double)h * this.offsetTop).intValue();
        overlay.paintIcon(null, ground.getGraphics(), x, y);
        return ground;
    }
}

