/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;

public final class Geometry {
    public static Set<Node> addIntersections(List<Way> ways, boolean test, List<Command> cmds) {
        int n = ways.size();
        ArrayList[] newNodes = new ArrayList[n];
        BBox[] wayBounds = new BBox[n];
        boolean[] changedWays = new boolean[n];
        LinkedHashSet<Node> intersectionNodes = new LinkedHashSet<Node>();
        for (int pos = 0; pos < n; ++pos) {
            newNodes[pos] = new ArrayList<Node>(ways.get(pos).getNodes());
            wayBounds[pos] = Geometry.getNodesBounds(newNodes[pos]);
            changedWays[pos] = false;
        }
        NodePositionComparator coordsComparator = new NodePositionComparator();
        for (int seg1Way = 0; seg1Way < n; ++seg1Way) {
            for (int seg2Way = seg1Way; seg2Way < n; ++seg2Way) {
                if (!wayBounds[seg1Way].intersects(wayBounds[seg2Way])) continue;
                ArrayList way1Nodes = newNodes[seg1Way];
                ArrayList way2Nodes = newNodes[seg2Way];
                int seg1Pos = 0;
                while (seg1Pos + 1 < way1Nodes.size()) {
                    int seg2Start;
                    int seg2Pos = seg2Start = seg1Way != seg2Way ? 0 : seg1Pos + 2;
                    while (seg2Pos + 1 < way2Nodes.size()) {
                        Node seg1Node1 = (Node)way1Nodes.get(seg1Pos);
                        Node seg1Node2 = (Node)way1Nodes.get(seg1Pos + 1);
                        Node seg2Node1 = (Node)way2Nodes.get(seg2Pos);
                        Node seg2Node2 = (Node)way2Nodes.get(seg2Pos + 1);
                        int commonCount = 0;
                        if (seg1Node1 == seg2Node1 || seg1Node1 == seg2Node2) {
                            ++commonCount;
                            if (seg1Way != seg2Way || seg1Pos != 0 || seg2Pos != way2Nodes.size() - 2) {
                                intersectionNodes.add(seg1Node1);
                            }
                        }
                        if (seg1Node2 == seg2Node1 || seg1Node2 == seg2Node2) {
                            ++commonCount;
                            intersectionNodes.add(seg1Node2);
                        }
                        if (commonCount == 0) {
                            EastNorth intersection = Geometry.getSegmentSegmentIntersection(seg1Node1.getEastNorth(), seg1Node2.getEastNorth(), seg2Node1.getEastNorth(), seg2Node2.getEastNorth());
                            if (intersection != null) {
                                Node newNode;
                                if (test) {
                                    intersectionNodes.add(seg2Node1);
                                    return intersectionNodes;
                                }
                                Node intNode = newNode = new Node(Main.getProjection().eastNorth2latlon(intersection));
                                boolean insertInSeg1 = false;
                                boolean insertInSeg2 = false;
                                if (coordsComparator.compare(newNode, seg1Node1) == 0) {
                                    intNode = seg1Node1;
                                } else if (coordsComparator.compare(newNode, seg1Node2) == 0) {
                                    intNode = seg1Node2;
                                } else {
                                    insertInSeg1 = true;
                                }
                                if (coordsComparator.compare(newNode, seg2Node1) == 0) {
                                    intNode = seg2Node1;
                                } else if (coordsComparator.compare(newNode, seg2Node2) == 0) {
                                    intNode = seg2Node2;
                                } else {
                                    insertInSeg2 = true;
                                }
                                if (insertInSeg1) {
                                    way1Nodes.add(seg1Pos + 1, intNode);
                                    changedWays[seg1Way] = true;
                                    if (seg2Way == seg1Way) {
                                        ++seg2Pos;
                                    }
                                }
                                if (insertInSeg2) {
                                    way2Nodes.add(seg2Pos + 1, intNode);
                                    changedWays[seg2Way] = true;
                                    ++seg2Pos;
                                }
                                intersectionNodes.add(intNode);
                                if (intNode == newNode) {
                                    cmds.add(new AddCommand(intNode));
                                }
                            }
                        } else if (test && !intersectionNodes.isEmpty()) {
                            return intersectionNodes;
                        }
                        ++seg2Pos;
                    }
                    ++seg1Pos;
                }
            }
        }
        for (int pos = 0; pos < ways.size(); ++pos) {
            if (!changedWays[pos]) continue;
            Way way = ways.get(pos);
            Way newWay = new Way(way);
            newWay.setNodes(newNodes[pos]);
            cmds.add(new ChangeCommand(way, newWay));
        }
        return intersectionNodes;
    }

    private static BBox getNodesBounds(List<Node> nodes) {
        BBox bounds = new BBox(nodes.get(0));
        for (Node n : nodes) {
            bounds.add(n.getCoor());
        }
        return bounds;
    }

    public static boolean isToTheRightSideOfLine(Node lineP1, Node lineP2, Node lineP3, Node testPoint) {
        boolean pathBendToRight = Geometry.angleIsClockwise(lineP1, lineP2, lineP3);
        boolean rightOfSeg1 = Geometry.angleIsClockwise(lineP1, lineP2, testPoint);
        boolean rightOfSeg2 = Geometry.angleIsClockwise(lineP2, lineP3, testPoint);
        if (pathBendToRight) {
            return rightOfSeg1 && rightOfSeg2;
        }
        return rightOfSeg1 || rightOfSeg2;
    }

    public static boolean angleIsClockwise(Node commonNode, Node firstNode, Node secondNode) {
        return Geometry.angleIsClockwise(commonNode.getEastNorth(), firstNode.getEastNorth(), secondNode.getEastNorth());
    }

    public static EastNorth getSegmentSegmentIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensureValidCoordinates(p1, "p1");
        CheckParameterUtil.ensureValidCoordinates(p2, "p2");
        CheckParameterUtil.ensureValidCoordinates(p3, "p3");
        CheckParameterUtil.ensureValidCoordinates(p4, "p4");
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double x3 = p3.getX();
        double y3 = p3.getY();
        double x4 = p4.getX();
        double y4 = p4.getY();
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a1 = x2 - x1;
        double b1 = x3 - x4;
        double c1 = x3 - x1;
        double a2 = y2 - y1;
        double b2 = y3 - y4;
        double c2 = y3 - y1;
        double det = a1 * b2 - a2 * b1;
        double uu = b2 * c1 - b1 * c2;
        double vv = a1 * c2 - a2 * c1;
        double mag = Math.abs(uu) + Math.abs(vv);
        if (Math.abs(det) > 1.0E-12 * mag) {
            double u = uu / det;
            double v = vv / det;
            if (u > -1.0E-8 && u < 1.00000001 && v > -1.0E-8 && v < 1.00000001) {
                if (u < 0.0) {
                    u = 0.0;
                }
                if (u > 1.0) {
                    u = 1.0;
                }
                return new EastNorth(x1 + a1 * u, y1 + a2 * u);
            }
            return null;
        }
        return null;
    }

    public static EastNorth getLineLineIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensureValidCoordinates(p1, "p1");
        CheckParameterUtil.ensureValidCoordinates(p2, "p2");
        CheckParameterUtil.ensureValidCoordinates(p3, "p3");
        CheckParameterUtil.ensureValidCoordinates(p4, "p4");
        if (!p1.isValid()) {
            throw new IllegalArgumentException(p1 + " is invalid");
        }
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double c2 = (p4.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p3.getX() - p1.getX()) * (p4.getY() - p1.getY());
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return new EastNorth(b1 * c2 / det + p1.getX(), -a1 * c2 / det + p1.getY());
    }

    public static boolean segmentsParallel(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensureValidCoordinates(p1, "p1");
        CheckParameterUtil.ensureValidCoordinates(p2, "p2");
        CheckParameterUtil.ensureValidCoordinates(p3, "p3");
        CheckParameterUtil.ensureValidCoordinates(p4, "p4");
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double det = a1 * b2 - a2 * b1;
        return Math.abs(det /= Math.sqrt(a1 * a1 + b1 * b1) * Math.sqrt(a2 * a2 + b2 * b2)) < 0.001;
    }

    private static EastNorth closestPointTo(EastNorth p1, EastNorth p2, EastNorth point, boolean segmentOnly) {
        CheckParameterUtil.ensureParameterNotNull(p1, "p1");
        CheckParameterUtil.ensureParameterNotNull(p2, "p2");
        CheckParameterUtil.ensureParameterNotNull(point, "point");
        double ldx = p2.getX() - p1.getX();
        double ldy = p2.getY() - p1.getY();
        if (ldx == 0.0 && ldy == 0.0) {
            return p1;
        }
        double pdx = point.getX() - p1.getX();
        double pdy = point.getY() - p1.getY();
        double offset = (pdx * ldx + pdy * ldy) / (ldx * ldx + ldy * ldy);
        if (segmentOnly && offset <= 0.0) {
            return p1;
        }
        if (segmentOnly && offset >= 1.0) {
            return p2;
        }
        return new EastNorth(p1.getX() + ldx * offset, p1.getY() + ldy * offset);
    }

    public static EastNorth closestPointToSegment(EastNorth segmentP1, EastNorth segmentP2, EastNorth point) {
        return Geometry.closestPointTo(segmentP1, segmentP2, point, true);
    }

    public static EastNorth closestPointToLine(EastNorth lineP1, EastNorth lineP2, EastNorth point) {
        return Geometry.closestPointTo(lineP1, lineP2, point, false);
    }

    public static boolean angleIsClockwise(EastNorth commonNode, EastNorth firstNode, EastNorth secondNode) {
        CheckParameterUtil.ensureValidCoordinates(commonNode, "commonNode");
        CheckParameterUtil.ensureValidCoordinates(firstNode, "firstNode");
        CheckParameterUtil.ensureValidCoordinates(secondNode, "secondNode");
        double dy1 = firstNode.getY() - commonNode.getY();
        double dy2 = secondNode.getY() - commonNode.getY();
        double dx1 = firstNode.getX() - commonNode.getX();
        double dx2 = secondNode.getX() - commonNode.getX();
        return dy1 * dx2 - dx1 * dy2 > 0.0;
    }

    public static Area getArea(List<Node> polygon) {
        Path2D.Double path = new Path2D.Double();
        boolean begin = true;
        for (Node n : polygon) {
            EastNorth en = n.getEastNorth();
            if (en == null) continue;
            if (begin) {
                ((Path2D)path).moveTo(en.getX(), en.getY());
                begin = false;
                continue;
            }
            ((Path2D)path).lineTo(en.getX(), en.getY());
        }
        if (!begin) {
            path.closePath();
        }
        return new Area(path);
    }

    public static Area getAreaLatLon(List<Node> polygon) {
        Path2D.Double path = new Path2D.Double();
        boolean begin = true;
        for (Node n : polygon) {
            if (begin) {
                ((Path2D)path).moveTo(n.getCoor().lon(), n.getCoor().lat());
                begin = false;
                continue;
            }
            ((Path2D)path).lineTo(n.getCoor().lon(), n.getCoor().lat());
        }
        if (!begin) {
            path.closePath();
        }
        return new Area(path);
    }

    public static PolygonIntersection polygonIntersection(List<Node> first, List<Node> second) {
        Area a1 = Geometry.getArea(first);
        Area a2 = Geometry.getArea(second);
        return Geometry.polygonIntersection(a1, a2);
    }

    public static PolygonIntersection polygonIntersection(Area a1, Area a2) {
        return Geometry.polygonIntersection(a1, a2, 1.0);
    }

    public static PolygonIntersection polygonIntersection(Area a1, Area a2, double eps) {
        Area inter = new Area(a1);
        inter.intersect(a2);
        Rectangle bounds = inter.getBounds();
        if (inter.isEmpty() || bounds.getHeight() * bounds.getWidth() <= eps) {
            return PolygonIntersection.OUTSIDE;
        }
        if (inter.equals(a1)) {
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (inter.equals(a2)) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node point, List<Node> polygonNodes) {
        if (polygonNodes.size() < 2) {
            return false;
        }
        boolean inside = false;
        Node oldPoint = polygonNodes.get(polygonNodes.size() - 1);
        if (!oldPoint.isLatLonKnown()) {
            return false;
        }
        for (Node newPoint : polygonNodes) {
            Node p2;
            Node p1;
            if (newPoint.equals(oldPoint)) continue;
            if (!newPoint.isLatLonKnown()) {
                return false;
            }
            if (newPoint.getEastNorth().getY() > oldPoint.getEastNorth().getY()) {
                p1 = oldPoint;
                p2 = newPoint;
            } else {
                p1 = newPoint;
                p2 = oldPoint;
            }
            if (newPoint.getEastNorth().getY() < point.getEastNorth().getY() == point.getEastNorth().getY() <= oldPoint.getEastNorth().getY() && (point.getEastNorth().getX() - p1.getEastNorth().getX()) * (p2.getEastNorth().getY() - p1.getEastNorth().getY()) < (p2.getEastNorth().getX() - p1.getEastNorth().getX()) * (point.getEastNorth().getY() - p1.getEastNorth().getY())) {
                inside = !inside;
            }
            oldPoint = newPoint;
        }
        return inside;
    }

    public static double closedWayArea(Way way) {
        double area = 0.0;
        Node lastN = null;
        for (Node n : way.getNodes()) {
            if (lastN != null) {
                n.getEastNorth().getX();
                area += Geometry.calcX(n) * Geometry.calcY(lastN) - Geometry.calcY(n) * Geometry.calcX(lastN);
            }
            lastN = n;
        }
        return Math.abs(area / 2.0);
    }

    protected static double calcX(Node p1) {
        double lat1 = p1.getCoor().lat() * Math.PI / 180.0;
        double lon1 = p1.getCoor().lon() * Math.PI / 180.0;
        double lat2 = lat1;
        double lon2 = 0.0;
        double dlon = lon2 - lon1;
        double dlat = lat2 - lat1;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dlon / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6367000.0 * c;
    }

    protected static double calcY(Node p1) {
        double lat1 = p1.getCoor().lat() * Math.PI / 180.0;
        double lon1 = p1.getCoor().lon() * Math.PI / 180.0;
        double lat2 = 0.0;
        double lon2 = lon1;
        double dlon = lon2 - lon1;
        double dlat = lat2 - lat1;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dlon / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6367000.0 * c;
    }

    public static boolean isClockwise(Way w) {
        if (!w.isClosed()) {
            throw new IllegalArgumentException("Way must be closed to check orientation.");
        }
        double area2 = 0.0;
        int nodesCount = w.getNodesCount();
        for (int node = 1; node <= nodesCount; ++node) {
            LatLon coorPrev = w.getNode(node - 1).getCoor();
            LatLon coorCurr = w.getNode(node % nodesCount).getCoor();
            area2 += coorPrev.lon() * coorCurr.lat();
            area2 -= coorCurr.lon() * coorPrev.lat();
        }
        return area2 < 0.0;
    }

    public static double getSegmentAngle(EastNorth p1, EastNorth p2) {
        CheckParameterUtil.ensureValidCoordinates(p1, "p1");
        CheckParameterUtil.ensureValidCoordinates(p2, "p2");
        return Math.atan2(p2.north() - p1.north(), p2.east() - p1.east());
    }

    public static double getCornerAngle(EastNorth p1, EastNorth p2, EastNorth p3) {
        CheckParameterUtil.ensureValidCoordinates(p1, "p1");
        CheckParameterUtil.ensureValidCoordinates(p2, "p2");
        CheckParameterUtil.ensureValidCoordinates(p3, "p3");
        Double result = Geometry.getSegmentAngle(p2, p1) - Geometry.getSegmentAngle(p2, p3);
        if (result <= -Math.PI) {
            result = result + Math.PI * 2;
        }
        if (result > Math.PI) {
            result = result - Math.PI * 2;
        }
        return result;
    }

    public static EastNorth getCentroid(List<Node> nodes) {
        BigDecimal area = BigDecimal.ZERO;
        BigDecimal north = BigDecimal.ZERO;
        BigDecimal east = BigDecimal.ZERO;
        for (int i = 0; i < nodes.size(); ++i) {
            EastNorth n0 = nodes.get(i).getEastNorth();
            EastNorth n1 = nodes.get((i + 1) % nodes.size()).getEastNorth();
            if (n0 == null || n1 == null || !n0.isValid() || !n1.isValid()) continue;
            BigDecimal x0 = BigDecimal.valueOf(n0.east());
            BigDecimal y0 = BigDecimal.valueOf(n0.north());
            BigDecimal x1 = BigDecimal.valueOf(n1.east());
            BigDecimal y1 = BigDecimal.valueOf(n1.north());
            BigDecimal k = x0.multiply(y1, MathContext.DECIMAL128).subtract(y0.multiply(x1, MathContext.DECIMAL128));
            area = area.add(k, MathContext.DECIMAL128);
            east = east.add(k.multiply(x0.add(x1, MathContext.DECIMAL128), MathContext.DECIMAL128));
            north = north.add(k.multiply(y0.add(y1, MathContext.DECIMAL128), MathContext.DECIMAL128));
        }
        BigDecimal d = new BigDecimal(3, MathContext.DECIMAL128);
        if ((area = area.multiply(d, MathContext.DECIMAL128)).compareTo(BigDecimal.ZERO) != 0) {
            north = north.divide(area, MathContext.DECIMAL128);
            east = east.divide(area, MathContext.DECIMAL128);
        }
        return new EastNorth(east.doubleValue(), north.doubleValue());
    }

    public static EastNorth getCenter(List<Node> nodes) {
        int nc = nodes.size();
        if (nc < 3) {
            return null;
        }
        double[] a = new double[nc];
        double[] b = new double[nc];
        double[] c = new double[nc];
        for (int i = 0; i < nc; ++i) {
            EastNorth pt1 = nodes.get(i).getEastNorth();
            EastNorth pt2 = nodes.get((i + 1) % nc).getEastNorth();
            a[i] = pt1.east() - pt2.east();
            b[i] = pt1.north() - pt2.north();
            double d = Math.sqrt(a[i] * a[i] + b[i] * b[i]);
            if (d == 0.0) {
                return null;
            }
            int n = i;
            a[n] = a[n] / d;
            int n2 = i;
            b[n2] = b[n2] / d;
            double xC = (pt1.east() + pt2.east()) / 2.0;
            double yC = (pt1.north() + pt2.north()) / 2.0;
            c[i] = -(a[i] * xC + b[i] * yC);
        }
        double a11 = 0.0;
        double a12 = 0.0;
        double a22 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < nc; ++i) {
            a11 += a[i] * a[i];
            a12 += a[i] * b[i];
            a22 += b[i] * b[i];
            b1 -= a[i] * c[i];
            b2 -= b[i] * c[i];
        }
        double det = a11 * a22 - a12 * a12;
        if (Math.abs(det) < 1.0E-5) {
            return null;
        }
        double inv11 = a22 / det;
        double inv12 = -a12 / det;
        double inv22 = a11 / det;
        double xC = inv11 * b1 + inv12 * b2;
        double yC = inv12 * b1 + inv22 * b2;
        return new EastNorth(xC, yC);
    }

    public static boolean isNodeInsideMultiPolygon(Node node, Relation multiPolygon, Predicate<Way> isOuterWayAMatch) {
        return Geometry.isPolygonInsideMultiPolygon(Collections.singletonList(node), multiPolygon, isOuterWayAMatch);
    }

    public static boolean isPolygonInsideMultiPolygon(List<Node> nodes, Relation multiPolygon, Predicate<Way> isOuterWayAMatch) {
        List<MultipolygonBuilder.JoinedPolygon> innerRings;
        List<MultipolygonBuilder.JoinedPolygon> outerRings;
        MultiPolygonMembers mpm = new MultiPolygonMembers(multiPolygon);
        try {
            outerRings = MultipolygonBuilder.joinWays(mpm.outers);
            innerRings = MultipolygonBuilder.joinWays(mpm.inners);
        }
        catch (MultipolygonBuilder.JoinedPolygonCreationException ex) {
            Main.debug("Invalid multipolygon " + multiPolygon);
            return false;
        }
        for (MultipolygonBuilder.JoinedPolygon out : outerRings) {
            if (!(nodes.size() == 1 ? Geometry.nodeInsidePolygon(nodes.get(0), out.getNodes()) : EnumSet.of(PolygonIntersection.FIRST_INSIDE_SECOND, PolygonIntersection.CROSSING).contains((Object)Geometry.polygonIntersection(nodes, out.getNodes())))) continue;
            boolean insideInner = false;
            for (MultipolygonBuilder.JoinedPolygon in : innerRings) {
                if (Geometry.polygonIntersection(in.getNodes(), out.getNodes()) != PolygonIntersection.FIRST_INSIDE_SECOND || !(nodes.size() == 1 ? Geometry.nodeInsidePolygon(nodes.get(0), in.getNodes()) : Geometry.polygonIntersection(nodes, in.getNodes()) == PolygonIntersection.FIRST_INSIDE_SECOND)) continue;
                insideInner = true;
                break;
            }
            if (insideInner || isOuterWayAMatch != null && !isOuterWayAMatch.evaluate(out.ways.get(0))) continue;
            return true;
        }
        return false;
    }

    public static class MultiPolygonMembers {
        public final Set<Way> outers = new HashSet<Way>();
        public final Set<Way> inners = new HashSet<Way>();

        public MultiPolygonMembers(Relation multiPolygon) {
            for (RelationMember m : multiPolygon.getMembers()) {
                if (!m.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                if ("outer".equals(m.getRole())) {
                    this.outers.add(m.getWay());
                    continue;
                }
                if (!"inner".equals(m.getRole())) continue;
                this.inners.add(m.getWay());
            }
        }
    }

    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

