/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.io.CachedFile;

public class FontsManager {
    public static final Collection<String> INCLUDED_FONTS = Arrays.asList("DroidSans.ttf", "DroidSans-Bold.ttf");

    public static void initialize() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontFile : INCLUDED_FONTS) {
            String url = "resource://data/fonts/" + fontFile;
            try {
                InputStream i = new CachedFile(url).getInputStream();
                Throwable throwable = null;
                try {
                    Font f = Font.createFont(0, i);
                    if (f == null) {
                        throw new RuntimeException("unable to load font: " + fontFile);
                    }
                    ge.registerFont(f);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (i == null) continue;
                    if (throwable != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    i.close();
                }
            }
            catch (FontFormatException | IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

