/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.date.PrimaryDateParser;

public final class ExifReader {
    public static Date readTime(File filename) throws ParseException {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            String dateStr = null;
            block3: for (Directory dirIt : metadata.getDirectories()) {
                for (Tag tag : dirIt.getTags()) {
                    if (tag.getTagType() == 36867) {
                        dateStr = tag.getDescription();
                        break block3;
                    }
                    if (tag.getTagType() != 306 && tag.getTagType() != 36868) continue;
                    dateStr = tag.getDescription();
                }
            }
            if (dateStr != null) {
                dateStr = dateStr.replace('/', ':');
                return new PrimaryDateParser().parse(dateStr);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            Main.error(e);
        }
        return null;
    }

    public static Integer readOrientation(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            ExifIFD0Directory dir = metadata.getDirectory(ExifIFD0Directory.class);
            return dir.getInt(274);
        }
        catch (JpegProcessingException | MetadataException | IOException e) {
            Main.error(e);
            return null;
        }
    }

    public static LatLon readLatLon(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getDirectory(GpsDirectory.class);
            return ExifReader.readLatLon(dirGps);
        }
        catch (JpegProcessingException e) {
            Main.error(e);
        }
        catch (IOException e) {
            Main.error(e);
        }
        catch (MetadataException e) {
            Main.error(e);
        }
        return null;
    }

    public static LatLon readLatLon(GpsDirectory dirGps) throws MetadataException {
        if (dirGps != null) {
            double lat = ExifReader.readAxis(dirGps, 2, 1, 'S');
            double lon = ExifReader.readAxis(dirGps, 4, 3, 'W');
            return new LatLon(lat, lon);
        }
        return null;
    }

    public static Double readDirection(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getDirectory(GpsDirectory.class);
            return ExifReader.readDirection(dirGps);
        }
        catch (JpegProcessingException e) {
            Main.error(e);
        }
        catch (IOException e) {
            Main.error(e);
        }
        return null;
    }

    public static Double readDirection(GpsDirectory dirGps) {
        Rational direction;
        if (dirGps != null && (direction = dirGps.getRational(17)) != null) {
            return direction.doubleValue();
        }
        return null;
    }

    private static double readAxis(GpsDirectory dirGps, int gpsTag, int gpsTagRef, char cRef) throws MetadataException {
        double value;
        Rational[] components = dirGps.getRationalArray(gpsTag);
        if (components != null) {
            double deg = components[0].doubleValue();
            double min = components[1].doubleValue();
            double sec = components[2].doubleValue();
            if (Double.isNaN(deg) && Double.isNaN(min) && Double.isNaN(sec)) {
                throw new IllegalArgumentException("deg, min and sec are NaN");
            }
            double d = Double.isNaN(deg) ? 0.0 : (value = deg + (Double.isNaN(min) ? 0.0 : min / 60.0) + (Double.isNaN(sec) ? 0.0 : sec / 3600.0));
            if (dirGps.getString(gpsTagRef).charAt(0) == cRef) {
                value = -value;
            }
        } else {
            value = dirGps.getDouble(gpsTag);
        }
        return value;
    }

    public static AffineTransform getRestoreOrientationTransform(int orientation, int width, int height) {
        double ay;
        double ax;
        int q;
        switch (orientation) {
            case 8: {
                q = -1;
                ax = width / 2;
                ay = width / 2;
                break;
            }
            case 3: {
                q = 2;
                ax = width / 2;
                ay = height / 2;
                break;
            }
            case 6: {
                q = 1;
                ax = height / 2;
                ay = height / 2;
                break;
            }
            default: {
                q = 0;
                ax = 0.0;
                ay = 0.0;
            }
        }
        return AffineTransform.getQuadrantRotateInstance(q, ax, ay);
    }

    public static boolean orientationSwitchesDimensions(int orientation) {
        return orientation == 6 || orientation == 8;
    }

    public static boolean orientationNeedsCorrection(int orientation) {
        return orientation == 3 || orientation == 6 || orientation == 8;
    }
}

