/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class CopyList<E>
extends AbstractList<E>
implements Cloneable,
RandomAccess {
    private E[] array;
    private int size;
    private boolean pristine;

    public CopyList(E[] array) {
        this(array, array.length);
    }

    public CopyList(E[] array, int size) {
        this.array = array;
        this.size = size;
        this.pristine = true;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        this.changeCheck();
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        this.array[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        this.changeCheck();
        ++this.modCount;
        E element = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        } else {
            this.array[index] = null;
        }
        --this.size;
        return element;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        this.array[this.size++] = element;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        while (this.size > 0) {
            this.array[--this.size] = null;
        }
    }

    public Object clone() {
        return new CopyList<E>(this.array, this.size);
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index + " Size:" + this.size);
        }
    }

    private void changeCheck() {
        if (this.pristine) {
            this.array = (Object[])this.array.clone();
            this.pristine = false;
        }
    }

    private void ensureCapacity(int target) {
        ++this.modCount;
        if (target > this.array.length) {
            int newCapacity = Math.max(target, this.array.length * 3 / 2 + 1);
            this.array = Arrays.copyOf(this.array, newCapacity);
            this.pristine = false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    static /* synthetic */ int access$100(CopyList x0) {
        return x0.modCount;
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = CopyList.access$100(CopyList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CopyList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                Object next = CopyList.this.array[this.cursor];
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CopyList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CopyList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CopyList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

