/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public final class CheckParameterUtil {
    public static void ensureValidPrimitiveId(PrimitiveId id, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (id.getUniqueId() <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected unique id > 0 for primitive ''{1}'', got {0}", id.getUniqueId(), parameterName));
        }
    }

    public static void ensureValidCoordinates(LatLon latlon, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(latlon, parameterName);
        if (!latlon.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected valid lat/lon for parameter ''{0}'', got {1}", parameterName, latlon));
        }
    }

    public static void ensureValidCoordinates(EastNorth eastnorth, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(eastnorth, parameterName);
        if (!eastnorth.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected valid east/north for parameter ''{0}'', got {1}", parameterName, eastnorth));
        }
    }

    public static void ensureValidVersion(long version, String parameterName) throws IllegalArgumentException {
        if (version < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type long > 0 for parameter ''{0}'', got {1}", parameterName, version));
        }
    }

    public static void ensureParameterNotNull(Object value, String parameterName) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be null", parameterName));
        }
    }

    public static void ensureParameterNotNull(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
    }

    public static void ensureThat(boolean condition, String message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureValidNodeId(PrimitiveId id, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (!id.getType().equals((Object)OsmPrimitiveType.NODE)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' of type node expected, got ''{1}''", parameterName, id.getType().getAPIName()));
        }
    }
}

