/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WikiReader;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean handlingInProgress = false;
    private static volatile BugReporterThread bugReporterThread = null;
    private static int exceptionCounter = 0;
    private static boolean suppressExceptionDialogs = false;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        BugReportExceptionHandler.handleException(e);
    }

    public void handle(Throwable t) {
        BugReportExceptionHandler.handleException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(Throwable e) {
        if (handlingInProgress || suppressExceptionDialogs) {
            return;
        }
        if (bugReporterThread != null && bugReporterThread.isAlive()) {
            return;
        }
        handlingInProgress = true;
        ++exceptionCounter;
        try {
            Main.error(e);
            if (Main.parent != null) {
                if (e instanceof OutOfMemoryError) {
                    JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                    return;
                }
                bugReporterThread = new BugReporterThread(e);
                bugReporterThread.start();
            }
        }
        finally {
            handlingInProgress = false;
        }
    }

    private static void askForBugReport(Throwable e) {
        try {
            int maxlen = 6000;
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            String text = ShowStatusReportAction.getReportHeader() + stack.getBuffer().toString();
            String urltext = text.replaceAll("\r", "");
            if (urltext.length() > 6000) {
                int idx = (urltext = urltext.substring(0, 6000)).lastIndexOf(10);
                if (6000 - idx < 200) {
                    urltext = urltext.substring(0, idx + 1);
                }
                urltext = urltext + "...<snip>...\n";
            }
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)new JMultilineLabel(I18n.tr("You have encountered an error in JOSM. Before you file a bug report make sure you have updated to the latest version of JOSM here:", new Object[0])), GBC.eol().fill(2));
            p.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eop().insets(8, 0, 0, 0));
            p.add((Component)new JMultilineLabel(I18n.tr("You should also update your plugins. If neither of those help please file a bug report in our bugtracker using this link:", new Object[0])), GBC.eol().fill(2));
            p.add((Component)BugReportExceptionHandler.getBugReportUrlLabel(urltext), GBC.eop().insets(8, 0, 0, 0));
            p.add((Component)new JMultilineLabel(I18n.tr("There the error information provided below should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.", new Object[0])), GBC.eop().fill(2));
            p.add((Component)new JMultilineLabel(I18n.tr("Alternatively, if that does not work you can manually fill in the information below at this URL:", new Object[0])), GBC.eol().fill(2));
            p.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket", 2), GBC.eop().insets(8, 0, 0, 0));
            text = "{{{\n" + text + "}}}";
            if (Utils.copyToClipboard(text)) {
                p.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)", new Object[0])), GBC.eop().fill(2));
            }
            JosmTextArea info = new JosmTextArea(text, 18, 60);
            info.setCaretPosition(0);
            info.setEditable(false);
            p.add((Component)new JScrollPane(info), GBC.eop().fill());
            for (Component c : p.getComponents()) {
                if (!(c instanceof JMultilineLabel)) continue;
                ((JMultilineLabel)c).setMaxWidth(400);
            }
            JOptionPane.showMessageDialog(Main.parent, p, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
        }
        catch (Exception e1) {
            Main.error(e1);
        }
    }

    public static boolean exceptionHandlingInProgress() {
        return handlingInProgress;
    }

    /*
     * Exception decompiling
     */
    public static URL getBugReportUrl(String debugText) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final UrlLabel getBugReportUrlLabel(String debugText) {
        URL url = BugReportExceptionHandler.getBugReportUrl(debugText);
        if (url != null) {
            return new UrlLabel(url.toString(), Main.getJOSMWebsite() + "/josmticket?...", 2);
        }
        return null;
    }

    private static class BugReporterThread
    extends Thread {
        final Throwable e;

        public BugReporterThread(Throwable t) {
            super("Bug Reporter");
            this.e = t;
        }

        @Override
        public void run() {
            final PluginDownloadTask pluginDownloadTask = PluginHandler.updateOrdisablePluginAfterException(this.e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (pluginDownloadTask == null) {
                        String[] buttonTexts = new String[]{I18n.tr("Do nothing", new Object[0]), I18n.tr("Report Bug", new Object[0])};
                        String[] buttonIcons = new String[]{"cancel", "bug"};
                        int defaultButtonIdx = 1;
                        String message = I18n.tr("An unexpected exception occurred.<br>This is always a coding error. If you are running the latest<br>version of JOSM, please consider being kind and file a bug report.", new Object[0]);
                        int josmVersion = Version.getInstance().getVersion();
                        if (josmVersion != 0) {
                            try {
                                int latestVersion = Integer.parseInt(new WikiReader().read(Main.getJOSMWebsite() + "/wiki/TestedVersion?format=txt").trim());
                                if (latestVersion > josmVersion) {
                                    buttonTexts = new String[]{I18n.tr("Do nothing", new Object[0]), I18n.tr("Update JOSM", new Object[0]), I18n.tr("Report Bug", new Object[0])};
                                    buttonIcons = new String[]{"cancel", "download", "bug"};
                                    defaultButtonIdx = 2;
                                    message = I18n.tr("An unexpected exception occurred. This is always a coding error.<br><br>However, you are running an old version of JOSM ({0}),<br>instead of using the current tested version (<b>{1}</b>).<br><br><b>Please update JOSM</b> before considering to file a bug report.", String.valueOf(josmVersion), String.valueOf(latestVersion));
                                }
                            }
                            catch (IOException | NumberFormatException e) {
                                Main.warn("Unable to detect latest version of JOSM: " + e.getMessage());
                            }
                        }
                        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Unexpected Exception", new Object[0]), buttonTexts);
                        ed.setButtonIcons(buttonIcons);
                        ed.setIcon(0);
                        ed.setCancelButton(1);
                        ed.setDefaultButton(defaultButtonIdx);
                        JPanel pnl = new JPanel(new GridBagLayout());
                        pnl.add((Component)new JLabel("<html>" + message + "</html>"), GBC.eol());
                        JCheckBox cbSuppress = null;
                        if (exceptionCounter > 1) {
                            cbSuppress = new JCheckBox(I18n.tr("Suppress further error dialogs for this session.", new Object[0]));
                            pnl.add((Component)cbSuppress, GBC.eol());
                        }
                        ed.setContent(pnl);
                        ed.setFocusOnDefaultButton(true);
                        ed.showDialog();
                        if (cbSuppress != null && cbSuppress.isSelected()) {
                            suppressExceptionDialogs = true;
                        }
                        if (ed.getValue() <= 1) {
                            return;
                        }
                        if (ed.getValue() < buttonTexts.length) {
                            try {
                                Main.platform.openUrl(Main.getJOSMWebsite());
                            }
                            catch (IOException e) {
                                Main.warn("Unable to access JOSM website: " + e.getMessage());
                            }
                        } else {
                            BugReportExceptionHandler.askForBugReport(BugReporterThread.this.e);
                        }
                    } else {
                        PluginPreference.notifyDownloadResults(Main.parent, pluginDownloadTask, !pluginDownloadTask.getDownloadedPlugins().isEmpty());
                    }
                }
            });
        }
    }
}

