/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<PluginInformation> availablePlugins;
    private boolean displayErrMsg;

    protected final void init(Collection<String> sites, boolean displayErrMsg) {
        this.sites = sites;
        if (sites == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
        this.displayErrMsg = displayErrMsg;
    }

    public ReadRemotePluginInformationTask(Collection<String> sites) {
        super(I18n.tr("Download plugin list...", new Object[0]), false);
        this.init(sites, true);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor monitor, Collection<String> sites, boolean displayErrMsg) {
        super(I18n.tr("Download plugin list...", new Object[0]), monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        this.init(sites, displayErrMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File pluginDir, String site) {
        String name;
        try {
            site = site.replaceAll("%<(.*)>", "");
            URL url = new URL(site);
            StringBuilder sb = new StringBuilder();
            sb.append("site-");
            sb.append(url.getHost()).append("-");
            if (url.getPort() != -1) {
                sb.append(url.getPort()).append("-");
            }
            String path = url.getPath();
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append("_");
            }
            sb.append(".txt");
            name = sb.toString();
        }
        catch (MalformedURLException e) {
            name = "site-unknown.txt";
        }
        return new File(pluginDir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String downloadPluginList(String site, ProgressMonitor monitor) {
        Object object;
        String pl = Utils.join(",", Main.pref.getCollection("plugins"));
        String printsite = site.replaceAll("%<(.*)>", "");
        site = pl != null && pl.length() != 0 ? site.replaceAll("%<(.*)>", "$1" + pl) : printsite;
        try {
            String string;
            BufferedReader in;
            ReadRemotePluginInformationTask readRemotePluginInformationTask;
            block46: {
                block47: {
                    String line;
                    monitor.beginTask("");
                    monitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", printsite));
                    URL url = new URL(site);
                    readRemotePluginInformationTask = this;
                    synchronized (readRemotePluginInformationTask) {
                        this.connection = Utils.openHttpConnection(url);
                        this.connection.setRequestProperty("Cache-Control", "no-cache");
                        this.connection.setRequestProperty("Accept-Charset", "utf-8");
                    }
                    in = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), StandardCharsets.UTF_8));
                    object = null;
                    StringBuilder sb = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    string = sb.toString();
                    if (in == null) break block46;
                    if (object == null) break block47;
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)object).addSuppressed(x2);
                    }
                    break block46;
                }
                in.close();
            }
            return string;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (in != null) {
                            if (object != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)object).addSuppressed(x2);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (MalformedURLException e) {
                    if (this.canceled) {
                        readRemotePluginInformationTask = null;
                        return readRemotePluginInformationTask;
                    }
                    Main.error(e);
                    readRemotePluginInformationTask = null;
                    return readRemotePluginInformationTask;
                }
                catch (IOException e) {
                    if (this.canceled) {
                        readRemotePluginInformationTask = null;
                        return readRemotePluginInformationTask;
                    }
                    Main.addNetworkError(site, (Throwable)e);
                    this.handleIOException(monitor, e, I18n.tr("Plugin list download error", new Object[0]), I18n.tr("JOSM failed to download plugin list:", new Object[0]), this.displayErrMsg);
                    readRemotePluginInformationTask = null;
                    return readRemotePluginInformationTask;
                }
            }
        }
        finally {
            object = this;
            synchronized (object) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            monitor.finishTask();
        }
    }

    private void handleIOException(ProgressMonitor monitor, IOException e, String title, String firstMessage, boolean displayMsg) {
        StringBuilder sb;
        block32: {
            sb = new StringBuilder();
            try (InputStream errStream = this.connection.getErrorStream();){
                if (errStream == null) break block32;
                try (BufferedReader err = new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = err.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                }
                catch (Exception ex) {
                    Main.error(e);
                    Main.error(ex);
                }
            }
            catch (IOException ex) {
                Main.warn(ex);
            }
        }
        String msg = e.getMessage();
        String details = sb.toString();
        if (details.isEmpty()) {
            Main.error(e.getClass().getSimpleName() + ": " + msg);
        } else {
            Main.error(msg + " - Details:\n" + details);
        }
        if (displayMsg) {
            this.displayErrorMessage(monitor, msg, details, title, firstMessage);
        }
    }

    private void displayErrorMessage(final ProgressMonitor monitor, final String msg, final String details, final String title, final String firstMessage) {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel(firstMessage), GBC.eol().insets(0, 0, 0, 10));
                StringBuilder b = new StringBuilder();
                for (String part : msg.split("(?<=\\G.{200})")) {
                    b.append(part).append("\n");
                }
                panel.add((Component)new JLabel("<html><body width=\"500\"><b>" + b.toString().trim() + "</b></body></html>"), GBC.eol().insets(0, 0, 0, 10));
                if (!details.isEmpty()) {
                    panel.add((Component)new JLabel(I18n.tr("Details:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
                    JosmTextArea area = new JosmTextArea(details);
                    area.setEditable(false);
                    area.setLineWrap(true);
                    area.setWrapStyleWord(true);
                    JScrollPane scrollPane = new JScrollPane(area);
                    scrollPane.setPreferredSize(new Dimension(500, 300));
                    panel.add((Component)scrollPane, GBC.eol().fill());
                }
                JOptionPane.showMessageDialog(monitor.getWindowParent(), panel, title, 0);
            }
        });
    }

    protected void cachePluginList(String site, String list) {
        File pluginDir = Main.pref.getPluginsDirectory();
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            Main.warn(I18n.tr("Failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", pluginDir.toString(), site));
        }
        File cacheFile = this.createSiteCacheFile(pluginDir, site);
        this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", cacheFile.toString()));
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), StandardCharsets.UTF_8));){
            writer.write(list);
            writer.flush();
        }
        catch (IOException e) {
            Main.error(e);
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> plugins) {
        ArrayList<PluginInformation> ret = new ArrayList<PluginInformation>(plugins.size());
        HashSet<String> deprecatedPluginNames = new HashSet<String>();
        for (PluginHandler.DeprecatedPlugin p : PluginHandler.DEPRECATED_PLUGINS) {
            deprecatedPluginNames.add(p.name);
        }
        for (PluginInformation plugin : plugins) {
            if (deprecatedPluginNames.contains(plugin.name)) continue;
            ret.add(plugin);
        }
        return ret;
    }

    protected void parsePluginListDocument(String site, String doc) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", site));
            ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes(StandardCharsets.UTF_8));
            List<PluginInformation> pis = new PluginListParser().parse(in);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(pis));
        }
        catch (PluginListParseException e) {
            Main.error(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", site, e.toString()));
            Main.error(e);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File pluginDir = Main.pref.getPluginsDirectory();
        LinkedList<File> siteCacheFiles = new LinkedList<File>();
        for (String location : PluginInformation.getPluginLocations()) {
            File[] f = new File(location).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("^([0-9]+-)?site.*\\.txt$") || name.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (f == null || f.length <= 0) continue;
            siteCacheFiles.addAll(Arrays.asList(f));
        }
        for (String site : this.sites) {
            String printsite = site.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", printsite));
            String list = this.downloadPluginList(site, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            siteCacheFiles.remove(this.createSiteCacheFile(pluginDir, site));
            if (list == null) continue;
            this.getProgressMonitor().worked(1);
            this.cachePluginList(site, list);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            this.parsePluginListDocument(site, list);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        for (File file : siteCacheFiles) {
            file.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

