/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;

public class PluginProxy
extends Plugin {
    public final Object plugin;

    public PluginProxy(Object plugin, PluginInformation info) {
        super(info);
        this.plugin = plugin;
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        try {
            this.plugin.getClass().getMethod("mapFrameInitialized", MapFrame.class, MapFrame.class).invoke(this.plugin, oldFrame, newFrame);
        }
        catch (NoSuchMethodException e) {
            Main.debug("Plugin " + this.plugin + " does not define mapFrameInitialized");
        }
        catch (Exception e) {
            BugReportExceptionHandler.handleException(new PluginException(this, this.getPluginInformation().name, e));
        }
    }

    @Override
    public PreferenceSetting getPreferenceSetting() {
        try {
            return (PreferenceSetting)this.plugin.getClass().getMethod("getPreferenceSetting", new Class[0]).invoke(this.plugin, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Main.debug("Plugin " + this.plugin + " does not define getPreferenceSetting");
            return null;
        }
        catch (Exception e) {
            BugReportExceptionHandler.handleException(new PluginException(this, this.getPluginInformation().name, e));
            return null;
        }
    }

    @Override
    public void addDownloadSelection(List<DownloadSelection> list) {
        try {
            this.plugin.getClass().getMethod("addDownloadSelection", List.class).invoke(this.plugin, list);
        }
        catch (NoSuchMethodException e) {
            Main.debug("Plugin " + this.plugin + " does not define addDownloadSelection");
        }
        catch (Exception e) {
            BugReportExceptionHandler.handleException(new PluginException(this, this.getPluginInformation().name, e));
        }
    }
}

