/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class PluginInformation {
    public File file = null;
    public String name = null;
    public int mainversion = 0;
    public int localmainversion = 0;
    public String className = null;
    public boolean oldmode = false;
    public String requires = null;
    public String localrequires = null;
    public String link = null;
    public String description = null;
    public boolean early = false;
    public String author = null;
    public int stage = 50;
    public String version = null;
    public String localversion = null;
    public String downloadlink = null;
    public String iconPath;
    public ImageIcon icon;
    public boolean canloadatruntime = false;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    private static final ImageIcon emptyIcon = new ImageIcon(new BufferedImage(24, 24, 2));

    public PluginInformation(File file) throws PluginException {
        this(file, file.getName().substring(0, file.getName().length() - 4));
    }

    public PluginInformation(File file, String name) throws PluginException {
        if (!PluginHandler.isValidJar(file)) {
            throw new PluginException(name, I18n.tr("Invalid jar file ''{0}''", file));
        }
        this.name = name;
        this.file = file;
        try (FileInputStream fis = new FileInputStream(file);
             JarInputStream jar = new JarInputStream(fis);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new PluginException(name, I18n.tr("The plugin file ''{0}'' does not include a Manifest.", file.toString()));
            }
            this.scanManifest(manifest, false);
            this.libraries.add(0, Utils.fileToURL(file));
        }
        catch (IOException e) {
            throw new PluginException(name, e);
        }
    }

    public PluginInformation(InputStream manifestStream, String name, String url) throws PluginException {
        this.name = name;
        try {
            Manifest manifest = new Manifest();
            manifest.read(manifestStream);
            if (url != null) {
                this.downloadlink = url;
            }
            this.scanManifest(manifest, url != null);
        }
        catch (IOException e) {
            throw new PluginException(name, e);
        }
    }

    public void updateFromPluginSite(PluginInformation other) {
        this.mainversion = other.mainversion;
        this.className = other.className;
        this.requires = other.requires;
        this.link = other.link;
        this.description = other.description;
        this.early = other.early;
        this.author = other.author;
        this.stage = other.stage;
        this.version = other.version;
        this.downloadlink = other.downloadlink;
        this.icon = other.icon;
        this.iconPath = other.iconPath;
        this.canloadatruntime = other.canloadatruntime;
        this.libraries = other.libraries;
        this.attr.clear();
        this.attr.putAll(other.attr);
    }

    public void updateFromJar(PluginInformation other) {
        this.updateLocalInfo(other);
        if (other.icon != null) {
            this.icon = other.icon;
        }
        this.early = other.early;
        this.className = other.className;
        this.canloadatruntime = other.canloadatruntime;
        this.libraries = other.libraries;
        this.stage = other.stage;
    }

    private final void scanManifest(Manifest manifest, boolean oldcheck) {
        String classPath;
        String lang = LanguageInfo.getLanguageCodeManifest();
        Attributes attr = manifest.getMainAttributes();
        this.className = attr.getValue("Plugin-Class");
        String s = attr.getValue(lang + "Plugin-Link");
        if (s == null) {
            s = attr.getValue("Plugin-Link");
        }
        if (s != null) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                Main.info(I18n.tr("Invalid URL ''{0}'' in plugin {1}", s, this.name));
                s = null;
            }
        }
        this.link = s;
        this.requires = attr.getValue("Plugin-Requires");
        s = attr.getValue(lang + "Plugin-Description");
        if (s == null) {
            s = attr.getValue("Plugin-Description");
            if (s != null) {
                try {
                    s = I18n.tr(s, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    Main.info(I18n.tr("Invalid plugin description ''{0}'' in plugin {1}", s, this.name));
                }
            }
        } else {
            s = MessageFormat.format(s, null);
        }
        this.description = s;
        this.early = Boolean.parseBoolean(attr.getValue("Plugin-Early"));
        String stageStr = attr.getValue("Plugin-Stage");
        this.stage = stageStr == null ? 50 : Integer.parseInt(stageStr);
        this.version = attr.getValue("Plugin-Version");
        s = attr.getValue("Plugin-Mainversion");
        if (s != null) {
            try {
                this.mainversion = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Main.warn(I18n.tr("Invalid plugin main version ''{0}'' in plugin {1}", s, this.name));
            }
        } else {
            Main.warn(I18n.tr("Missing plugin main version in plugin {0}", this.name));
        }
        this.author = attr.getValue("Author");
        this.iconPath = attr.getValue("Plugin-Icon");
        if (this.iconPath != null) {
            if (this.file != null) {
                this.icon = new ImageProvider(this.iconPath).setArchive(this.file).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
            } else if (this.iconPath.startsWith("data:")) {
                this.icon = new ImageProvider(this.iconPath).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
            }
        }
        this.canloadatruntime = Boolean.parseBoolean(attr.getValue("Plugin-Canloadatruntime"));
        if (oldcheck && this.mainversion > Version.getInstance().getVersion()) {
            int myv = Version.getInstance().getVersion();
            for (Map.Entry entry : attr.entrySet()) {
                try {
                    String v;
                    int i;
                    int mv;
                    String key = ((Attributes.Name)entry.getKey()).toString();
                    if (!key.endsWith("_Plugin-Url") || (mv = Integer.parseInt(key.substring(0, key.length() - 11))) > myv || mv <= this.mainversion && this.mainversion <= myv || (i = (v = (String)entry.getValue()).indexOf(59)) <= 0) continue;
                    this.downloadlink = v.substring(i + 1);
                    this.mainversion = mv;
                    this.version = v.substring(0, i);
                    this.oldmode = true;
                }
                catch (Exception e) {
                    Main.error(e);
                }
            }
        }
        if ((classPath = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String entry : classPath.split(" ")) {
                File entryFile = new File(entry).isAbsolute() || this.file == null ? new File(entry) : new File(this.file.getParent(), entry);
                this.libraries.add(Utils.fileToURL(entryFile));
            }
        }
        for (Object object : attr.keySet()) {
            this.attr.put(object.toString(), attr.getValue(object.toString()));
        }
    }

    public String getDescriptionAsHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append(this.description == null ? I18n.tr("no description available", new Object[0]) : this.description);
        if (this.link != null) {
            sb.append(" <a href=\"").append(this.link).append("\">").append(I18n.tr("More info...", new Object[0])).append("</a>");
        }
        if (!(this.downloadlink == null || this.downloadlink.startsWith("http://svn.openstreetmap.org/applications/editors/josm/dist/") || this.downloadlink.startsWith("https://svn.openstreetmap.org/applications/editors/josm/dist/") || this.downloadlink.startsWith("http://trac.openstreetmap.org/browser/applications/editors/josm/dist/") || this.downloadlink.startsWith("https://github.com/JOSM/"))) {
            sb.append("<p>&nbsp;</p><p>" + I18n.tr("<b>Plugin provided by an external source:</b> {0}", this.downloadlink) + "</p>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public PluginProxy load(Class<?> klass) throws PluginException {
        try {
            Constructor<?> c = klass.getConstructor(PluginInformation.class);
            Object plugin = c.newInstance(this);
            return new PluginProxy(plugin, this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PluginException(this.name, e);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) throws PluginException {
        if (this.className == null) {
            return null;
        }
        try {
            return Class.forName(this.className, true, classLoader);
        }
        catch (ClassCastException | ClassNotFoundException | NoClassDefFoundError e) {
            throw new PluginException(this.name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginInformation findPlugin(String pluginName) throws PluginException {
        String s;
        File pluginFile;
        String name = pluginName;
        name = name.replaceAll("[-. ]", "");
        try (InputStream manifestStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + name + "/MANIFEST.MF");){
            if (manifestStream != null) {
                PluginInformation pluginInformation = new PluginInformation(manifestStream, pluginName, null);
                return pluginInformation;
            }
        }
        catch (IOException e) {
            Main.warn(e);
        }
        Collection<String> locations = PluginInformation.getPluginLocations();
        Iterator<String> i$ = locations.iterator();
        do {
            if (!i$.hasNext()) return null;
        } while (!(pluginFile = new File(s = i$.next(), pluginName + ".jar")).exists());
        return new PluginInformation(pluginFile);
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> locations = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> all = new ArrayList<String>(locations.size());
        for (String s : locations) {
            all.add(s + "plugins");
        }
        return all;
    }

    public boolean isUpdateRequired(String referenceVersion) {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.version == null && referenceVersion != null) {
            return true;
        }
        return this.version != null && !this.version.equals(referenceVersion);
    }

    public boolean isUpdateRequired() {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.localversion == null) {
            return true;
        }
        return this.isUpdateRequired(this.localversion);
    }

    protected boolean matches(String filter, String value) {
        if (filter == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.toLowerCase().contains(filter.toLowerCase());
    }

    public boolean matches(String filter) {
        String[] words;
        if (filter == null) {
            return true;
        }
        for (String word : words = filter.split("\\s+")) {
            if (!this.matches(word, this.name) && !this.matches(word, this.description) && !this.matches(word, this.version) && !this.matches(word, this.localversion)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImageIcon getScaledIcon() {
        if (this.icon == null) {
            return emptyIcon;
        }
        return new ImageIcon(this.icon.getImage().getScaledInstance(24, 24, 4));
    }

    public final String toString() {
        return this.getName();
    }

    private static List<String> getRequiredPlugins(String pluginList) {
        ArrayList<String> requiredPlugins = new ArrayList<String>();
        if (pluginList != null) {
            for (String s : pluginList.split(";")) {
                String plugin = s.trim();
                if (plugin.isEmpty()) continue;
                requiredPlugins.add(plugin);
            }
        }
        return requiredPlugins;
    }

    public List<String> getRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.requires);
    }

    public List<String> getLocalRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.localrequires);
    }

    public void updateLocalInfo(PluginInformation info) {
        if (info != null) {
            this.localversion = info.version;
            this.localmainversion = info.mainversion;
            this.localrequires = info.requires;
        }
    }
}

