/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class PluginHandler {
    public static final Collection<DeprecatedPlugin> DEPRECATED_PLUGINS;
    private static final String[] UNMAINTAINED_PLUGINS;
    public static final int DEFAULT_TIME_BASED_UPDATE_INTERVAL = 30;
    public static final Collection<PluginProxy> pluginList;
    private static DynamicURLClassLoader pluginClassLoader;
    private static final List<ClassLoader> sources;
    private static PluginDownloadTask pluginDownloadTask;

    private PluginHandler() {
    }

    public static Collection<ClassLoader> getResourceClassLoaders() {
        return Collections.unmodifiableCollection(sources);
    }

    private static void filterDeprecatedPlugins(Component parent, Collection<String> plugins) {
        TreeSet<DeprecatedPlugin> removedPlugins = new TreeSet<DeprecatedPlugin>();
        for (DeprecatedPlugin depr : DEPRECATED_PLUGINS) {
            if (!plugins.contains(depr.name)) continue;
            plugins.remove(depr.name);
            Main.pref.removeFromCollection("plugins", depr.name);
            removedPlugins.add(depr);
            depr.migrate();
        }
        if (removedPlugins.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", removedPlugins.size(), new Object[0]));
        sb.append("<ul>");
        for (DeprecatedPlugin depr : removedPlugins) {
            sb.append("<li>").append(depr.name);
            if (depr.reason != null) {
                sb.append(" (").append(depr.reason).append(")");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2);
    }

    private static void filterUnmaintainedPlugins(Component parent, Collection<String> plugins) {
        for (String unmaintained : UNMAINTAINED_PLUGINS) {
            if (!plugins.contains(unmaintained)) continue;
            String msg = I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", unmaintained);
            if (!PluginHandler.confirmDisablePlugin(parent, msg, unmaintained)) continue;
            Main.pref.removeFromCollection("plugins", unmaintained);
            plugins.remove(unmaintained);
        }
    }

    public static boolean checkAndConfirmPluginUpdate(Component parent) {
        String policy;
        if (!PluginHandler.checkOfflineAccess()) {
            Main.info(I18n.tr("{0} not available (offline mode)", I18n.tr("Plugin update", new Object[0])));
            return false;
        }
        String message = null;
        String togglePreferenceKey = null;
        int v = Version.getInstance().getVersion();
        if (Main.pref.getInteger("pluginmanager.version", 0) < v) {
            message = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?", new Object[0]) + "</html>";
            togglePreferenceKey = "pluginmanager.version-based-update.policy";
        } else {
            long tim = System.currentTimeMillis();
            long last = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer maxTime = Main.pref.getInteger("pluginmanager.time-based-update.interval", 30);
            long d = (tim - last) / 86400000L;
            if (last <= 0L || maxTime <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(tim));
            } else if (d > (long)maxTime.intValue()) {
                message = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", d) + "</html>";
                togglePreferenceKey = "pluginmanager.time-based-update.policy";
            }
        }
        if (message == null) {
            return false;
        }
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the activated plugins", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to skip updating the activated plugins", new Object[0]), null)};
        UpdatePluginsMessagePanel pnlMessage = new UpdatePluginsMessagePanel();
        pnlMessage.setMessage(message);
        pnlMessage.initDontShowAgain(togglePreferenceKey);
        switch (policy = Main.pref.get(togglePreferenceKey, "ask").trim().toLowerCase()) {
            case "never": {
                if ("pluginmanager.version-based-update.policy".equals(togglePreferenceKey)) {
                    Main.info(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                    Main.info(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return false;
            }
            case "always": {
                if ("pluginmanager.version-based-update.policy".equals(togglePreferenceKey)) {
                    Main.info(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                    Main.info(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return true;
            }
            case "ask": {
                break;
            }
            default: {
                Main.warn(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", policy, togglePreferenceKey));
            }
        }
        int ret = HelpAwareOptionPane.showOptionDialog(parent, pnlMessage, I18n.tr("Update plugins", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (pnlMessage.isRememberDecision()) {
            switch (ret) {
                case 0: {
                    Main.pref.put(togglePreferenceKey, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(togglePreferenceKey, "never");
                }
            }
        } else {
            Main.pref.put(togglePreferenceKey, "ask");
        }
        return ret == 0;
    }

    private static boolean checkOfflineAccess() {
        if (Main.isOffline(OnlineResource.ALL)) {
            return false;
        }
        if (Main.isOffline(OnlineResource.JOSM_WEBSITE)) {
            for (String updateSite : Main.pref.getPluginSites()) {
                try {
                    OnlineResource.JOSM_WEBSITE.checkOfflineAccess(updateSite, Main.getJOSMWebsite());
                }
                catch (OfflineAccessException e) {
                    if (Main.isTraceEnabled()) {
                        Main.trace(e.getMessage());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private static void alertMissingRequiredPlugin(Component parent, String plugin, Set<String> missingRequiredPlugin) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", missingRequiredPlugin.size(), plugin, missingRequiredPlugin.size()));
        sb.append(Utils.joinAsHtmlUnorderedList(missingRequiredPlugin));
        sb.append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Error", new Object[0]), 0);
    }

    private static void alertJOSMUpdateRequired(Component parent, String plugin, int requiredVersion) {
        HelpAwareOptionPane.showOptionDialog(parent, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", plugin, Integer.toString(requiredVersion), Version.getInstance().getVersionString()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Component parent, Collection<PluginInformation> plugins, PluginInformation plugin) {
        int josmVersion = Version.getInstance().getVersion();
        if (plugin.localmainversion > josmVersion && josmVersion != 0) {
            PluginHandler.alertJOSMUpdateRequired(parent, plugin.name, plugin.localmainversion);
            return false;
        }
        HashSet<PluginInformation> allPlugins = new HashSet<PluginInformation>(plugins);
        for (PluginProxy proxy : pluginList) {
            allPlugins.add(proxy.getPluginInformation());
        }
        return PluginHandler.checkRequiredPluginsPreconditions(parent, allPlugins, plugin, true);
    }

    public static boolean checkRequiredPluginsPreconditions(Component parent, Collection<PluginInformation> plugins, PluginInformation plugin, boolean local) {
        String requires;
        String string = requires = local ? plugin.localrequires : plugin.requires;
        if (requires != null) {
            HashSet<String> pluginNames = new HashSet<String>();
            for (PluginInformation pi : plugins) {
                pluginNames.add(pi.name);
            }
            HashSet<String> missingPlugins = new HashSet<String>();
            List<String> requiredPlugins = local ? plugin.getLocalRequiredPlugins() : plugin.getRequiredPlugins();
            for (String requiredPlugin : requiredPlugins) {
                if (pluginNames.contains(requiredPlugin)) continue;
                missingPlugins.add(requiredPlugin);
            }
            if (!missingPlugins.isEmpty()) {
                if (parent != null) {
                    PluginHandler.alertMissingRequiredPlugin(parent, plugin.name, missingPlugins);
                }
                return false;
            }
        }
        return true;
    }

    public static synchronized DynamicURLClassLoader getPluginClassLoader() {
        if (pluginClassLoader == null) {
            pluginClassLoader = AccessController.doPrivileged(new PrivilegedAction<DynamicURLClassLoader>(){

                @Override
                public DynamicURLClassLoader run() {
                    return new DynamicURLClassLoader(new URL[0], Main.class.getClassLoader());
                }
            });
            sources.add(0, pluginClassLoader);
        }
        return pluginClassLoader;
    }

    public static void extendPluginClassLoader(Collection<PluginInformation> plugins) {
        File pluginDir = Main.pref.getPluginsDirectory();
        DynamicURLClassLoader cl = PluginHandler.getPluginClassLoader();
        for (PluginInformation info : plugins) {
            if (info.libraries == null) continue;
            for (URL libUrl : info.libraries) {
                cl.addURL(libUrl);
            }
            File pluginJar = new File(pluginDir, info.name + ".jar");
            I18n.addTexts(pluginJar);
            URL pluginJarUrl = Utils.fileToURL(pluginJar);
            cl.addURL(pluginJarUrl);
        }
    }

    public static void loadPlugin(Component parent, PluginInformation plugin, ClassLoader pluginClassLoader) {
        String msg = I18n.tr("Could not load plugin {0}. Delete from preferences?", plugin.name);
        try {
            Class<?> klass = plugin.loadClass(pluginClassLoader);
            if (klass != null) {
                Main.info(I18n.tr("loading plugin ''{0}'' (version {1})", plugin.name, plugin.localversion));
                PluginProxy pluginProxy = plugin.load(klass);
                pluginList.add(pluginProxy);
                Main.addMapFrameListener(pluginProxy, true);
            }
            msg = null;
        }
        catch (PluginException e) {
            Main.error(e);
            if (e.getCause() instanceof ClassNotFoundException) {
                msg = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?</html>", plugin.name, plugin.className);
            }
        }
        catch (Exception e) {
            Main.error(e);
        }
        if (msg != null && PluginHandler.confirmDisablePlugin(parent, msg, plugin.name)) {
            Main.pref.removeFromCollection("plugins", plugin.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Loading plugins ...", new Object[0]));
            monitor.subTask(I18n.tr("Checking plugin preconditions...", new Object[0]));
            LinkedList<PluginInformation> toLoad = new LinkedList<PluginInformation>();
            for (PluginInformation pi : plugins) {
                if (!PluginHandler.checkLoadPreconditions(parent, plugins, pi)) continue;
                toLoad.add(pi);
            }
            Collections.sort(toLoad, new Comparator<PluginInformation>(){

                @Override
                public int compare(PluginInformation o1, PluginInformation o2) {
                    if (o1.stage < o2.stage) {
                        return -1;
                    }
                    if (o1.stage == o2.stage) {
                        return 0;
                    }
                    return 1;
                }
            });
            if (toLoad.isEmpty()) {
                return;
            }
            PluginHandler.extendPluginClassLoader(toLoad);
            monitor.setTicksCount(toLoad.size());
            for (PluginInformation info : toLoad) {
                monitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", info.name));
                PluginHandler.loadPlugin(parent, info, PluginHandler.getPluginClassLoader());
                monitor.worked(1);
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    public static void loadEarlyPlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        ArrayList<PluginInformation> earlyPlugins = new ArrayList<PluginInformation>(plugins.size());
        for (PluginInformation pi : plugins) {
            if (!pi.early) continue;
            earlyPlugins.add(pi);
        }
        PluginHandler.loadPlugins(parent, earlyPlugins, monitor);
    }

    public static void loadLatePlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        ArrayList<PluginInformation> latePlugins = new ArrayList<PluginInformation>(plugins.size());
        for (PluginInformation pi : plugins) {
            if (pi.early) continue;
            latePlugins.add(pi);
        }
        PluginHandler.loadPlugins(parent, latePlugins, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask(monitor);
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<?> future = service.submit(task);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                Main.error(e);
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            catch (InterruptedException e) {
                Main.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while loading locally available plugin information");
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> ret = new HashMap<String, PluginInformation>();
            for (PluginInformation pi : task.getAvailablePlugins()) {
                ret.put(pi.name, pi);
            }
            HashMap<String, PluginInformation> hashMap = ret;
            return hashMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Component parent, Collection<String> plugins) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", plugins.size(), new Object[0]));
        sb.append(Utils.joinAsHtmlUnorderedList(plugins));
        sb.append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", plugins.size(), new Object[0]));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Component parent, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Determine plugins to load...", new Object[0]));
            HashSet<String> plugins = new HashSet<String>();
            plugins.addAll(Main.pref.getCollection("plugins", new LinkedList<String>()));
            if (System.getProperty("josm.plugins") != null) {
                plugins.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
            }
            monitor.subTask(I18n.tr("Removing deprecated plugins...", new Object[0]));
            PluginHandler.filterDeprecatedPlugins(parent, plugins);
            monitor.subTask(I18n.tr("Removing unmaintained plugins...", new Object[0]));
            PluginHandler.filterUnmaintainedPlugins(parent, plugins);
            Map<String, PluginInformation> infos = PluginHandler.loadLocallyAvailablePluginInformation(monitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                String plugin = (String)it.next();
                if (!infos.containsKey(plugin)) continue;
                ret.add(infos.get(plugin));
                it.remove();
            }
            if (!plugins.isEmpty()) {
                PluginHandler.alertMissingPluginInformation(parent, plugins);
            }
            LinkedList<PluginInformation> linkedList = ret;
            return linkedList;
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Component parent, Collection<PluginInformation> plugins) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", plugins.size(), new Object[0]));
        sb.append("<ul>");
        for (PluginInformation pi : plugins) {
            sb.append("<li>").append(pi.name).append("</li>");
        }
        sb.append("</ul>");
        sb.append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", plugins.size(), new Object[0]));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Plugin update failed", new Object[0]), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    private static Set<PluginInformation> findRequiredPluginsToDownload(Collection<PluginInformation> pluginsToUpdate, List<PluginInformation> allPlugins, Set<PluginInformation> pluginsToDownload) {
        HashSet<PluginInformation> result = new HashSet<PluginInformation>();
        for (PluginInformation pi : pluginsToUpdate) {
            for (String name : pi.getRequiredPlugins()) {
                try {
                    PluginInformation installedPlugin = PluginInformation.findPlugin(name);
                    if (installedPlugin != null) continue;
                    PluginInformation reqPlugin = null;
                    for (PluginInformation pi2 : allPlugins) {
                        if (!pi2.getName().equals(name)) continue;
                        reqPlugin = pi2;
                        break;
                    }
                    if (reqPlugin == null || pluginsToDownload.contains(reqPlugin)) continue;
                    result.add(reqPlugin);
                }
                catch (PluginException e) {
                    Main.warn(I18n.tr("Failed to find plugin {0}", name));
                    Main.error(e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Collection<PluginInformation> updatePlugins(Component parent, Collection<PluginInformation> pluginsWanted, ProgressMonitor monitor, boolean displayErrMsg) throws IllegalArgumentException {
        List<PluginInformation> plugins;
        block20: {
            plugins = null;
            pluginDownloadTask = null;
            if (monitor == null) {
                monitor = NullProgressMonitor.INSTANCE;
            }
            try {
                List<PluginInformation> list;
                monitor.beginTask("");
                ExecutorService service = Executors.newSingleThreadExecutor();
                ReadRemotePluginInformationTask task1 = new ReadRemotePluginInformationTask(monitor.createSubTaskMonitor(1, false), Main.pref.getPluginSites(), displayErrMsg);
                Future<?> future = service.submit(task1);
                List<PluginInformation> allPlugins = null;
                try {
                    future.get();
                    allPlugins = task1.getAvailablePlugins();
                    plugins = PluginHandler.buildListOfPluginsToLoad(parent, monitor.createSubTaskMonitor(1, false));
                    if (pluginsWanted != null && !pluginsWanted.isEmpty()) {
                        Iterator it = plugins.iterator();
                        while (it.hasNext()) {
                            PluginInformation pi = (PluginInformation)it.next();
                            boolean found = false;
                            for (PluginInformation piw : pluginsWanted) {
                                if (!pi.name.equals(piw.name)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            it.remove();
                        }
                    }
                }
                catch (ExecutionException e) {
                    Main.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": ExecutionException");
                    Main.error(e);
                }
                catch (InterruptedException e) {
                    Main.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": InterruptedException");
                }
                ArrayList<PluginInformation> pluginsToUpdate = new ArrayList<PluginInformation>();
                for (PluginInformation pi : plugins) {
                    if (!pi.isUpdateRequired()) continue;
                    pluginsToUpdate.add(pi);
                }
                if (pluginsToUpdate.isEmpty()) break block20;
                HashSet<PluginInformation> pluginsToDownload = new HashSet<PluginInformation>(pluginsToUpdate);
                if (allPlugins != null) {
                    Set<PluginInformation> additionalPlugins = PluginHandler.findRequiredPluginsToDownload(pluginsToUpdate, allPlugins, pluginsToDownload);
                    pluginsToDownload.addAll(additionalPlugins);
                    while (!additionalPlugins.isEmpty()) {
                        plugins.addAll(additionalPlugins);
                        additionalPlugins = PluginHandler.findRequiredPluginsToDownload(additionalPlugins, allPlugins, pluginsToDownload);
                        pluginsToDownload.addAll(additionalPlugins);
                    }
                }
                pluginDownloadTask = new PluginDownloadTask(monitor.createSubTaskMonitor(1, false), pluginsToDownload, I18n.tr("Update plugins", new Object[0]));
                future = service.submit(pluginDownloadTask);
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Main.error(e);
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    list = plugins;
                    monitor.finishTask();
                    return list;
                }
                catch (InterruptedException e) {
                    Main.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while updating plugins");
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    list = plugins;
                    monitor.finishTask();
                    return list;
                }
                PluginHandler.refreshLocalUpdatedPluginInfo(pluginDownloadTask.getDownloadedPlugins());
                if (!pluginDownloadTask.getFailedPlugins().isEmpty()) {
                    PluginHandler.alertFailedPluginUpdate(parent, pluginDownloadTask.getFailedPlugins());
                    List<PluginInformation> list2 = plugins;
                    return list2;
                }
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.finishTask();
            }
        }
        if (pluginsWanted == null) {
            Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        return plugins;
    }

    public static boolean confirmDisablePlugin(Component parent, String reason, String name) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", name), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(parent, reason, I18n.tr("Disable plugin", new Object[0]), 2, null, options, options[0], null);
        return ret == 0;
    }

    public static Object getPlugin(String name) {
        for (PluginProxy plugin : pluginList) {
            if (!plugin.getPluginInformation().name.equals(name)) continue;
            return plugin.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> downloadSelections) {
        for (PluginProxy p : pluginList) {
            p.addDownloadSelection(downloadSelections);
        }
    }

    public static Collection<PreferenceSettingFactory> getPreferenceSetting() {
        ArrayList<PreferenceSettingFactory> settings = new ArrayList<PreferenceSettingFactory>();
        for (PluginProxy plugin : pluginList) {
            settings.add(new PluginPreferenceFactory(plugin));
        }
        return settings;
    }

    public static void installDownloadedPlugins(boolean dowarn) {
        File[] files;
        File pluginDir = Main.pref.getPluginsDirectory();
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canWrite())) {
            return;
        }
        for (File updatedPlugin : files = pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar.new");
            }
        })) {
            String filePath = updatedPlugin.getPath();
            File plugin = new File(filePath.substring(0, filePath.length() - 4));
            String pluginName = updatedPlugin.getName().substring(0, updatedPlugin.getName().length() - 8);
            if (plugin.exists() && !plugin.delete() && dowarn) {
                Main.warn(I18n.tr("Failed to delete outdated plugin ''{0}''.", plugin.toString()));
                Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
                continue;
            }
            try {
                new JarFile(updatedPlugin).close();
            }
            catch (Exception e) {
                if (!dowarn) continue;
                Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. {2}", plugin.toString(), updatedPlugin.toString(), e.getLocalizedMessage()));
                continue;
            }
            if (updatedPlugin.renameTo(plugin) || !dowarn) continue;
            Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", plugin.toString(), updatedPlugin.toString()));
            Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
        }
    }

    public static boolean isValidJar(File jar) {
        if (jar != null && jar.exists() && jar.canRead()) {
            try {
                new JarFile(jar).close();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static File findUpdatedJar(String name) {
        File pluginDir = Main.pref.getPluginsDirectory();
        File downloadedPluginFile = new File(pluginDir, name + ".jar.new");
        if (!PluginHandler.isValidJar(downloadedPluginFile) && !PluginHandler.isValidJar(downloadedPluginFile = new File(pluginDir, name + ".jar"))) {
            return null;
        }
        return downloadedPluginFile;
    }

    public static void refreshLocalUpdatedPluginInfo(Collection<PluginInformation> updatedPlugins) {
        if (updatedPlugins == null) {
            return;
        }
        for (PluginInformation pi : updatedPlugins) {
            File downloadedPluginFile = PluginHandler.findUpdatedJar(pi.name);
            if (downloadedPluginFile == null) continue;
            try {
                pi.updateFromJar(new PluginInformation(downloadedPluginFile, pi.name));
            }
            catch (PluginException e) {
                Main.error(e);
            }
        }
    }

    private static int askUpdateDisableKeepPluginAfterException(PluginProxy plugin) {
        final HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugin", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the plugin ''{0}''", plugin.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", plugin.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", plugin.getPluginInformation().name), null)};
        final StringBuilder msg = new StringBuilder();
        msg.append("<html>");
        msg.append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", plugin.getPluginInformation().name));
        msg.append("<br>");
        if (plugin.getPluginInformation().author != null) {
            msg.append(I18n.tr("According to the information within the plugin, the author is {0}.", plugin.getPluginInformation().author));
            msg.append("<br>");
        }
        msg.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug.", new Object[0]));
        msg.append("</html>");
        try {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return HelpAwareOptionPane.showOptionDialog(Main.parent, msg.toString(), I18n.tr("Update plugins", new Object[0]), 3, null, options, options[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin"));
                }
            });
            GuiHelper.runInEDT(task);
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Main.warn(e);
            return -1;
        }
    }

    private static PluginProxy getPluginCausingException(Throwable ex) {
        PluginProxy err = null;
        StackTraceElement[] stack = ex.getStackTrace();
        int pos = stack.length;
        for (PluginProxy p : pluginList) {
            String baseClass = p.getPluginInformation().className;
            baseClass = baseClass.substring(0, baseClass.lastIndexOf(46));
            for (int elpos = 0; elpos < pos; ++elpos) {
                if (!stack[elpos].getClassName().startsWith(baseClass)) continue;
                pos = elpos;
                err = p;
            }
        }
        return err;
    }

    public static PluginDownloadTask updateOrdisablePluginAfterException(Throwable e) {
        PluginProxy plugin = null;
        if (e instanceof PluginException) {
            plugin = ((PluginException)e).plugin;
        }
        if (plugin == null) {
            plugin = PluginHandler.getPluginCausingException(e);
        }
        if (plugin == null) {
            return null;
        }
        HashSet<String> plugins = new HashSet<String>(Main.pref.getCollection("plugins", Collections.emptySet()));
        PluginInformation pluginInfo = plugin.getPluginInformation();
        if (!plugins.contains(pluginInfo.name)) {
            return null;
        }
        switch (PluginHandler.askUpdateDisableKeepPluginAfterException(plugin)) {
            case 0: {
                PluginHandler.updatePlugins(Main.parent, Collections.singleton(pluginInfo), null, true);
                return pluginDownloadTask;
            }
            case 1: {
                plugins.remove(plugin.getPluginInformation().name);
                Main.pref.putCollection("plugins", plugins);
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    }
                });
                return null;
            }
        }
        return null;
    }

    public static String getBugReportText() {
        StringBuilder text = new StringBuilder();
        LinkedList<String> pl = new LinkedList<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
        for (PluginProxy pp : pluginList) {
            PluginInformation pi = pp.getPluginInformation();
            pl.remove(pi.name);
            pl.add(pi.name + " (" + (pi.localversion != null && !pi.localversion.isEmpty() ? pi.localversion : "unknown") + ")");
        }
        Collections.sort(pl);
        if (!pl.isEmpty()) {
            text.append("Plugins:\n");
        }
        for (String s : pl) {
            text.append("- ").append(s).append("\n");
        }
        return text.toString();
    }

    public static JPanel getInfoPanel() {
        JPanel pluginTab = new JPanel(new GridBagLayout());
        for (PluginProxy p : pluginList) {
            final PluginInformation info = p.getPluginInformation();
            String name = info.name + (info.version != null && !info.version.isEmpty() ? " Version: " + info.version : "");
            pluginTab.add((Component)new JLabel(name), GBC.std());
            pluginTab.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            pluginTab.add((Component)new JButton(new AbstractAction(I18n.tr("Information", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent event) {
                    StringBuilder b = new StringBuilder();
                    for (Map.Entry<String, String> e : info.attr.entrySet()) {
                        b.append(e.getKey());
                        b.append(": ");
                        b.append(e.getValue());
                        b.append("\n");
                    }
                    JosmTextArea a = new JosmTextArea(10, 40);
                    a.setEditable(false);
                    a.setText(b.toString());
                    a.setCaretPosition(0);
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(a), I18n.tr("Plugin information", new Object[0]), 1);
                }
            }), GBC.eol());
            JosmTextArea description = new JosmTextArea(info.description == null ? I18n.tr("no description available", new Object[0]) : info.description);
            description.setEditable(false);
            description.setFont(new JLabel().getFont().deriveFont(2));
            description.setLineWrap(true);
            description.setWrapStyleWord(true);
            description.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            description.setBackground(UIManager.getColor("Panel.background"));
            description.setCaretPosition(0);
            pluginTab.add((Component)description, GBC.eop().fill(2));
        }
        return pluginTab;
    }

    static {
        String IN_CORE = I18n.tr("integrated into main program", new Object[0]);
        DEPRECATED_PLUGINS = Arrays.asList(new DeprecatedPlugin("mappaint", IN_CORE), new DeprecatedPlugin("unglueplugin", IN_CORE), new DeprecatedPlugin("lang-de", IN_CORE), new DeprecatedPlugin("lang-en_GB", IN_CORE), new DeprecatedPlugin("lang-fr", IN_CORE), new DeprecatedPlugin("lang-it", IN_CORE), new DeprecatedPlugin("lang-pl", IN_CORE), new DeprecatedPlugin("lang-ro", IN_CORE), new DeprecatedPlugin("lang-ru", IN_CORE), new DeprecatedPlugin("ewmsplugin", IN_CORE), new DeprecatedPlugin("ywms", IN_CORE), new DeprecatedPlugin("tways-0.2", IN_CORE), new DeprecatedPlugin("geotagged", IN_CORE), new DeprecatedPlugin("landsat", I18n.tr("replaced by new {0} plugin", "lakewalker")), new DeprecatedPlugin("namefinder", IN_CORE), new DeprecatedPlugin("waypoints", IN_CORE), new DeprecatedPlugin("slippy_map_chooser", IN_CORE), new DeprecatedPlugin("tcx-support", I18n.tr("replaced by new {0} plugin", "dataimport")), new DeprecatedPlugin("usertools", IN_CORE), new DeprecatedPlugin("AgPifoJ", IN_CORE), new DeprecatedPlugin("utilsplugin", IN_CORE), new DeprecatedPlugin("ghost", IN_CORE), new DeprecatedPlugin("validator", IN_CORE), new DeprecatedPlugin("multipoly", IN_CORE), new DeprecatedPlugin("multipoly-convert", IN_CORE), new DeprecatedPlugin("remotecontrol", IN_CORE), new DeprecatedPlugin("imagery", IN_CORE), new DeprecatedPlugin("slippymap", IN_CORE), new DeprecatedPlugin("wmsplugin", IN_CORE), new DeprecatedPlugin("ParallelWay", IN_CORE), new DeprecatedPlugin("dumbutils", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("ImproveWayAccuracy", IN_CORE), new DeprecatedPlugin("Curves", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("epsg31287", I18n.tr("replaced by new {0} plugin", "proj4j")), new DeprecatedPlugin("licensechange", I18n.tr("no longer required", new Object[0])), new DeprecatedPlugin("restart", IN_CORE), new DeprecatedPlugin("wayselector", IN_CORE), new DeprecatedPlugin("openstreetbugs", I18n.tr("replaced by new {0} plugin", "notes")), new DeprecatedPlugin("nearclick", I18n.tr("no longer required", new Object[0])), new DeprecatedPlugin("notes", IN_CORE));
        UNMAINTAINED_PLUGINS = new String[]{"gpsbabelgui", "Intersect_way"};
        pluginList = new LinkedList<PluginProxy>();
        sources = new LinkedList<ClassLoader>();
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException ex) {
            sources.add(ImageProvider.class.getClassLoader());
        }
        pluginDownloadTask = null;
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private JCheckBox cbDontShowAgain;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.lblMessage = new JMultilineLabel("");
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)", new Object[0]));
            this.add((Component)this.cbDontShowAgain, gc);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public UpdatePluginsMessagePanel() {
            this.build();
        }

        public void setMessage(String message) {
            this.lblMessage.setText(message);
        }

        public void initDontShowAgain(String preferencesKey) {
            String policy = Main.pref.get(preferencesKey, "ask");
            this.cbDontShowAgain.setSelected(!"ask".equals(policy = policy.trim().toLowerCase()));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }

    public static class DynamicURLClassLoader
    extends URLClassLoader {
        public DynamicURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }

    public static class DeprecatedPlugin
    implements Comparable<DeprecatedPlugin> {
        public final String name;
        public final String reason;
        private final Runnable migration;

        public DeprecatedPlugin(String name) {
            this(name, null, null);
        }

        public DeprecatedPlugin(String name, String reason) {
            this(name, reason, null);
        }

        public DeprecatedPlugin(String name, String reason, Runnable migration) {
            this.name = name;
            this.reason = reason;
            this.migration = migration;
        }

        public void migrate() {
            if (this.migration != null) {
                this.migration.run();
            }
        }

        @Override
        public int compareTo(DeprecatedPlugin o) {
            return this.name.compareTo(o.name);
        }
    }
}

