/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.PluginDownloadException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class PluginDownloadTask
extends PleaseWaitRunnable {
    public static final String PLUGIN_MIME_TYPES = "application/java-archive, application/zip; q=0.9, application/octet-stream; q=0.5";
    private final Collection<PluginInformation> toUpdate = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> downloaded = new LinkedList<PluginInformation>();
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public PluginDownloadTask(Component parent, Collection<PluginInformation> toUpdate, String title) throws IllegalArgumentException {
        super(parent, title == null ? "" : title, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public PluginDownloadTask(ProgressMonitor monitor, Collection<PluginInformation> toUpdate, String title) {
        super(title, monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public void setPluginsToDownload(Collection<PluginInformation> toUpdate) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(toUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        PluginDownloadTask pluginDownloadTask = this;
        synchronized (pluginDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(PluginInformation pi, File file) throws PluginDownloadException {
        if (pi.mainversion > Version.getInstance().getVersion()) {
            ExtendedDialog dialog = new ExtendedDialog(this.progressMonitor.getWindowParent(), I18n.tr("Skip download", new Object[0]), new String[]{I18n.tr("Download Plugin", new Object[0]), I18n.tr("Skip Download", new Object[0])});
            dialog.setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pi.mainversion, pi.name));
            dialog.setButtonIcons(new String[]{"download", "cancel"});
            dialog.showDialog();
            int answer = dialog.getValue();
            if (answer != 1) {
                throw new PluginDownloadException(I18n.tr("Download skipped", new Object[0]));
            }
        }
        try {
            if (pi.downloadlink == null) {
                String msg = I18n.tr("Cannot download plugin ''{0}''. Its download link is not known. Skipping download.", pi.name);
                Main.warn(msg);
                throw new PluginDownloadException(msg);
            }
            URL url = new URL(pi.downloadlink);
            PluginDownloadTask answer = this;
            synchronized (answer) {
                this.downloadConnection = CachedFile.connectFollowingRedirect(url, PLUGIN_MIME_TYPES, null);
            }
            try (InputStream in = this.downloadConnection.getInputStream();
                 FileOutputStream out = new FileOutputStream(file);){
                byte[] buffer = new byte[8192];
                int read = in.read(buffer);
                while (read != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                    read = in.read(buffer);
                }
            }
        }
        catch (MalformedURLException e) {
            String msg = I18n.tr("Cannot download plugin ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", pi.name, pi.downloadlink);
            Main.warn(msg);
            throw new PluginDownloadException(msg);
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            throw new PluginDownloadException(e);
        }
        finally {
            PluginDownloadTask pluginDownloadTask = this;
            synchronized (pluginDownloadTask) {
                this.downloadConnection = null;
            }
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        File pluginDir = Main.pref.getPluginsDirectory();
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            new PluginDownloadException(I18n.tr("Failed to create plugin directory ''{0}''", pluginDir.toString()));
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (PluginInformation d : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading Plugin {0}...", d.name));
            this.progressMonitor.worked(1);
            File pluginFile = new File(pluginDir, d.name + ".jar.new");
            try {
                this.download(d, pluginFile);
            }
            catch (PluginDownloadException e) {
                Main.error(e);
                this.failed.add(d);
                continue;
            }
            this.downloaded.add(d);
        }
        PluginHandler.installDownloadedPlugins(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<PluginInformation> getFailedPlugins() {
        return this.failed;
    }

    public Collection<PluginInformation> getDownloadedPlugins() {
        return this.downloaded;
    }
}

