/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.Utils;

public abstract class Plugin
implements MapFrameListener {
    private PluginInformation info = null;

    public Plugin(PluginInformation info) {
        this.info = info;
    }

    public PluginInformation getPluginInformation() {
        return this.info;
    }

    public void setPluginInformation(PluginInformation info) {
        this.info = info;
    }

    public String getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), this.info.name).getPath();
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return null;
    }

    public void addDownloadSelection(List<DownloadSelection> list) {
    }

    public void copy(String from, String to) throws FileNotFoundException, IOException {
        String pluginDirName = this.getPluginDir();
        File pluginDir = new File(pluginDirName);
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(new File(pluginDirName, to));
             InputStream in = this.getClass().getResourceAsStream(from);){
            if (in == null) {
                throw new IOException("Resource not found: " + from);
            }
            byte[] buffer = new byte[8192];
            int len = in.read(buffer);
            while (len > 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
    }

    public ClassLoader getPluginResourceClassLoader() {
        File pluginDir = Main.pref.getPluginsDirectory();
        File pluginJar = new File(pluginDir, this.info.name + ".jar");
        final URL pluginJarUrl = Utils.fileToURL(pluginJar);
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(new URL[]{pluginJarUrl}, Main.class.getClassLoader());
            }
        });
    }
}

