/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.GeoImageSessionImporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionImporter;
import org.openstreetmap.josm.io.session.ImagerySessionImporter;
import org.openstreetmap.josm.io.session.MarkerSessionImporter;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static Map<String, Class<? extends SessionLayerImporter>> sessionLayerImporters = new HashMap<String, Class<? extends SessionLayerImporter>>();
    private URI sessionFileURI;
    private boolean zip;
    private ZipFile zipFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private int active = -1;
    private List<Runnable> postLoadTasks = new ArrayList<Runnable>();
    private ViewportData viewport;

    public static void registerSessionLayerImporter(String layerType, Class<? extends SessionLayerImporter> importer) {
        sessionLayerImporters.put(layerType, importer);
    }

    public static SessionLayerImporter getSessionLayerImporter(String layerType) {
        Class<? extends SessionLayerImporter> importerClass = sessionLayerImporters.get(layerType);
        if (importerClass == null) {
            return null;
        }
        SessionLayerImporter importer = null;
        try {
            importer = importerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return importer;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getActive() {
        return this.active >= 0 && this.active < this.layers.size() ? this.layers.get(this.layers.size() - 1 - this.active) : null;
    }

    public List<Runnable> getPostLoadTasks() {
        return this.postLoadTasks;
    }

    public ViewportData getViewport() {
        return this.viewport;
    }

    private static void error(String msg) throws IllegalDataException {
        throw new IllegalDataException(msg);
    }

    private void parseJos(Document doc, ProgressMonitor progressMonitor) throws IllegalDataException {
        Element layersEl;
        Element viewportEl;
        String version;
        Element root = doc.getDocumentElement();
        if (!"josm-session".equals(root.getTagName())) {
            SessionReader.error(I18n.tr("Unexpected root element ''{0}'' in session file", root.getTagName()));
        }
        if (!"0.1".equals(version = root.getAttribute("version"))) {
            SessionReader.error(I18n.tr("Version ''{0}'' of session file is not supported. Expected: 0.1", version));
        }
        if ((viewportEl = SessionReader.getElementByTagName(root, "viewport")) != null) {
            Element scaleEl;
            EastNorth center = null;
            Element centerEl = SessionReader.getElementByTagName(viewportEl, "center");
            if (centerEl != null && centerEl.hasAttribute("lat") && centerEl.hasAttribute("lon")) {
                try {
                    LatLon centerLL = new LatLon(Double.parseDouble(centerEl.getAttribute("lat")), Double.parseDouble(centerEl.getAttribute("lon")));
                    center = Projections.project(centerLL);
                }
                catch (NumberFormatException ex) {
                    Main.warn(ex);
                }
            }
            if (center != null && (scaleEl = SessionReader.getElementByTagName(viewportEl, "scale")) != null && scaleEl.hasAttribute("meter-per-pixel")) {
                try {
                    double meterPerPixel = Double.parseDouble(scaleEl.getAttribute("meter-per-pixel"));
                    Projection proj = Main.getProjection();
                    double dist = 0.01 * proj.getDefaultZoomInPPD();
                    LatLon ll1 = proj.eastNorth2latlon(new EastNorth(center.east() - dist, center.north()));
                    LatLon ll2 = proj.eastNorth2latlon(new EastNorth(center.east() + dist, center.north()));
                    double d = ll1.greatCircleDistance(ll2) / dist / 2.0;
                    double scale = meterPerPixel / d;
                    this.viewport = new ViewportData(center, scale);
                }
                catch (NumberFormatException ex) {
                    Main.warn(ex);
                }
            }
        }
        if ((layersEl = SessionReader.getElementByTagName(root, "layers")) == null) {
            return;
        }
        String activeAtt = layersEl.getAttribute("active");
        try {
            this.active = activeAtt != null && !activeAtt.isEmpty() ? Integer.parseInt(activeAtt) - 1 : -1;
        }
        catch (NumberFormatException e) {
            Main.warn("Unsupported value for 'active' layer attribute. Ignoring it. Error was: " + e.getMessage());
            this.active = -1;
        }
        MultiMap<Integer, Integer> deps = new MultiMap<Integer, Integer>();
        HashMap<Integer, Element> elems = new HashMap<Integer, Element>();
        NodeList nodes = layersEl.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !"layer".equals((e = (Element)node).getTagName())) continue;
            if (!e.hasAttribute("index")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''index'' for element ''layer''", new Object[0]));
            }
            Integer idx = null;
            try {
                idx = Integer.parseInt(e.getAttribute("index"));
            }
            catch (NumberFormatException ex) {
                Main.warn(ex);
            }
            if (idx == null) {
                SessionReader.error(I18n.tr("unexpected format of attribute ''index'' for element ''layer''", new Object[0]));
            }
            if (elems.containsKey(idx)) {
                SessionReader.error(I18n.tr("attribute ''index'' ({0}) for element ''layer'' must be unique", Integer.toString(idx)));
            }
            elems.put(idx, e);
            deps.putVoid(idx);
            String depStr = e.getAttribute("depends");
            if (depStr == null || depStr.isEmpty()) continue;
            for (String sd : depStr.split(",")) {
                Integer d = null;
                try {
                    d = Integer.parseInt(sd);
                }
                catch (NumberFormatException ex) {
                    Main.warn(ex);
                }
                if (d == null) continue;
                deps.put(idx, d);
            }
        }
        List sorted = Utils.topologicalSort(deps);
        TreeMap layersMap = new TreeMap(Collections.reverseOrder());
        HashMap<Integer, SessionLayerImporter> importers = new HashMap<Integer, SessionLayerImporter>();
        HashMap<Integer, String> names = new HashMap<Integer, String>();
        progressMonitor.setTicksCount(sorted.size());
        Iterator<Object> i$ = sorted.iterator();
        block16: while (i$.hasNext()) {
            String type;
            SessionLayerImporter imp;
            int n = (Integer)i$.next();
            Element e = (Element)elems.get(n);
            if (e == null) {
                SessionReader.error(I18n.tr("missing layer with index {0}", n));
            }
            if (!e.hasAttribute("name")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''name'' for element ''layer''", new Object[0]));
            }
            String name = e.getAttribute("name");
            names.put(n, name);
            if (!e.hasAttribute("type")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''type'' for element ''layer''", new Object[0]));
            }
            if ((imp = SessionReader.getSessionLayerImporter(type = e.getAttribute("type"))) == null && !GraphicsEnvironment.isHeadless()) {
                CancelOrContinueDialog dialog = new CancelOrContinueDialog();
                dialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer of type ''{0}'' because no suitable importer was found.", type), 2, progressMonitor);
                if (!dialog.isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            if (imp != null) {
                CancelOrContinueDialog dialog;
                importers.put(n, imp);
                ArrayList<LayerDependency> depsImp = new ArrayList<LayerDependency>();
                Iterator i$2 = deps.get(n).iterator();
                while (i$2.hasNext()) {
                    int d = (Integer)i$2.next();
                    SessionLayerImporter dImp = (SessionLayerImporter)importers.get(d);
                    if (dImp == null) {
                        dialog = new CancelOrContinueDialog();
                        dialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer {0} because it depends on layer {1} which has been skipped.", n, d), 2, progressMonitor);
                        if (!dialog.isCancel()) continue block16;
                        progressMonitor.cancel();
                        return;
                    }
                    depsImp.add(new LayerDependency(d, (Layer)layersMap.get(d), dImp));
                }
                ImportSupport support = new ImportSupport(name, n, depsImp);
                Layer layer = null;
                Exception exception = null;
                try {
                    layer = imp.load(e, support, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (IOException | IllegalDataException ex) {
                    exception = ex;
                }
                if (exception != null) {
                    Main.error(exception);
                    if (!GraphicsEnvironment.isHeadless()) {
                        dialog = new CancelOrContinueDialog();
                        dialog.show(I18n.tr("Error loading layer", new Object[0]), I18n.tr("<html>Could not load layer {0} ''{1}''.<br>Error is:<br>{2}</html>", n, name, exception.getMessage()), 0, progressMonitor);
                        if (!dialog.isCancel()) continue;
                        progressMonitor.cancel();
                        return;
                    }
                }
                if (layer == null) {
                    throw new RuntimeException();
                }
                layersMap.put(n, layer);
            }
            progressMonitor.worked(1);
        }
        this.layers = new ArrayList<Layer>();
        i$ = layersMap.keySet().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            Layer layer = (Layer)layersMap.get(n);
            if (layer == null) continue;
            Element el = (Element)elems.get(n);
            if (el.hasAttribute("visible")) {
                layer.setVisible(Boolean.parseBoolean(el.getAttribute("visible")));
            }
            if (!el.hasAttribute("opacity")) continue;
            try {
                double opacity = Double.parseDouble(el.getAttribute("opacity"));
                layer.setOpacity(opacity);
            }
            catch (NumberFormatException ex) {
                Main.warn(ex);
            }
        }
        for (Map.Entry entry : layersMap.entrySet()) {
            Layer l = (Layer)entry.getValue();
            if (l == null) continue;
            l.setName((String)names.get(entry.getKey()));
            this.layers.add(l);
        }
    }

    public void loadSession(File sessionFile, boolean zip, ProgressMonitor progressMonitor) throws IllegalDataException, IOException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try (InputStream josIS = this.createInputStream(sessionFile, zip);){
            this.loadSession(josIS, sessionFile.toURI(), zip, progressMonitor);
        }
    }

    private InputStream createInputStream(File sessionFile, boolean zip) throws IOException, IllegalDataException {
        if (zip) {
            try {
                this.zipFile = new ZipFile(sessionFile, StandardCharsets.UTF_8);
                return SessionReader.getZipInputStream(this.zipFile);
            }
            catch (ZipException ze) {
                throw new IOException(ze);
            }
        }
        try {
            return new FileInputStream(sessionFile);
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    private static InputStream getZipInputStream(ZipFile zipFile) throws ZipException, IOException, IllegalDataException {
        ZipEntry josEntry = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().toLowerCase().endsWith(".jos")) continue;
            josEntry = entry;
            break;
        }
        if (josEntry == null) {
            SessionReader.error(I18n.tr("expected .jos file inside .joz archive", new Object[0]));
        }
        return zipFile.getInputStream(josEntry);
    }

    private void loadSession(InputStream josIS, URI sessionFileURI, boolean zip, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.sessionFileURI = sessionFileURI;
        this.zip = zip;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(false);
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(josIS);
            this.parseJos(document, progressMonitor);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static Element getElementByTagName(Element root, String name) {
        NodeList els = root.getElementsByTagName(name);
        if (els.getLength() == 0) {
            return null;
        }
        return (Element)els.item(0);
    }

    static {
        SessionReader.registerSessionLayerImporter("osm-data", OsmDataSessionImporter.class);
        SessionReader.registerSessionLayerImporter("imagery", ImagerySessionImporter.class);
        SessionReader.registerSessionLayerImporter("tracks", GpxTracksSessionImporter.class);
        SessionReader.registerSessionLayerImporter("geoimage", GeoImageSessionImporter.class);
        SessionReader.registerSessionLayerImporter("markers", MarkerSessionImporter.class);
    }

    private static class CancelOrContinueDialog {
        private boolean cancel;

        private CancelOrContinueDialog() {
        }

        public void show(final String title, final String message, final int icon, ProgressMonitor progressMonitor) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedDialog dlg = new ExtendedDialog(Main.parent, title, new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Skip layer and continue", new Object[0])});
                        dlg.setButtonIcons(new String[]{"cancel", "dialogs/next"});
                        dlg.setIcon(icon);
                        dlg.setContent(message);
                        dlg.showDialog();
                        CancelOrContinueDialog.this.cancel = dlg.getValue() != 2;
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    public static class LayerDependency {
        private Integer index;
        private Layer layer;
        private SessionLayerImporter importer;

        public LayerDependency(Integer index, Layer layer, SessionLayerImporter importer) {
            this.index = index;
            this.layer = layer;
            this.importer = importer;
        }

        public SessionLayerImporter getImporter() {
            return this.importer;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Layer getLayer() {
            return this.layer;
        }
    }

    public class ImportSupport {
        private String layerName;
        private int layerIndex;
        private List<LayerDependency> layerDependencies;
        private String inZipPath;

        public ImportSupport(String layerName, int layerIndex, List<LayerDependency> layerDependencies) {
            this.layerName = layerName;
            this.layerIndex = layerIndex;
            this.layerDependencies = layerDependencies;
        }

        public void addPostLayersTask(Runnable task) {
            SessionReader.this.postLoadTasks.add(task);
        }

        public InputStream getInputStream(String uriStr) throws IOException {
            ZipEntry entry;
            File file = this.getFile(uriStr);
            if (file != null) {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getPath()));
                }
            }
            if (this.inZipPath != null && (entry = SessionReader.this.zipFile.getEntry(this.inZipPath)) != null) {
                return SessionReader.this.zipFile.getInputStream(entry);
            }
            throw new IOException(I18n.tr("Unable to locate file  ''{0}''.", uriStr));
        }

        public File getFile(String uriStr) throws IOException {
            this.inZipPath = null;
            try {
                URI uri = new URI(uriStr);
                if ("file".equals(uri.getScheme())) {
                    return new File(uri);
                }
                if (uri.getScheme() == null) {
                    File file = new File(uriStr);
                    if (file.isAbsolute()) {
                        return file;
                    }
                    if (this.isZip()) {
                        if (uri.getPath().startsWith("../")) {
                            String relPath = uri.getPath().substring(3);
                            return new File(SessionReader.this.sessionFileURI.resolve(relPath));
                        }
                        this.inZipPath = uriStr;
                        return null;
                    }
                    return new File(SessionReader.this.sessionFileURI.resolve(uri));
                }
                throw new IOException(I18n.tr("Unsupported scheme ''{0}'' in URI ''{1}''.", uri.getScheme(), uriStr));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public boolean isZip() {
            return SessionReader.this.zip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public List<LayerDependency> getLayerDependencies() {
            return this.layerDependencies;
        }
    }
}

