/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class MarkerSessionExporter
implements SessionLayerExporter {
    private MarkerLayer layer;
    private JCheckBox export;

    public MarkerSessionExporter(MarkerLayer layer) {
        this.layer = layer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        GpxLayer gpxLayer = this.layer.fromLayer;
        if (gpxLayer != null && Main.map.mapView.hasLayer(gpxLayer)) {
            return Collections.singleton(gpxLayer);
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        lbl.setToolTipText(this.layer.getToolTipText());
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        return p;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return true;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerEl = support.createElement("layer");
        layerEl.setAttribute("type", "markers");
        layerEl.setAttribute("version", "0.1");
        Element file = support.createElement("file");
        layerEl.appendChild(file);
        String zipPath = "layers/" + String.format("%02d", support.getLayerIndex()) + "/data.gpx";
        file.appendChild(support.createTextNode(zipPath));
        this.addDataFile(support.getOutputStreamZip(zipPath));
        return layerEl;
    }

    protected void addDataFile(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        MarkerWriter w = new MarkerWriter(new PrintWriter(writer));
        w.write(this.layer);
        w.flush();
    }

    public static class MarkerWriter
    extends GpxWriter {
        public MarkerWriter(PrintWriter out) {
            super(out);
        }

        public void write(MarkerLayer layer) {
            GpxData data = new GpxData();
            data.put("meta.desc", "exported JOSM marker layer");
            for (Marker m : layer.data) {
                data.waypoints.add(m.convertToWayPoint());
            }
            super.write(data);
        }
    }
}

