/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.util.HashMap;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImagerySessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", version));
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element e = (Element)node;
            attributes.put(e.getTagName(), e.getTextContent());
        }
        ImageryInfo.ImageryPreferenceEntry prefEntry = Preferences.deserializeStruct(attributes, ImageryInfo.ImageryPreferenceEntry.class);
        ImageryInfo i = new ImageryInfo(prefEntry);
        ImageryLayer layer = ImageryLayer.create(i);
        if (layer instanceof WMSLayer) {
            String autoResolution;
            WMSLayer wms = (WMSLayer)layer;
            String autoDownload = (String)attributes.get("automatic-downloading");
            if (autoDownload != null) {
                wms.setAutoDownload(Boolean.parseBoolean(autoDownload));
            }
            if ((autoResolution = (String)attributes.get("automatically-change-resolution")) != null) {
                wms.setAutoResolution(Boolean.parseBoolean(autoResolution));
            }
        }
        return layer;
    }
}

