/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class ImagerySessionExporter
implements SessionLayerExporter {
    private ImageryLayer layer;
    private JCheckBox export;

    public ImagerySessionExporter(ImageryLayer layer) {
        this.layer = layer;
    }

    public ImagerySessionExporter(TMSLayer layer) {
        this((ImageryLayer)layer);
    }

    public ImagerySessionExporter(WMSLayer layer) {
        this((ImageryLayer)layer);
    }

    @Override
    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        lbl.setToolTipText(this.layer.getToolTipText());
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        return p;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return false;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerElem = support.createElement("layer");
        layerElem.setAttribute("type", "imagery");
        layerElem.setAttribute("version", "0.1");
        ImageryInfo.ImageryPreferenceEntry e = new ImageryInfo.ImageryPreferenceEntry(this.layer.getInfo());
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(Preferences.serializeStruct(e, ImageryInfo.ImageryPreferenceEntry.class));
        if (this.layer instanceof WMSLayer) {
            WMSLayer wms = (WMSLayer)this.layer;
            data.put("automatic-downloading", Boolean.toString(wms.hasAutoDownload()));
            data.put("automatically-change-resolution", Boolean.toString(wms.isAutoResolution()));
        }
        for (Map.Entry entry : data.entrySet()) {
            Element attrElem = support.createElement((String)entry.getKey());
            layerElem.appendChild(attrElem);
            attrElem.appendChild(support.createTextNode((String)entry.getValue()));
        }
        return layerElem;
    }
}

