/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class GpxTracksSessionExporter
implements SessionLayerExporter {
    private GpxLayer layer;
    private JRadioButton link;
    private JRadioButton include;
    private JCheckBox export;

    public GpxTracksSessionExporter(GpxLayer layer) {
        this.layer = layer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        final JPanel p = new JPanel(new GridBagLayout());
        JPanel topRow = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        lbl.setToolTipText(this.layer.getToolTipText());
        JLabel lblData = new JLabel(I18n.tr("Data:", new Object[0]));
        this.link = new JRadioButton(I18n.tr("local file", new Object[0]));
        this.link.putClientProperty("actionname", "link");
        this.link.setToolTipText(I18n.tr("Link to a GPX file on your local disk.", new Object[0]));
        this.include = new JRadioButton(I18n.tr("include", new Object[0]));
        this.include.setToolTipText(I18n.tr("Include GPX data in the .joz session file.", new Object[0]));
        this.include.putClientProperty("actionname", "include");
        ButtonGroup group = new ButtonGroup();
        group.add(this.link);
        group.add(this.include);
        JPanel cardLink = new JPanel(new GridBagLayout());
        final File file = this.layer.getAssociatedFile();
        if (file != null) {
            JosmTextField tf = new JosmTextField();
            tf.setText(file.getPath());
            tf.setEditable(false);
            cardLink.add((Component)tf, GBC.std());
        } else {
            cardLink.add((Component)new JLabel(I18n.tr("No file association", new Object[0])), GBC.eol());
        }
        JPanel cardInclude = new JPanel(new GridBagLayout());
        JLabel lblIncl = new JLabel(I18n.tr("GPX data will be included in the session file.", new Object[0]));
        lblIncl.setFont(lblIncl.getFont().deriveFont(0));
        cardInclude.add((Component)lblIncl, GBC.eol().fill(2));
        final CardLayout cl = new CardLayout();
        final JPanel cards = new JPanel(cl);
        cards.add((Component)cardLink, "link");
        cards.add((Component)cardInclude, "include");
        if (file != null) {
            this.link.setSelected(true);
        } else {
            this.link.setEnabled(false);
            this.link.setToolTipText(I18n.tr("No file association", new Object[0]));
            this.include.setSelected(true);
            cl.show(cards, "include");
        }
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cl.show(cards, "link");
            }
        });
        this.include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cl.show(cards, "include");
            }
        });
        topRow.add((Component)this.export, GBC.std());
        topRow.add((Component)lbl, GBC.std());
        topRow.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add((Component)topRow, GBC.eol().fill(2));
        p.add((Component)lblData, GBC.std().insets(10, 0, 0, 0));
        p.add((Component)this.link, GBC.std());
        p.add((Component)this.include, GBC.eol());
        p.add((Component)cards, GBC.eol().insets(15, 0, 3, 3));
        this.export.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    GuiHelper.setEnabledRec(p, false);
                    GpxTracksSessionExporter.this.export.setEnabled(true);
                } else {
                    GuiHelper.setEnabledRec(p, true);
                    GpxTracksSessionExporter.this.link.setEnabled(file != null);
                }
            }
        });
        return p;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return this.include.isSelected();
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerEl = support.createElement("layer");
        layerEl.setAttribute("type", "tracks");
        layerEl.setAttribute("version", "0.1");
        Element file = support.createElement("file");
        layerEl.appendChild(file);
        if (this.requiresZip()) {
            String zipPath = "layers/" + String.format("%02d", support.getLayerIndex()) + "/data.gpx";
            file.appendChild(support.createTextNode(zipPath));
            this.addDataFile(support.getOutputStreamZip(zipPath));
        } else {
            URI uri = this.layer.getAssociatedFile().toURI();
            URL url = null;
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IOException(e);
            }
            file.appendChild(support.createTextNode(url.toString()));
        }
        return layerEl;
    }

    protected void addDataFile(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        GpxWriter w = new GpxWriter(new PrintWriter(writer));
        w.write(this.layer.data);
        w.flush();
    }
}

