/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class GeoImageSessionExporter
implements SessionLayerExporter {
    private GeoImageLayer layer;
    private JCheckBox export;

    public GeoImageSessionExporter(GeoImageLayer layer) {
        this.layer = layer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        if (this.layer.getGpxLayer() != null) {
            return Collections.singleton(this.layer.getGpxLayer());
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        lbl.setToolTipText(this.layer.getToolTipText());
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        return p;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return false;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerElem = support.createElement("layer");
        layerElem.setAttribute("type", "geoimage");
        layerElem.setAttribute("version", "0.1");
        this.addAttr("show-thumbnails", Boolean.toString(this.layer.isUseThumbs()), layerElem, support);
        for (ImageEntry entry : this.layer.getImages()) {
            Element posElem;
            Element imgElem = support.createElement("geoimage");
            if (entry.getFile() == null) {
                Main.warn("No file attribute for image - skipping entry");
                break;
            }
            this.addAttr("file", entry.getFile().getPath(), imgElem, support);
            this.addAttr("thumbnail", Boolean.toString(entry.hasThumbnail()), imgElem, support);
            if (entry.getPos() != null) {
                posElem = support.createElement("position");
                posElem.setAttribute("lat", Double.toString(entry.getPos().lat()));
                posElem.setAttribute("lon", Double.toString(entry.getPos().lon()));
                imgElem.appendChild(posElem);
            }
            if (entry.getSpeed() != null) {
                this.addAttr("speed", entry.getSpeed().toString(), imgElem, support);
            }
            if (entry.getElevation() != null) {
                this.addAttr("elevation", entry.getElevation().toString(), imgElem, support);
            }
            if (entry.hasGpsTime()) {
                this.addAttr("gps-time", Long.toString(entry.getGpsTime().getTime()), imgElem, support);
            }
            if (entry.getExifOrientation() != null) {
                this.addAttr("exif-orientation", Integer.toString(entry.getExifOrientation()), imgElem, support);
            }
            if (entry.hasExifTime()) {
                this.addAttr("exif-time", Long.toString(entry.getExifTime().getTime()), imgElem, support);
            }
            if (entry.hasExifGpsTime()) {
                this.addAttr("exif-gps-time", Long.toString(entry.getExifGpsTime().getTime()), imgElem, support);
            }
            if (entry.getExifCoor() != null) {
                posElem = support.createElement("exif-coordinates");
                posElem.setAttribute("lat", Double.toString(entry.getExifCoor().lat()));
                posElem.setAttribute("lon", Double.toString(entry.getExifCoor().lon()));
                imgElem.appendChild(posElem);
            }
            if (entry.getExifImgDir() != null) {
                this.addAttr("exif-image-direction", entry.getExifImgDir().toString(), imgElem, support);
            }
            if (entry.hasNewGpsData()) {
                this.addAttr("is-new-gps-data", Boolean.toString(entry.hasNewGpsData()), imgElem, support);
            }
            layerElem.appendChild(imgElem);
        }
        return layerElem;
    }

    private void addAttr(String name, String value, Element element, SessionWriter.ExportSupport support) {
        Element attrElem = support.createElement(name);
        attrElem.appendChild(support.createTextNode(value));
        element.appendChild(attrElem);
    }
}

