/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class RequestHandler {
    public static final String globalConfirmationKey = "remotecontrol.always-confirm";
    public static final boolean globalConfirmationDefault = false;
    public static final String loadInNewLayerKey = "remotecontrol.new-layer";
    public static final boolean loadInNewLayerDefault = false;
    protected Map<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;
    protected String sender;

    public final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkMandatoryParams();
        this.validateRequest();
        this.checkPermission();
        this.handleRequest();
    }

    protected abstract void validateRequest() throws RequestHandlerBadRequestException;

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public abstract PermissionPrefWithDefault getPermissionPref();

    public abstract String[] getMandatoryParams();

    public String[] getOptionalParams() {
        return null;
    }

    public String getUsage() {
        return null;
    }

    public String[] getUsageExamples() {
        return null;
    }

    public String[] getUsageExamples(String cmd) {
        return this.getUsageExamples();
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPrefWithDefault permissionPref = this.getPermissionPref();
        if (permissionPref != null && permissionPref.pref != null && !Main.pref.getBoolean(permissionPref.pref, permissionPref.defaultVal)) {
            String err = MessageFormat.format("RemoteControl: ''{0}'' forbidden by preferences", this.myCommand);
            Main.info(err);
            throw new RequestHandlerForbiddenException(err);
        }
        if (Main.pref.getBoolean(globalConfirmationKey, false)) {
            Integer maxWidth = (int)Math.max(200.0, (double)Main.parent.getWidth() * 0.6);
            String message = "<html><div>" + this.getPermissionMessage() + "<br/>" + I18n.tr("Do you want to allow this?", new Object[0]) + "</div></html>";
            JLabel label = new JLabel(message);
            if (label.getPreferredSize().width > maxWidth) {
                label.setText(message.replaceFirst("<div>", "<div style=\"width:" + maxWidth + "px;\">"));
            }
            if (JOptionPane.showConfirmDialog(Main.parent, label, I18n.tr("Confirm Remote Control action", new Object[0]), 0) != 0) {
                String err = MessageFormat.format("RemoteControl: ''{0}'' forbidden by user''s choice", this.myCommand);
                throw new RequestHandlerForbiddenException(err);
            }
        }
    }

    public void setUrl(String url) {
        this.request = url;
        this.parseArgs();
    }

    protected void parseArgs() {
        try {
            String req = URLDecoder.decode(this.request, "UTF-8");
            HashMap<String, String> args = new HashMap<String, String>();
            if (req.indexOf(63) != -1) {
                String[] params;
                String query = req.substring(req.indexOf(63) + 1);
                if (query.indexOf(35) != -1) {
                    query = query.substring(0, query.indexOf(35));
                }
                for (String param : params = query.split("&", -1)) {
                    int eq = param.indexOf(61);
                    if (eq == -1) continue;
                    args.put(param.substring(0, eq), param.substring(eq + 1));
                }
            }
            this.args = args;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] mandatory = this.getMandatoryParams();
        String[] optional = this.getOptionalParams();
        LinkedList<String> missingKeys = new LinkedList<String>();
        boolean error = false;
        if (mandatory != null) {
            for (String key : mandatory) {
                String value = this.args.get(key);
                if (value != null && value.length() != 0) continue;
                error = true;
                Main.warn("'" + this.myCommand + "' remote control request must have '" + key + "' parameter");
                missingKeys.add(key);
            }
        }
        HashSet knownParams = new HashSet();
        if (mandatory != null) {
            Collections.addAll(knownParams, mandatory);
        }
        if (optional != null) {
            Collections.addAll(knownParams, optional);
        }
        for (String par : this.args.keySet()) {
            if (knownParams.contains(par)) continue;
            Main.warn("Unknown remote control parameter {0}, skipping it", par);
        }
        if (error) {
            throw new RequestHandlerBadRequestException("The following keys are mandatory, but have not been provided: " + Utils.join(", ", missingKeys));
        }
    }

    public void setCommand(String command) {
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        this.myCommand = command;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected boolean isLoadInNewLayer() {
        return this.args.get("new_layer") != null && !this.args.get("new_layer").isEmpty() ? Boolean.parseBoolean(this.args.get("new_layer")) : Main.pref.getBoolean(loadInNewLayerKey, false);
    }

    protected final String decodeParam(String param) {
        try {
            return URLDecoder.decode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public static class RequestHandlerForbiddenException
    extends RequestHandlerException {
        public RequestHandlerForbiddenException(String message) {
            super(message);
        }
    }

    public static class RequestHandlerBadRequestException
    extends RequestHandlerException {
        public RequestHandlerBadRequestException(String message) {
            super(message);
        }

        public RequestHandlerBadRequestException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RequestHandlerErrorException
    extends RequestHandlerException {
        public RequestHandlerErrorException(Throwable cause) {
            super(cause);
        }
    }

    public static class RequestHandlerException
    extends Exception {
        public RequestHandlerException(String message) {
            super(message);
        }

        public RequestHandlerException(String message, Throwable cause) {
            super(message, cause);
        }

        public RequestHandlerException(Throwable cause) {
            super(cause);
        }

        public RequestHandlerException() {
        }
    }
}

