/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final Set<SimplePrimitiveId> toSelect = new HashSet<SimplePrimitiveId>();

    @Override
    public String getPermissionMessage() {
        String msg = I18n.tr("Remote Control has been asked to load data from the API.", new Object[0]) + "<br>" + I18n.tr("Bounding box: ", new Object[0]) + new BBox(this.minlon, this.minlat, this.maxlon, this.maxlat).toStringCSV(", ");
        if (this.args.containsKey("select") && this.toSelect.size() > 0) {
            msg = msg + "<br>" + I18n.tr("Selection: {0}", this.toSelect.size());
        }
        return msg;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "addtags", "select", "zoom_mode", "changeset_comment", "changeset_source", "search"};
    }

    @Override
    public String getUsage() {
        return "download a bounding box from the API, zoom to the downloaded area and optionally select one or more objects";
    }

    @Override
    public String[] getUsageExamples() {
        return this.getUsageExamples(this.myCommand);
    }

    @Override
    public String[] getUsageExamples(String cmd) {
        if (command.equals(cmd)) {
            return new String[]{"/load_and_zoom?addtags=wikipedia:de=Wei%C3%9Fe_Gasse|maxspeed=5&select=way23071688,way23076176,way23076177,&left=13.740&right=13.741&top=51.05&bottom=51.049", "/load_and_zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999&new_layer=true"};
        }
        return new String[]{"/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999", "/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&search=highway+OR+railway"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        DownloadOsmTask osmTask = new DownloadOsmTask();
        try {
            boolean newLayer = this.isLoadInNewLayer();
            if (command.equals(this.myCommand)) {
                if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
                    Main.info("RemoteControl: download forbidden by preferences");
                } else {
                    Area toDownload = null;
                    if (!newLayer) {
                        Area present = null;
                        DataSet ds = Main.main.getCurrentDataSet();
                        if (ds != null) {
                            present = ds.getDataSourceArea();
                        }
                        if (present != null && !present.isEmpty()) {
                            toDownload = new Area(new Rectangle2D.Double(this.minlon, this.minlat, this.maxlon - this.minlon, this.maxlat - this.minlat));
                            toDownload.subtract(present);
                            if (!toDownload.isEmpty()) {
                                Rectangle2D downloadBounds = toDownload.getBounds2D();
                                this.minlat = downloadBounds.getMinY();
                                this.minlon = downloadBounds.getMinX();
                                this.maxlat = downloadBounds.getMaxY();
                                this.maxlon = downloadBounds.getMaxX();
                            }
                        }
                    }
                    if (toDownload != null && toDownload.isEmpty()) {
                        Main.info("RemoteControl: no download necessary");
                    } else {
                        Future<?> future = osmTask.download(newLayer, new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon), null);
                        Main.worker.submit(new PostDownloadHandler((DownloadTask)osmTask, future));
                    }
                }
            }
        }
        catch (Exception ex) {
            Main.warn("RemoteControl: Error parsing load_and_zoom remote control request:");
            Main.error(ex);
            throw new RequestHandler.RequestHandlerErrorException(ex);
        }
        if (this.args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                @Override
                public void run() {
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (ds == null) {
                        return;
                    }
                    ds.clearSelection();
                }
            });
        }
        final HashSet forTagAdd = new HashSet();
        final Bounds bbox = new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon);
        if (this.args.containsKey("select") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                @Override
                public void run() {
                    HashSet<OsmPrimitive> newSel = new HashSet<OsmPrimitive>();
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (ds == null) {
                        return;
                    }
                    for (SimplePrimitiveId id : LoadAndZoomHandler.this.toSelect) {
                        OsmPrimitive p = ds.getPrimitiveById(id);
                        if (p == null) continue;
                        newSel.add(p);
                        forTagAdd.add(p);
                    }
                    LoadAndZoomHandler.this.toSelect.clear();
                    ds.setSelected(newSel);
                    LoadAndZoomHandler.this.zoom(newSel, bbox);
                    if (Main.isDisplayingMapView() && Main.map.relationListDialog != null) {
                        Main.map.relationListDialog.selectRelations(null);
                        Main.map.relationListDialog.dataChanged(null);
                        Main.map.relationListDialog.selectRelations(Utils.filteredCollection(newSel, Relation.class));
                    }
                }
            });
        } else if (this.args.containsKey("search") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            try {
                final SearchCompiler.Match search = SearchCompiler.compile((String)this.args.get("search"), false, false);
                Main.worker.submit(new Runnable(){

                    @Override
                    public void run() {
                        DataSet ds = Main.main.getCurrentDataSet();
                        Collection<OsmPrimitive> filteredPrimitives = Utils.filter(ds.allPrimitives(), search);
                        ds.setSelected(filteredPrimitives);
                        forTagAdd.addAll(filteredPrimitives);
                        LoadAndZoomHandler.this.zoom(filteredPrimitives, bbox);
                    }
                });
            }
            catch (SearchCompiler.ParseError ex) {
                Main.error(ex);
                throw new RequestHandler.RequestHandlerErrorException(ex);
            }
        } else {
            this.zoom(Collections.emptySet(), bbox);
        }
        if (this.args.containsKey("changeset_comment") || this.args.containsKey("changeset_source")) {
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    if (Main.main.getCurrentDataSet() != null) {
                        if (LoadAndZoomHandler.this.args.containsKey("changeset_comment")) {
                            Main.main.getCurrentDataSet().addChangeSetTag("comment", (String)LoadAndZoomHandler.this.args.get("changeset_comment"));
                        }
                        if (LoadAndZoomHandler.this.args.containsKey("changeset_source")) {
                            Main.main.getCurrentDataSet().addChangeSetTag("source", (String)LoadAndZoomHandler.this.args.get("changeset_source"));
                        }
                    }
                }
            });
        }
        AddTagsDialog.addTags(this.args, this.sender, forTagAdd);
    }

    protected void zoom(Collection<OsmPrimitive> primitives, final Bounds bbox) {
        if (!PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            return;
        }
        if (!"download".equals(this.args.get("zoom_mode")) && !primitives.isEmpty()) {
            AutoScaleAction.autoScale("selection");
        } else if (Main.isDisplayingMapView()) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                @Override
                public void run() {
                    BoundingXYVisitor bbox1 = new BoundingXYVisitor();
                    bbox1.visit(bbox);
                    Main.map.mapView.zoomTo(bbox1);
                }
            });
        }
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.minlat = 0.0;
        this.maxlat = 0.0;
        this.minlon = 0.0;
        this.maxlon = 0.0;
        try {
            this.minlat = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("bottom")));
            this.maxlat = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("top")));
            this.minlon = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("left")));
            this.maxlon = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("right")));
        }
        catch (NumberFormatException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + e.getMessage() + ")");
        }
        if (!LatLon.isValidLat(this.minlat) || !LatLon.isValidLat(this.maxlat)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The latitudes must be between {0} and {1}", -90.0, 90.0));
        }
        if (!LatLon.isValidLon(this.minlon) || !LatLon.isValidLon(this.maxlon)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The longitudes must be between {0} and {1}", -180.0, 180.0));
        }
        if (this.minlat > this.maxlat || this.minlon > this.maxlon) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The minima must be less than the maxima", new Object[0]));
        }
        if (this.args.containsKey("select")) {
            this.toSelect.clear();
            for (String item : ((String)this.args.get("select")).split(",")) {
                try {
                    this.toSelect.add(SimplePrimitiveId.fromString(item));
                }
                catch (IllegalArgumentException ex) {
                    Main.warn("RemoteControl: invalid selection '" + item + "' ignored");
                }
            }
        }
    }
}

