/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ImportHandler
extends RequestHandler {
    public static final String command = "import";
    private URL url;
    private Collection<DownloadTask> suitableDownloadTasks;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
                this.suitableDownloadTasks.iterator().next().loadUrl(this.isLoadInNewLayer(), this.url.toExternalForm(), null);
            }
        }
        catch (Exception ex) {
            Main.warn("RemoteControl: Error parsing import remote control request:");
            Main.error(ex);
            throw new RequestHandler.RequestHandlerErrorException(ex);
        }
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer"};
    }

    @Override
    public String getUsage() {
        return "downloads the specified OSM file and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/import?url=" + Main.getJOSMWebsite() + "/browser/josm/trunk/data_nodist/direction-arrows.osm"};
    }

    @Override
    public String getPermissionMessage() {
        String taskMessage = null;
        if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
            taskMessage = this.suitableDownloadTasks.iterator().next().getConfirmationMessage(this.url);
        }
        return I18n.tr("Remote Control has been asked to import data from the following URL:", new Object[0]) + "<br>" + (taskMessage == null ? this.url.toString() : taskMessage);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void parseArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.request.indexOf(63) != -1) {
            String query = this.request.substring(this.request.indexOf(63) + 1);
            if (query.indexOf("url=") == 0) {
                args.put("url", this.decodeParam(query.substring(4)));
            } else {
                String[] params;
                int urlIdx = query.indexOf("&url=");
                if (urlIdx != -1) {
                    args.put("url", this.decodeParam(query.substring(urlIdx + 5)));
                    query = query.substring(0, urlIdx);
                } else if (query.indexOf(35) != -1) {
                    query = query.substring(0, query.indexOf(35));
                }
                for (String param : params = query.split("&", -1)) {
                    int eq = param.indexOf(61);
                    if (eq == -1) continue;
                    args.put(param.substring(0, eq), param.substring(eq + 1));
                }
            }
        }
        this.args = args;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String urlString = (String)this.args.get("url");
        if (Main.pref.getBoolean("remotecontrol.importhandler.fix_url_query", true)) {
            urlString = Utils.fixURLQuery(urlString);
        }
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("MalformedURLException: " + e.getMessage(), e);
        }
        this.suitableDownloadTasks = Main.main.menu.openLocation.findDownloadTasks(urlString, true);
        if (this.suitableDownloadTasks.isEmpty()) {
            this.suitableDownloadTasks.add(new DownloadOsmTask());
        }
    }
}

