/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AddWayHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.FeaturesHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadDataHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadObjectHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenFileHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;
import org.openstreetmap.josm.tools.Utils;

public class RequestProcessor
extends Thread {
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 7}, \"application\": \"JOSM RemoteControl\"}";
    private Socket request;
    private static Map<String, Class<? extends RequestHandler>> handlers = new TreeMap<String, Class<? extends RequestHandler>>();

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = request;
    }

    public static void processRequest(Socket request) {
        RequestProcessor processor = new RequestProcessor(request);
        processor.start();
    }

    static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler) {
        RequestProcessor.addRequestHandlerClass(command, handler, false);
    }

    private static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler, boolean silent) {
        String commandWithSlash;
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        if (handlers.get(commandWithSlash = "/" + command) != null) {
            Main.info("RemoteControl: ignoring duplicate command " + command + " with handler " + handler.getName());
        } else {
            if (!silent) {
                Main.info("RemoteControl: adding command \"" + command + "\" (handled by " + handler.getSimpleName() + ")");
            }
            handlers.put(commandWithSlash, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStreamWriter out = null;
        try {
            BufferedOutputStream raw = new BufferedOutputStream(this.request.getOutputStream());
            out = new OutputStreamWriter((OutputStream)raw, StandardCharsets.UTF_8);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.request.getInputStream(), "ASCII"));
            String get = in.readLine();
            if (get == null) {
                this.sendError(out);
                return;
            }
            Main.info("RemoteControl received: " + get);
            StringTokenizer st = new StringTokenizer(get);
            if (!st.hasMoreTokens()) {
                this.sendError(out);
                return;
            }
            String method = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.sendError(out);
                return;
            }
            String url = st.nextToken();
            if (!"GET".equals(method)) {
                this.sendNotImplemented(out);
                return;
            }
            int questionPos = url.indexOf(63);
            String command = questionPos < 0 ? url : url.substring(0, questionPos);
            HashMap<String, String> headers = new HashMap<String, String>();
            int MAX_HEADERS = 20;
            for (int k = 0; k < MAX_HEADERS && (get = in.readLine()) != null; ++k) {
                String[] h = get.split(": ", 2);
                if (h.length != 2) break;
                headers.put(h[0], h[1]);
            }
            String sender = null;
            if (!this.request.getInetAddress().isLoopbackAddress()) {
                sender = this.request.getInetAddress().getHostAddress();
            } else {
                Matcher m;
                String ref = (String)headers.get("Referer");
                Pattern r = Pattern.compile("(https?://)?([^/]*)");
                if (ref != null && (m = r.matcher(ref)).find()) {
                    sender = m.group(2);
                }
                if (sender == null) {
                    sender = "localhost";
                }
            }
            Class<? extends RequestHandler> handlerClass = handlers.get(command);
            if (handlerClass == null) {
                String usage = RequestProcessor.getUsageAsHtml();
                String websiteDoc = HelpUtil.getWikiBaseHelpUrl() + "/Help/Preferences/RemoteControl";
                String help = "No command specified! The following commands are available:<ul>" + usage + "</ul>" + "See <a href=\"" + websiteDoc + "\">" + websiteDoc + "</a> for complete documentation.";
                this.sendBadRequest(out, help);
            } else {
                RequestHandler handler = handlerClass.newInstance();
                try {
                    handler.setCommand(command);
                    handler.setUrl(url);
                    handler.setSender(sender);
                    handler.handle();
                    this.sendHeader(out, "200 OK", handler.getContentType(), false);
                    out.write("Content-length: " + handler.getContent().length() + "\r\n");
                    out.write("\r\n");
                    out.write(handler.getContent());
                    ((Writer)out).flush();
                }
                catch (RequestHandler.RequestHandlerErrorException ex) {
                    this.sendError(out);
                }
                catch (RequestHandler.RequestHandlerBadRequestException ex) {
                    this.sendBadRequest(out, ex.getMessage());
                }
                catch (RequestHandler.RequestHandlerForbiddenException ex) {
                    this.sendForbidden(out, ex.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            Main.debug(Main.getErrorMessage(ioe));
        }
        catch (Exception e) {
            Main.error(e);
            try {
                this.sendError(out);
            }
            catch (IOException e1) {
                Main.warn(e1);
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException e) {
                Main.debug(Main.getErrorMessage(e));
            }
        }
    }

    private void sendError(Writer out) throws IOException {
        this.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 500: Internal Server Error</H1>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendNotImplemented(Writer out) throws IOException {
        this.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendForbidden(Writer out, String help) throws IOException {
        this.sendHeader(out, "403 Forbidden", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        if (help != null) {
            out.write(help);
        }
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendBadRequest(Writer out, String help) throws IOException {
        this.sendHeader(out, "400 Bad Request", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        if (help != null) {
            out.write(help);
        }
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        Date now = new Date();
        out.write("Date: " + now + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "\r\n");
        out.write("Access-Control-Allow-Origin: *\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    public static String getHandlersInfoAsJSON() {
        StringBuilder r = new StringBuilder();
        boolean first = true;
        r.append("[");
        for (Map.Entry<String, Class<? extends RequestHandler>> p : handlers.entrySet()) {
            if (first) {
                first = false;
            } else {
                r.append(", ");
            }
            r.append(RequestProcessor.getHandlerInfoAsJSON(p.getKey()));
        }
        r.append("]");
        return r.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHandlerInfoAsJSON(String cmd) {
        try (StringWriter w = new StringWriter();){
            PrintWriter r = new PrintWriter(w);
            RequestHandler handler = null;
            try {
                Class<? extends RequestHandler> c = handlers.get(cmd);
                if (c == null) {
                    String string = null;
                    return string;
                }
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Main.error(ex);
                String string = null;
                if (w == null) return string;
                if (var2_3 == null) {
                    w.close();
                    return string;
                }
                try {
                    w.close();
                    return string;
                }
                catch (Throwable x2) {
                    var2_3.addSuppressed(x2);
                    return string;
                }
            }
            {
                handler = handlers.get(cmd).newInstance();
            }
            RequestProcessor.printJsonInfo(cmd, r, handler);
            String string = w.toString();
            return string;
        }
        catch (IOException e) {
            Main.error(e);
            return null;
        }
    }

    private static void printJsonInfo(String cmd, PrintWriter r, RequestHandler handler) {
        r.printf("{ \"request\" : \"%s\"", cmd);
        if (handler.getUsage() != null) {
            r.printf(", \"usage\" : \"%s\"", handler.getUsage());
        }
        r.append(", \"parameters\" : [");
        String[] params = handler.getMandatoryParams();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(params[i]).append('\"');
            }
        }
        r.append("], \"optional\" : [");
        String[] optional = handler.getOptionalParams();
        if (optional != null) {
            for (int i = 0; i < optional.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(optional[i]).append('\"');
            }
        }
        r.append("], \"examples\" : [");
        String[] examples = handler.getUsageExamples(cmd.substring(1));
        if (examples != null) {
            for (int i = 0; i < examples.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(examples[i]).append('\"');
            }
        }
        r.append("]}");
    }

    public static String getUsageAsHtml() throws IllegalAccessException, InstantiationException {
        StringBuilder usage = new StringBuilder(1024);
        for (Map.Entry<String, Class<? extends RequestHandler>> handler : handlers.entrySet()) {
            RequestHandler sample = handler.getValue().newInstance();
            String[] mandatory = sample.getMandatoryParams();
            String[] optional = sample.getOptionalParams();
            String[] examples = sample.getUsageExamples(handler.getKey().substring(1));
            usage.append("<li>");
            usage.append(handler.getKey());
            if (sample.getUsage() != null && !sample.getUsage().isEmpty()) {
                usage.append(" &mdash; <i>").append(sample.getUsage()).append("</i>");
            }
            if (mandatory != null) {
                usage.append("<br/>mandatory parameters: ").append(Utils.join(", ", Arrays.asList(mandatory)));
            }
            if (optional != null) {
                usage.append("<br/>optional parameters: ").append(Utils.join(", ", Arrays.asList(optional)));
            }
            if (examples != null) {
                usage.append("<br/>examples: ");
                for (String ex : examples) {
                    usage.append("<br/> <a href=\"http://localhost:8111" + ex + "\">" + ex + "</a>");
                }
            }
            usage.append("</li>");
        }
        return usage.toString();
    }

    static {
        RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("load_data", LoadDataHandler.class, true);
        RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_way", AddWayHandler.class, true);
        RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
        RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
        RequestProcessor.addRequestHandlerClass("load_object", LoadObjectHandler.class, true);
        RequestProcessor.addRequestHandlerClass("open_file", OpenFileHandler.class, true);
        RequestProcessor.addRequestHandlerClass("features", FeaturesHandler.class, true);
    }
}

