/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.io.remotecontrol.DNSName;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class RemoteControlHttpsServer
extends Thread {
    private ServerSocket server;
    private static volatile RemoteControlHttpsServer instance;
    private boolean initOK = false;
    private SSLContext sslContext;
    public static final String KEYSTORE_FILENAME = "josm.keystore";
    public static final StringProperty KEYSTORE_PASSWORD;
    public static final StringProperty KEYENTRY_PASSWORD;
    public static final String ENTRY_ALIAS = "josm_localhost";

    private static GeneralName createGeneralName(String t, String v) throws IOException {
        GeneralNameInterface gn;
        switch (t.toLowerCase()) {
            case "uri": {
                gn = new URIName(v);
                break;
            }
            case "dns": {
                gn = new DNSName(v);
                break;
            }
            case "ip": {
                gn = new IPAddressName(v);
                break;
            }
            default: {
                gn = new OIDName(v);
            }
        }
        return new GeneralName(gn);
    }

    private static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm, String san) throws GeneralSecurityException, IOException {
        PrivateKey privkey = pair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        if (!Main.isJava8orLater()) {
            info.set("subject", new CertificateSubjectName(owner));
            info.set("issuer", new CertificateIssuerName(owner));
        } else {
            info.set("subject", owner);
            info.set("issuer", owner);
        }
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        CertificateExtensions ext = new CertificateExtensions();
        ext.set("BasicConstraints", new BasicConstraintsExtension(true, false, 0));
        ext.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension((Boolean)true, new Vector<ObjectIdentifier>(Arrays.asList(new ObjectIdentifier("1.3.6.1.5.5.7.3.1")))));
        if (san != null) {
            String[] ps = san.split(",");
            GeneralNames gnames = new GeneralNames();
            for (String item : ps) {
                int colonpos = item.indexOf(58);
                if (colonpos < 0) {
                    throw new IllegalArgumentException("Illegal item " + item + " in " + san);
                }
                String t = item.substring(0, colonpos);
                String v = item.substring(colonpos + 1);
                gnames.add(RemoteControlHttpsServer.createGeneralName(t, v));
            }
            ext.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)false, gnames));
        }
        info.set("extensions", ext);
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        return cert;
    }

    public static Path setupJosmKeystore() throws IOException, GeneralSecurityException {
        char[] storePassword = KEYSTORE_PASSWORD.get().toCharArray();
        char[] entryPassword = KEYENTRY_PASSWORD.get().toCharArray();
        Path dir = Paths.get(RemoteControl.getRemoteControlDir(), new String[0]);
        Path path = dir.resolve(KEYSTORE_FILENAME);
        Files.createDirectories(dir, new FileAttribute[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Main.debug("No keystore found, creating a new one");
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            KeyPair pair = generator.generateKeyPair();
            X509Certificate cert = RemoteControlHttpsServer.generateCertificate("CN=localhost, OU=JOSM, O=OpenStreetMap", pair, 1825, "SHA256withRSA", "dns:localhost,ip:127.0.0.1,dns:127.0.0.1,ip:::1,uri:https://127.0.0.1:8112,uri:https://::1:8112");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
            SecureRandom random = new SecureRandom();
            KEYSTORE_PASSWORD.put(new BigInteger(130, random).toString(32));
            KEYENTRY_PASSWORD.put(new BigInteger(130, random).toString(32));
            storePassword = KEYSTORE_PASSWORD.get().toCharArray();
            entryPassword = KEYENTRY_PASSWORD.get().toCharArray();
            ks.setKeyEntry(ENTRY_ALIAS, pair.getPrivate(), entryPassword, new Certificate[]{cert});
            ks.store(Files.newOutputStream(path, StandardOpenOption.CREATE), storePassword);
        }
        return path;
    }

    public static KeyStore loadJosmKeystore() throws IOException, GeneralSecurityException {
        try (InputStream in = Files.newInputStream(RemoteControlHttpsServer.setupJosmKeystore(), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, KEYSTORE_PASSWORD.get().toCharArray());
            if (Main.isDebugEnabled()) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    Main.debug("Alias in JOSM keystore: " + aliases.nextElement());
                }
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private void initialize() {
        if (!this.initOK) {
            try {
                KeyStore ks = RemoteControlHttpsServer.loadJosmKeystore();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, KEYENTRY_PASSWORD.get().toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                this.sslContext = SSLContext.getInstance("TLS");
                this.sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                if (Main.isTraceEnabled()) {
                    Main.trace("SSL Context protocol: " + this.sslContext.getProtocol());
                    Main.trace("SSL Context provider: " + this.sslContext.getProvider());
                }
                RemoteControlHttpsServer.setupPlatform(ks);
                this.initOK = true;
            }
            catch (IOException | GeneralSecurityException e) {
                Main.error(e);
            }
        }
    }

    public static boolean setupPlatform(KeyStore josmKs) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Enumeration<String> aliases = josmKs.aliases();
        if (aliases.hasMoreElements()) {
            return Main.platform.setupHttpsCertificate(ENTRY_ALIAS, new KeyStore.TrustedCertificateEntry(josmKs.getCertificate(aliases.nextElement())));
        }
        return false;
    }

    public static void restartRemoteControlHttpsServer() {
        int port = Main.pref.getInteger("remote.control.https.port", 8112);
        try {
            RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            if (RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.get().booleanValue()) {
                instance = new RemoteControlHttpsServer(port);
                if (RemoteControlHttpsServer.instance.initOK) {
                    instance.start();
                }
            }
        }
        catch (BindException ex) {
            Main.warn(I18n.marktr("Cannot start remotecontrol https server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
        }
        catch (IOException ioe) {
            Main.error(ioe);
        }
        catch (NoSuchAlgorithmException e) {
            Main.error(e);
        }
    }

    public static void stopRemoteControlHttpsServer() {
        if (instance != null) {
            try {
                instance.stopServer();
                instance = null;
            }
            catch (IOException ioe) {
                Main.error(ioe);
            }
        }
    }

    public RemoteControlHttpsServer(int port) throws IOException, NoSuchAlgorithmException {
        super("RemoteControl HTTPS Server");
        this.setDaemon(true);
        this.initialize();
        if (!this.initOK) {
            Main.error(I18n.tr("Unable to initialize Remote Control HTTPS Server", new Object[0]));
            return;
        }
        SSLServerSocketFactory factory = this.sslContext.getServerSocketFactory();
        if (Main.isTraceEnabled()) {
            Main.trace("SSL factory - Supported Cipher suites: " + Arrays.toString(factory.getSupportedCipherSuites()));
        }
        this.server = factory.createServerSocket(port, 1, RemoteControl.getInetAddress());
        if (Main.isTraceEnabled() && this.server instanceof SSLServerSocket) {
            SSLServerSocket sslServer = (SSLServerSocket)this.server;
            Main.trace("SSL server - Enabled Cipher suites: " + Arrays.toString(sslServer.getEnabledCipherSuites()));
            Main.trace("SSL server - Enabled Protocols: " + Arrays.toString(sslServer.getEnabledProtocols()));
            Main.trace("SSL server - Enable Session Creation: " + sslServer.getEnableSessionCreation());
            Main.trace("SSL server - Need Client Auth: " + sslServer.getNeedClientAuth());
            Main.trace("SSL server - Want Client Auth: " + sslServer.getWantClientAuth());
            Main.trace("SSL server - Use Client Mode: " + sslServer.getUseClientMode());
        }
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting secure connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    if (Main.isTraceEnabled() && request instanceof SSLSocket) {
                        SSLSocket sslSocket = (SSLSocket)request;
                        Main.trace("SSL socket - Enabled Cipher suites: " + Arrays.toString(sslSocket.getEnabledCipherSuites()));
                        Main.trace("SSL socket - Enabled Protocols: " + Arrays.toString(sslSocket.getEnabledProtocols()));
                        Main.trace("SSL socket - Enable Session Creation: " + sslSocket.getEnableSessionCreation());
                        Main.trace("SSL socket - Need Client Auth: " + sslSocket.getNeedClientAuth());
                        Main.trace("SSL socket - Want Client Auth: " + sslSocket.getWantClientAuth());
                        Main.trace("SSL socket - Use Client Mode: " + sslSocket.getUseClientMode());
                        Main.trace("SSL socket - Session: " + sslSocket.getSession());
                    }
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException se) {
                if (this.server.isClosed()) continue;
                Main.error(se);
                continue;
            }
            catch (IOException ioe) {
                Main.error(ioe);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        if (this.server != null) {
            this.server.close();
            Main.info(I18n.marktr("RemoteControl::Server (https) stopped."));
        }
    }

    static {
        KEYSTORE_PASSWORD = new StringProperty("remotecontrol.https.keystore.password", "");
        KEYENTRY_PASSWORD = new StringProperty("remotecontrol.https.keyentry.password", "");
    }
}

