/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;

public class RemoteControlHttpServer
extends Thread {
    private ServerSocket server;
    private static volatile RemoteControlHttpServer instance;

    public static void restartRemoteControlHttpServer() {
        int port = Main.pref.getInteger("remote.control.port", 8111);
        try {
            RemoteControlHttpServer.stopRemoteControlHttpServer();
            instance = new RemoteControlHttpServer(port);
            instance.start();
        }
        catch (BindException ex) {
            Main.warn(I18n.marktr("Cannot start remotecontrol server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
        }
        catch (IOException ioe) {
            Main.error(ioe);
        }
    }

    public static void stopRemoteControlHttpServer() {
        if (instance != null) {
            try {
                instance.stopServer();
                instance = null;
            }
            catch (IOException ioe) {
                Main.error(ioe);
            }
        }
    }

    public RemoteControlHttpServer(int port) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(port, 1, RemoteControl.getInetAddress());
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException se) {
                if (this.server.isClosed()) continue;
                Main.error(se);
                continue;
            }
            catch (IOException ioe) {
                Main.error(ioe);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
        Main.info(I18n.marktr("RemoteControl::Server stopped."));
    }
}

