/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpServer;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpsServer;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;

public class RemoteControl {
    public static final BooleanProperty PROP_REMOTECONTROL_ENABLED = new BooleanProperty("remotecontrol.enabled", false);
    public static final BooleanProperty PROP_REMOTECONTROL_HTTPS_ENABLED = new BooleanProperty("remotecontrol.https.enabled", false);

    public static void start() {
        RemoteControlHttpServer.restartRemoteControlHttpServer();
        RemoteControlHttpsServer.restartRemoteControlHttpsServer();
    }

    public static void stop() {
        RemoteControlHttpServer.stopRemoteControlHttpServer();
        RemoteControlHttpsServer.stopRemoteControlHttpsServer();
    }

    public void addRequestHandler(String command, Class<? extends RequestHandler> handlerClass) {
        RequestProcessor.addRequestHandlerClass(command, handlerClass);
    }

    public static String getRemoteControlDir() {
        return new File(Main.pref.getUserDataDirectory(), "remotecontrol").getAbsolutePath();
    }

    public static InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(Main.pref.get("remote.control.host", null));
    }
}

