/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AddTagsDialog
extends ExtendedDialog {
    private final JTable propertyTable;
    private final Collection<? extends OsmPrimitive> sel;
    private final int[] count;
    private final String sender;
    private static final Set<String> trustedSenders = new HashSet<String>();

    public AddTagsDialog(String[][] tags, String senderName, Collection<? extends OsmPrimitive> primitives) {
        super(Main.parent, I18n.tr("Add tags to selected objects", new Object[0]), new String[]{I18n.tr("Add selected tags", new Object[0]), I18n.tr("Add all tags", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, true);
        this.setToolTipTexts(new String[]{I18n.tr("Add checked tags to selected objects", new Object[0]), I18n.tr("Shift+Enter: Add all tags to selected objects", new Object[0]), ""});
        this.sender = senderName;
        DefaultTableModel tm = new DefaultTableModel(new String[]{I18n.tr("Assume", new Object[0]), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0]), I18n.tr("Existing values", new Object[0])}, tags.length){
            final Class<?>[] types;
            {
                this.types = new Class[]{Boolean.class, String.class, Object.class, ExistingValues.class};
            }

            @Override
            public Class<?> getColumnClass(int c) {
                return this.types[c];
            }
        };
        this.sel = primitives;
        this.count = new int[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            this.count[i] = 0;
            String key = tags[i][0];
            String value = tags[i][1];
            Boolean b = Boolean.TRUE;
            ExistingValues old = new ExistingValues(key);
            for (OsmPrimitive osmPrimitive : this.sel) {
                String oldValue = osmPrimitive.get(key);
                if (oldValue == null) continue;
                old.addValue(oldValue);
                if (oldValue.equals(value)) continue;
                b = Boolean.FALSE;
                int n = i;
                this.count[n] = this.count[n] + 1;
            }
            tm.setValueAt(b, i, 0);
            tm.setValueAt(tags[i][0], i, 1);
            tm.setValueAt(tags[i][1].isEmpty() ? new DeleteTagMarker(this.count[i]) : tags[i][1], i, 2);
            tm.setValueAt(old, i, 3);
        }
        this.propertyTable = new JTable(tm){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (AddTagsDialog.this.count[row] > 0) {
                    c.setFont(c.getFont().deriveFont(2));
                    c.setForeground(new Color(100, 100, 100));
                } else {
                    c.setFont(c.getFont().deriveFont(0));
                    c.setForeground(new Color(0, 0, 0));
                }
                return c;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                Object value = this.getValueAt(row, column);
                if (value instanceof DeleteTagMarker) {
                    return null;
                }
                if (value instanceof ExistingValues) {
                    return null;
                }
                return this.getDefaultEditor(value.getClass());
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int r = this.rowAtPoint(event.getPoint());
                int c = this.columnAtPoint(event.getPoint());
                Object o = this.getValueAt(r, c);
                if (c == 1 || c == 2) {
                    return o.toString();
                }
                if (c == 3) {
                    return ((ExistingValues)o).getToolTip();
                }
                return I18n.tr("Enable the checkbox to accept the value", new Object[0]);
            }
        };
        this.propertyTable.setAutoResizeMode(3);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(15);
        TableHelper.adjustColumnWidth(this.propertyTable, 1, 150);
        TableHelper.adjustColumnWidth(this.propertyTable, 2, 400);
        TableHelper.adjustColumnWidth(this.propertyTable, 3, 300);
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyTable.getInputMap().put(KeyStroke.getKeyStroke(10, 1), "shiftenter");
        this.propertyTable.getActionMap().put("shiftenter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTagsDialog.this.buttonAction(1, e);
            }
        });
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        tablePanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        if (!this.sender.isEmpty() && !trustedSenders.contains(this.sender)) {
            final JCheckBox c = new JCheckBox();
            c.setAction(new AbstractAction(I18n.tr("Accept all tags from {0} for this session", this.sender)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (c.isSelected()) {
                        trustedSenders.add(AddTagsDialog.this.sender);
                    } else {
                        trustedSenders.remove(AddTagsDialog.this.sender);
                    }
                }
            });
            tablePanel.add((Component)c, GBC.eol().insets(20, 10, 0, 0));
        }
        this.setContent(tablePanel);
        this.setDefaultButton(2);
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (Main.main.getCurrentDataSet() != null && buttonIndex != 2) {
            TableModel tm = this.propertyTable.getModel();
            for (int i = 0; i < tm.getRowCount(); ++i) {
                if (buttonIndex != 1 && !((Boolean)tm.getValueAt(i, 0)).booleanValue()) continue;
                String key = (String)tm.getValueAt(i, 1);
                Object value = tm.getValueAt(i, 2);
                Main.main.undoRedo.add(new ChangePropertyCommand(this.sel, key, value instanceof String ? (String)value : ""));
            }
        }
        if (buttonIndex == 2) {
            trustedSenders.remove(this.sender);
        }
        this.setVisible(false);
    }

    public static void addTags(final Map<String, String> args, final String sender, final Collection<? extends OsmPrimitive> primitives) {
        if (args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                @Override
                public void run() {
                    String[] tags = null;
                    try {
                        tags = URLDecoder.decode((String)args.get("addtags"), "UTF-8").split("\\|");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    HashSet<String> tagSet = new HashSet<String>();
                    for (String tag : tags) {
                        if (tag.trim().isEmpty() || !tag.contains("=")) continue;
                        tagSet.add(tag.trim());
                    }
                    if (!tagSet.isEmpty()) {
                        String[][] keyValue = new String[tagSet.size()][2];
                        int i = 0;
                        for (String tag : tagSet) {
                            String[] pair = tag.split("\\s*=\\s*", 2);
                            keyValue[i][0] = pair[0];
                            keyValue[i][1] = pair.length < 2 ? "" : pair[1];
                            ++i;
                        }
                        AddTagsDialog.addTags(keyValue, sender, (Collection<? extends OsmPrimitive>)primitives);
                    }
                }
            });
        }
    }

    public static void addTags(String[][] keyValue, String sender, Collection<? extends OsmPrimitive> primitives) {
        if (trustedSenders.contains(sender)) {
            if (Main.main.getCurrentDataSet() != null) {
                for (String[] row : keyValue) {
                    Main.main.undoRedo.add(new ChangePropertyCommand(primitives, row[0], row[1]));
                }
            }
        } else {
            new AddTagsDialog(keyValue, sender, primitives).showDialog();
        }
    }

    static class ExistingValues {
        String tag;
        Map<String, Integer> valueCount;

        public ExistingValues(String tag) {
            this.tag = tag;
            this.valueCount = new HashMap<String, Integer>();
        }

        int addValue(String val) {
            Integer c = this.valueCount.get(val);
            int r = c == null ? 1 : c + 1;
            this.valueCount.put(val, r);
            return r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String k : this.valueCount.keySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(k);
            }
            return sb.toString();
        }

        private String getToolTip() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(I18n.tr("Old values of", new Object[0]));
            sb.append(" <b>");
            sb.append(this.tag);
            sb.append("</b><br/>");
            for (String k : this.valueCount.keySet()) {
                sb.append("<b>");
                sb.append(this.valueCount.get(k));
                sb.append(" x </b>");
                sb.append(k);
                sb.append("<br/>");
            }
            sb.append("</html>");
            return sb.toString();
        }
    }

    static class DeleteTagMarker {
        int num;

        public DeleteTagMarker(int num) {
            this.num = num;
        }

        public String toString() {
            return I18n.tr("<delete from {0} objects>", this.num);
        }
    }
}

