/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSImagery {
    private List<LayerDetails> layers;
    private URL serviceUrl;
    private List<String> formats;

    public List<LayerDetails> getLayers() {
        return this.layers;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public List<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public String getPreferredFormats() {
        return this.formats.contains("image/jpeg") ? "image/jpeg" : (this.formats.contains("image/png") ? "image/png" : (this.formats.isEmpty() ? null : this.formats.get(0)));
    }

    String buildRootUrl() {
        if (this.serviceUrl == null) {
            return null;
        }
        StringBuilder a = new StringBuilder(this.serviceUrl.getProtocol());
        a.append("://");
        a.append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            a.append(":");
            a.append(this.serviceUrl.getPort());
        }
        a.append(this.serviceUrl.getPath());
        a.append("?");
        if (this.serviceUrl.getQuery() != null) {
            a.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                a.append("&");
            }
        }
        return a.toString();
    }

    public String buildGetMapUrl(Collection<LayerDetails> selectedLayers) {
        return this.buildGetMapUrl(selectedLayers, "image/jpeg");
    }

    public String buildGetMapUrl(Collection<LayerDetails> selectedLayers, String format) {
        return this.buildRootUrl() + "FORMAT=" + format + (WMSImagery.imageFormatHasTransparency(format) ? "&TRANSPARENT=TRUE" : "") + "&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&LAYERS=" + Utils.join(",", Utils.transform(selectedLayers, new Utils.Function<LayerDetails, String>(){

            @Override
            public String apply(LayerDetails x) {
                return x.ident;
            }
        })) + "&STYLES=&SRS={proj}&WIDTH={width}&HEIGHT={height}&BBOX={bbox}";
    }

    public void attemptGetCapabilities(String serviceUrlStr) throws MalformedURLException, IOException, WMSGetCapabilitiesException {
        URL getCapabilitiesUrl = null;
        try {
            if (!Pattern.compile(".*GetCapabilities.*", 2).matcher(serviceUrlStr).matches()) {
                getCapabilitiesUrl = new URL(serviceUrlStr);
                String getCapabilitiesQuery = "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities";
                getCapabilitiesUrl = getCapabilitiesUrl.getQuery() == null ? new URL(serviceUrlStr + "?" + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : (!getCapabilitiesUrl.getQuery().isEmpty() && !getCapabilitiesUrl.getQuery().endsWith("&") ? new URL(serviceUrlStr + "&" + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(serviceUrlStr + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities"));
            } else {
                getCapabilitiesUrl = new URL(serviceUrlStr);
            }
            this.serviceUrl = new URL(serviceUrlStr);
        }
        catch (HeadlessException e) {
            return;
        }
        Main.info("GET " + getCapabilitiesUrl.toString());
        HttpURLConnection openConnection = Utils.openHttpConnection(getCapabilitiesUrl);
        StringBuilder ba = new StringBuilder();
        try (InputStream inputStream = openConnection.getInputStream();
             BufferedReader br = new BufferedReader(UTFInputStreamReader.create(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                ba.append(line);
                ba.append("\n");
            }
        }
        String incomingData = ba.toString();
        Main.debug("Server response to Capabilities request:");
        Main.debug(incomingData);
        try {
            String baseURL;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(false);
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    Main.info("Ignoring DTD " + publicId + ", " + systemId);
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = null;
            document = builder.parse(new InputSource(new StringReader(incomingData)));
            Element child = WMSImagery.getChild(document.getDocumentElement(), "Capability");
            child = WMSImagery.getChild(child, "Request");
            child = WMSImagery.getChild(child, "GetMap");
            this.formats = new ArrayList<String>(Utils.filter(Utils.transform(WMSImagery.getChildren(child, "Format"), new Utils.Function<Element, String>(){

                @Override
                public String apply(Element x) {
                    return x.getTextContent();
                }
            }), new Predicate<String>(){

                @Override
                public boolean evaluate(String format) {
                    boolean isFormatSupported = WMSImagery.isImageFormatSupported(format);
                    if (!isFormatSupported) {
                        Main.info("Skipping unsupported image format {0}", format);
                    }
                    return isFormatSupported;
                }
            }));
            child = WMSImagery.getChild(child, "DCPType");
            child = WMSImagery.getChild(child, "HTTP");
            child = WMSImagery.getChild(child, "Get");
            child = WMSImagery.getChild(child, "OnlineResource");
            if (child != null && (baseURL = child.getAttribute("xlink:href")) != null && !baseURL.equals(serviceUrlStr)) {
                Main.info("GetCapabilities specifies a different service URL: " + baseURL);
                this.serviceUrl = new URL(baseURL);
            }
            Element capabilityElem = WMSImagery.getChild(document.getDocumentElement(), "Capability");
            List<Element> children = WMSImagery.getChildren(capabilityElem, "Layer");
            this.layers = this.parseLayers(children, new HashSet<String>());
        }
        catch (Exception e) {
            throw new WMSGetCapabilitiesException(e, incomingData);
        }
    }

    static boolean isImageFormatSupported(String format) {
        return ImageIO.getImageReadersByMIMEType(format).hasNext() || (format.startsWith("image/tiff") || format.startsWith("image/geotiff")) && ImageIO.getImageReadersBySuffix("tiff").hasNext() || format.startsWith("image/png") && ImageIO.getImageReadersBySuffix("png").hasNext() || format.startsWith("image/svg") && ImageIO.getImageReadersBySuffix("svg").hasNext() || format.startsWith("image/bmp") && ImageIO.getImageReadersBySuffix("bmp").hasNext();
    }

    static boolean imageFormatHasTransparency(String format) {
        return format != null && (format.startsWith("image/png") || format.startsWith("image/gif") || format.startsWith("image/svg") || format.startsWith("image/tiff"));
    }

    public ImageryInfo toImageryInfo(String name, Collection<LayerDetails> selectedLayers) {
        ImageryInfo i = new ImageryInfo(name, this.buildGetMapUrl(selectedLayers));
        if (selectedLayers != null) {
            HashSet<String> proj = new HashSet<String>();
            for (LayerDetails l : selectedLayers) {
                proj.addAll(l.getProjections());
            }
            i.setServerProjections(proj);
        }
        return i;
    }

    private List<LayerDetails> parseLayers(List<Element> children, Set<String> parentCrs) {
        ArrayList<LayerDetails> details = new ArrayList<LayerDetails>(children.size());
        for (Element element : children) {
            details.add(this.parseLayer(element, parentCrs));
        }
        return details;
    }

    private LayerDetails parseLayer(Element element, Set<String> parentCrs) {
        String name = WMSImagery.getChildContent(element, "Title", null, null);
        String ident = WMSImagery.getChildContent(element, "Name", null, null);
        HashSet<String> crsList = new HashSet<String>();
        crsList.addAll(parentCrs);
        List<Element> crsChildren = WMSImagery.getChildren(element, "CRS");
        crsChildren.addAll(WMSImagery.getChildren(element, "SRS"));
        for (Element child : crsChildren) {
            String crs = (String)WMSImagery.getContent(child);
            if (crs.isEmpty()) continue;
            String upperCase = crs.trim().toUpperCase();
            crsList.add(upperCase);
        }
        boolean josmSupportsThisLayer = false;
        for (String crs : crsList) {
            josmSupportsThisLayer |= this.isProjSupported(crs);
        }
        Bounds bounds = null;
        Element bboxElem = WMSImagery.getChild(element, "EX_GeographicBoundingBox");
        if (bboxElem != null) {
            double left = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "westBoundLongitude", null, null));
            double top = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "northBoundLatitude", null, null));
            double right = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "eastBoundLongitude", null, null));
            double bot = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "southBoundLatitude", null, null));
            bounds = new Bounds(bot, left, top, right);
        } else {
            bboxElem = WMSImagery.getChild(element, "LatLonBoundingBox");
            if (bboxElem != null) {
                double left = Double.parseDouble(bboxElem.getAttribute("minx"));
                double top = Double.parseDouble(bboxElem.getAttribute("maxy"));
                double right = Double.parseDouble(bboxElem.getAttribute("maxx"));
                double bot = Double.parseDouble(bboxElem.getAttribute("miny"));
                bounds = new Bounds(bot, left, top, right);
            }
        }
        List<Element> layerChildren = WMSImagery.getChildren(element, "Layer");
        List<LayerDetails> childLayers = this.parseLayers(layerChildren, crsList);
        return new LayerDetails(name, ident, crsList, josmSupportsThisLayer, bounds, childLayers);
    }

    private boolean isProjSupported(String crs) {
        for (ProjectionChoice pc : ProjectionPreference.getProjectionChoices()) {
            if (pc.getPreferencesFromCode(crs) == null) continue;
            return true;
        }
        return false;
    }

    private static String getChildContent(Element parent, String name, String missing, String empty) {
        Element child = WMSImagery.getChild(parent, name);
        if (child == null) {
            return missing;
        }
        String content = (String)WMSImagery.getContent(child);
        return !content.isEmpty() ? content : empty;
    }

    private static Object getContent(Element element) {
        NodeList nl = element.getChildNodes();
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    return node;
                }
                case 3: 
                case 4: {
                    content.append(node.getNodeValue());
                }
            }
        }
        return content.toString().trim();
    }

    private static List<Element> getChildren(Element parent, String name) {
        ArrayList<Element> retVal = new ArrayList<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            retVal.add((Element)child);
        }
        return retVal;
    }

    private static Element getChild(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static class LayerDetails {
        public final String name;
        public final String ident;
        public final List<LayerDetails> children;
        public final Bounds bounds;
        public final Set<String> crsList;
        public final boolean supported;

        public LayerDetails(String name, String ident, Set<String> crsList, boolean supportedLayer, Bounds bounds, List<LayerDetails> childLayers) {
            this.name = name;
            this.ident = ident;
            this.supported = supportedLayer;
            this.children = childLayers;
            this.bounds = bounds;
            this.crsList = crsList;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Set<String> getProjections() {
            return this.crsList;
        }

        public String toString() {
            if (this.name == null || this.name.isEmpty()) {
                return this.ident;
            }
            return this.name;
        }
    }

    public static class WMSGetCapabilitiesException
    extends Exception {
        private final String incomingData;

        public WMSGetCapabilitiesException(Throwable cause, String incomingData) {
            super(cause);
            this.incomingData = incomingData;
        }

        public String getIncomingData() {
            return this.incomingData;
        }
    }
}

